
<?php $__env->startSection('page_title',__('Payment Log')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid bg-light">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get('Payment Log'); ?></a></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Payment Log'); ?></h1>
                </div>
            </div>
        </div>


        <div class="row">
            <div class="col-sm-6 col-lg-3 mb-3 mb-lg-5">
                <div class="card h-100">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><?php echo app('translator')->get("Total Payment Log"); ?></h6>
                        <div class="row align-items-center gx-2">
                            <div class="col">
                                <span class="js-counter display-4 text-dark"><?php echo e(fractionNumber($paymentRecord[0]['totalPaymentLog'], false)); ?></span>
                                <span class="text-body fs-5 ms-1"><?php echo app('translator')->get("From"); ?> <?php echo e(fractionNumber($paymentRecord[0]['totalPaymentLog'], false)); ?></span>
                            </div>
                            <div class="col-auto">
                              <span class="badge bg-soft-info text-info p-1">
                                <i class="bi-graph-up"></i> <?php echo e(fractionNumber($paymentRecord[0]['totalPaymentLog'])); ?>%
                              </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-lg-3 mb-3 mb-lg-5">
                <div class="card h-100">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><?php echo app('translator')->get("Payment Success"); ?></h6>
                        <div class="row align-items-center gx-2">
                            <div class="col">
                                <span class="js-counter display-4 text-dark"><?php echo e($paymentRecord[0]['paymentSuccess']); ?></span>
                                <span class="text-body fs-5 ms-1"><?php echo app('translator')->get("From"); ?> <?php echo e($paymentRecord[0]['totalPaymentLog']); ?></span>
                            </div>
                            <div class="col-auto">
                              <span class="badge bg-soft-success text-success p-1">
                                <i class="bi-graph-up"></i> <?php echo e(fractionNumber($paymentRecord[0]['paymentSuccessPercentage'])); ?>%
                              </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-lg-3 mb-3 mb-lg-5">
                <div class="card h-100">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><?php echo app('translator')->get("Pending Payment"); ?></h6>
                        <div class="row align-items-center gx-2">
                            <div class="col">
                                <span class="js-counter display-4 text-dark"><?php echo e($paymentRecord[0]['pendingPayment']); ?></span>
                                <span class="text-body fs-5 ms-1"><?php echo app('translator')->get("From"); ?> <?php echo e($paymentRecord[0]['totalPaymentLog']); ?></span>
                            </div>

                            <div class="col-auto">
                              <span class="badge bg-soft-warning text-warning p-1">
                                <i class="bi-graph-down"></i> <?php echo e(fractionNumber($paymentRecord[0]['pendingPaymentPercentage'])); ?>%
                              </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-6 col-lg-3 mb-3 mb-lg-5">
                <div class="card h-100">
                    <div class="card-body">
                        <h6 class="card-subtitle mb-2"><?php echo app('translator')->get("Cancel Payment"); ?></h6>
                        <div class="row align-items-center gx-2">
                            <div class="col">
                                <span class="js-counter display-4 text-dark"><?php echo e($paymentRecord[0]['cancelPayment']); ?></span>
                                <span class="text-body fs-5 ms-1"><?php echo app('translator')->get("From"); ?> <?php echo e($paymentRecord[0]['cancelPayment']); ?></span>
                            </div>

                            <div class="col-auto">
                                <span class="badge bg-soft-danger text-danger p-1"><?php echo e(fractionNumber($paymentRecord[0]['cancelPaymentPercentage'])); ?>%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header card-header-content-md-between">
                <div class="mb-2 mb-md-0">
                    <div class="input-group input-group-merge navbar-input-group">
                        <div class="input-group-prepend input-group-text">
                            <i class="bi-search"></i>
                        </div>
                        <input type="search" id="datatableSearch"
                               class="search form-control form-control-sm"
                               placeholder="<?php echo app('translator')->get('Search here'); ?>"
                               aria-label="<?php echo app('translator')->get('Search here'); ?>"
                               autocomplete="off">
                    </div>
                </div>

                <div class="d-grid d-sm-flex justify-content-md-end align-items-sm-center gap-2">
                    <div class="dropdown">
                        <button type="button" class="btn btn-white btn-sm w-100"
                                id="dropdownMenuClickable" data-bs-auto-close="false"
                                id="usersFilterDropdown"
                                data-bs-toggle="dropdown"
                                aria-expanded="false">
                            <i class="bi-filter me-1"></i> <?php echo app('translator')->get('Filter'); ?>
                        </button>

                        <div
                            class="dropdown-menu dropdown-menu-sm-end dropdown-card card-dropdown-filter-centered filter_dropdown"
                            aria-labelledby="dropdownMenuClickable">
                            <div class="card">
                                <div class="card-header card-header-content-between">
                                    <h5 class="card-header-title"><?php echo app('translator')->get('Filter'); ?></h5>
                                    <button type="button" class="btn btn-ghost-secondary btn-icon btn-sm ms-2"
                                            id="filter_close_btn">
                                        <i class="bi-x-lg"></i>
                                    </button>
                                </div>

                                <div class="card-body">
                                    <form id="filter_form">
                                        <div class="row">
                                            <div class="mb-4">
                                                <span class="text-cap text-body"><?php echo app('translator')->get('Transaction ID'); ?></span>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <input type="text" class="form-control"
                                                               id="transaction_id_filter_input"
                                                               autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm mb-4">
                                                <small class="text-cap text-body"><?php echo app('translator')->get('Status'); ?></small>
                                                <div class="tom-select-custom">
                                                    <select
                                                        class="js-select js-datatable-filter form-select form-select-sm"
                                                        id="filter_status"
                                                        data-target-column-index="4" data-hs-tom-select-options='{
                                                                  "placeholder": "Any status",
                                                                  "searchInDropdown": false,
                                                                  "hideSearch": true,
                                                                  "dropdownWidth": "10rem"
                                                                }'>
                                                        <option value="all"
                                                                data-option-template='<span class="d-flex align-items-center"><span class="legend-indicator bg-secondary"></span><?php echo app('translator')->get("All Status"); ?></span>'>
                                                            <?php echo app('translator')->get('All Status'); ?>
                                                        </option>
                                                        <option value="1"
                                                                data-option-template='<span class="d-flex align-items-center"><span class="legend-indicator bg-success"></span><?php echo app('translator')->get("Success"); ?></span>'>
                                                            <?php echo app('translator')->get('Success'); ?>
                                                        </option>
                                                        <option value="2"
                                                                data-option-template='<span class="d-flex align-items-center"><span class="legend-indicator bg-warning"></span><?php echo app('translator')->get("Pending"); ?></span>'>
                                                            <?php echo app('translator')->get('Pending'); ?>
                                                        </option>
                                                        <option value="3"
                                                                data-option-template='<span class="d-flex align-items-center"><span class="legend-indicator bg-danger"></span><?php echo app('translator')->get("Cancel"); ?></span>'>
                                                            <?php echo app('translator')->get('Cancel'); ?>
                                                        </option>
                                                        <option value="4"
                                                                data-option-template='<span class="d-flex align-items-center"><span class="legend-indicator bg-danger"></span><?php echo app('translator')->get("Failed"); ?></span>'>
                                                            <?php echo app('translator')->get('Failed'); ?>
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12 mb-4">
                                                <span class="text-cap text-body"><?php echo app('translator')->get('Method'); ?></span>
                                                <div class="tom-select-custom">
                                                    <select class="js-select form-select" id="filter_method">
                                                        <option value="all"
                                                                data-option-template='<span class="d-flex align-items-center"><img class="avatar avatar-xss avatar-circle me-2" src="<?php echo e(asset("assets/upload/gateway/all_gateway.png")); ?>" alt="..." /><span class="text-truncate"><?php echo app('translator')->get("All Gateway"); ?></span></span>'
                                                        <?php $__empty_1 = true; $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                            <option value="<?php echo app('translator')->get($method->id); ?>"
                                                                    data-option-template='<span class="d-flex align-items-center"><img class="avatar avatar-xss avatar-circle me-2" src="<?php echo e(getFile($method->driver, $method->image)); ?>" alt="Flag" /><span class="text-truncate"><?php echo e($method->name); ?></span></span>'>
                                                                <?php echo app('translator')->get($method->name); ?>
                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <?php endif; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-sm-12 mb-4">
                                                <span class="text-cap text-body"><?php echo app('translator')->get('Date Range'); ?></span>
                                                <div class="input-group mb-3 custom">
                                                    <input type="text" id="filter_date_range"
                                                           class="js-flatpickr form-control"
                                                           placeholder="Select dates"
                                                           data-hs-flatpickr-options='{
                                                                 "dateFormat": "d/m/Y",
                                                                 "mode": "range"
                                                               }' aria-describedby="flatpickr_filter_date_range">
                                                    <span class="input-group-text" id="flatpickr_filter_date_range">
                                                        <i class="bi bi-arrow-counterclockwise"></i>
                                                    </span>
                                                </div>

                                            </div>
                                        </div>


                                        <div class="row gx-2">
                                            <div class="col">
                                                <div class="d-grid">
                                                    <button type="button" id="clear_filter"
                                                            class="btn btn-white"><?php echo app('translator')->get('Clear Filters'); ?></button>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="d-grid">
                                                    <button type="button" class="btn btn-primary"
                                                            id="filter_button"><i
                                                            class="bi-search"></i> <?php echo app('translator')->get('Apply'); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class=" table-responsive datatable-custom  ">
                <table id="datatable"
                       class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                       data-hs-datatables-options='{
                       "columnDefs": [{
                          "targets": [0, 9],
                          "orderable": false
                        }],
                       "order": [],
                       "info": {
                         "totalQty": "#datatableWithPaginationInfoTotalQty"
                       },
                       "search": "#datatableSearch",
                       "entries": "#datatableEntries",
                       "pageLength": 15,
                       "isResponsive": false,
                       "isShowPaging": false,
                       "pagination": "datatablePagination"
                     }'>
                    <thead class="thead-light">
                    <tr>
                        <th><?php echo app('translator')->get('No.'); ?></th>
                        <th><?php echo app('translator')->get('Transaction ID'); ?></th>
                        <th><?php echo app('translator')->get('Name'); ?></th>
                        <th><?php echo app('translator')->get('Method'); ?></th>
                        <th><?php echo app('translator')->get('Amount'); ?></th>
                        <th><?php echo app('translator')->get('Charge'); ?></th>
                        <th><?php echo app('translator')->get('Payable Amount'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        <th><?php echo app('translator')->get('Date'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                    </thead>

                    <tbody>

                    </tbody>
                </table>
            </div>

            <div class="card-footer">
                <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                    <div class="col-sm mb-2 mb-sm-0">
                        <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                            <span class="me-2"><?php echo app('translator')->get('Showing:'); ?></span>
                            <!-- Select -->
                            <div class="tom-select-custom">
                                <select id="datatableEntries"
                                        class="js-select form-select form-select-borderless w-auto" autocomplete="off"
                                        data-hs-tom-select-options='{
                                            "searchInDropdown": false,
                                            "hideSearch": true
                                          }'>
                                    <option value="10">10</option>
                                    <option value="15" selected>15</option>
                                    <option value="20">20</option>
                                </select>
                            </div>
                            <span class="text-secondary me-2">of</span>
                            <span id="datatableWithPaginationInfoTotalQty"></span>
                        </div>
                    </div>


                    <div class="col-sm-auto">
                        <div class="d-flex  justify-content-center justify-content-sm-end">
                            <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <?php echo $__env->make('admin.user_management.components.payment_information_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php $__env->stopSection(); ?>


<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/flatpickr.min.css')); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/flatpickr.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        $(document).on('ready', function () {

            HSCore.components.HSFlatpickr.init('.js-flatpickr')
            HSCore.components.HSTomSelect.init('.js-select', {
                maxOptions: 250,
            })

            HSCore.components.HSDatatables.init($('#datatable'), {
                processing: true,
                serverSide: true,
                ordering: false, 
                ajax: {
                    url: "<?php echo e(route("admin.payment.search")); ?>",
                },

                columns: [
                    {data: 'no', name: 'no'},
                    {data: 'trx', name: 'trx'},
                    {data: 'name', name: 'name'},
                    {data: 'method', name: 'method'},
                    {data: 'amount', name: 'amount'},
                    {data: 'charge', name: 'charge'},
                    {data: 'payable', name: 'payable'},
                    {data: 'status', name: 'status'},
                    {data: 'date', name: 'date'},
                    {data: 'action', name: 'action'},
                ],

                language: {
                    zeroRecords: `<div class="text-center p-4">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                    <p class="mb-0">No data to show</p>
                    </div>`,
                    processing: `<div><div></div><div></div><div></div><div></div></div>`
                },

            });
            $.fn.dataTable.ext.errMode = 'throw';


            document.getElementById("filter_button").addEventListener("click", function () {

                let filterTransactionId = $('#transaction_id_filter_input').val();
                let filterStatus = $('#filter_status').val();
                let filterMethod = $('#filter_method').val();
                let filterDate = $('#filter_date_range').val();


                const datatable = HSCore.components.HSDatatables.getItem(0);
                datatable.ajax.url("<?php echo e(route('admin.payment.search')); ?>" + "?filterTransactionID=" + filterTransactionId + "&filterStatus=" + filterStatus + "&filterMethod=" + filterMethod +
                    "&filterDate=" + filterDate).load();
            });

        });

    </script>

<?php $__env->stopPush(); ?>






<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/payment/logs.blade.php ENDPATH**/ ?>