<?php $__env->startSection('page_title', __('Content Settings')); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">

    <!-- Page Header -->
    <div class="page-header d-flex justify-content-between align-items-center">
        <div>
            <h1 class="page-header-title"><?php echo app('translator')->get('Content Settings'); ?></h1>
        </div>
        <div>
            <a href="<?php echo e(route('admin.contentsetting.create')); ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> <?php echo app('translator')->get('Create New'); ?>
            </a>
        </div>
    </div>

    <!-- Content Settings Table -->
    <div class="card mt-3">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover table-striped mb-0">
                    <thead class="table-light">
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('ID'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Subject'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Type'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Created At'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $contentSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($setting->id); ?></td>
                                <td><?php echo e(Str::limit($setting->subject, 50)); ?></td>
                                <td><?php echo e(Str::title(str_replace('_', ' ', $setting->type))); ?></td>
                                <td><?php echo e($setting->created_at->format('Y-m-d')); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.contentsetting.edit', $setting->id)); ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-pencil-square"></i> <?php echo app('translator')->get('Edit'); ?>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted"><?php echo app('translator')->get('No content settings found.'); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/content_setting/index.blade.php ENDPATH**/ ?>