
<?php $__env->startSection('page_title', __('Home Styles')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid" id="homeStyles">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0)"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                            <li class="breadcrumb-item active"
                                aria-current="page"><?php echo app('translator')->get("Home Style"); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get("Home Styles"); ?></h1>
                </div>
            </div>
        </div>
        <div class="row d-flex justify-content-center">
            <div class="col-10">
                <div class="row d-flex justify-content-center">
                    <div class="col-sm-6 col-lg-4 mb-3 mb-lg-5 ">
                        <div class="select-theme">
                            <label class="form-control" for="formControlRadioReverseEg1">
                      <span class="form-check home_style">
                        <input type="radio" class="form-check-input" name="homeStyle" value="home_one"
                               id="formControlRadioReverseEg1" <?php if(basicControl()->home_style=='home_one'): echo 'checked'; endif; ?>>
                         <img class="img-fluid w-100" src="<?php echo e(asset($themeTrue.'images/home_one.png')); ?>"
                              alt="Image Description">
                      </span>
                            </label>
                        </div>
                        <div class="text-center">
                            <h5 class="mb-0 bg-warning p-3"><?php echo app('translator')->get('Home Style 01'); ?></h5>
                        </div>
                        <!-- End Card -->
                    </div>

                    <div class="col-sm-6 col-lg-4 mb-3 mb-lg-5 ">
                        <label class="form-control" for="formControlRadioReverseEg2">
                      <span class="form-check home_style">
                        <input type="radio" class="form-check-input" name="homeStyle" value="home_two"
                               id="formControlRadioReverseEg2" <?php if(basicControl()->home_style=='home_two'): echo 'checked'; endif; ?>>
                         <img class="img-fluid w-100" src="<?php echo e(asset($themeTrue.'images/home_two.png')); ?>"
                              alt="Image Description">
                      </span>
                        </label>
                        <div class="text-center">
                            <h5 class="mb-0 bg-warning p-3"><?php echo app('translator')->get('Home Style 02'); ?></h5>
                        </div>
                        <!-- End Card -->
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function () {
            // Assuming you want to trigger an event when the radio button is changed
            $('.form-check-input').on('change', function () {
                if ($(this).prop('checked')) {
                    Notiflix.Block.standard('#homeStyles');
                    var radioValue = $(this).val();
                    selectHomeStyle(radioValue)
                }
            });

            async function selectHomeStyle(val) {
                let url = "<?php echo e(route('admin.select.home.style', ['val' => ':val'])); ?>";
                url = url.replace(':val', val);
                await axios.get(url)
                    .then(function (res) {

                        console.log(res)

                        Notiflix.Block.remove('#homeStyles');
                    })
                    .catch(function (error) {

                    });
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/home/index.blade.php ENDPATH**/ ?>