
<?php $__env->startSection('page_title', __('Email Templates')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get("Dashboard"); ?>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                <a class="breadcrumb-link" href="<?php echo e(route('admin.settings')); ?>"><?php echo app('translator')->get('Settings'); ?></a>
                            </li>
                            <li class="breadcrumb-item active"
                                aria-current="page"><?php echo app('translator')->get("Email Templates"); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get("Email Templates"); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-3">
                <?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.'.(url()->previous() == route('admin.settings', 'sms') || url()->previous() == route('admin.sms.controls') ? 'sms' : 'email')), 'suffix' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-lg-9">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header card-header-content-md-between">
                            <div class="mb-2 mb-md-0">
                                <div class="input-group input-group-merge navbar-input-group">
                                    <div class="input-group-prepend input-group-text">
                                        <i class="bi-search"></i>
                                    </div>
                                    <input type="search" id="datatableSearch"
                                           class="search form-control form-control-sm"
                                           placeholder="<?php echo app('translator')->get('Search Notification Templates'); ?>"
                                           aria-label="<?php echo app('translator')->get('Search Notification Templates'); ?>"
                                           autocomplete="off">
                                    <a class="input-group-append input-group-text" href="javascript:void(0)">
                                        <i id="clearSearchResultsIcon" class="bi-x d-none"></i>
                                    </a>
                                </div>
                            </div>
                        </div>

                        <div class=" table-responsive datatable-custom  ">
                            <table id="datatable"
                                   class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                                   data-hs-datatables-options='{
                                       "columnDefs": [{
                                          "targets": [0, 2],
                                          "orderable": false
                                        }],
                                        "ordering": false,
                                       "order": [],
                                       "info": {
                                         "totalQty": "#datatableWithPaginationInfoTotalQty"
                                       },
                                       "search": "#datatableSearch",
                                       "entries": "#datatableEntries",
                                       "pageLength": 10,
                                       "isResponsive": false,
                                       "isShowPaging": false,
                                       "pagination": "datatablePagination"
                                     }'>
                                <thead class="thead-light">
                                <tr>
                                    <th><?php echo app('translator')->get('SL.'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $emailTemplates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(__($loop->index + 1)); ?> </td>
                                        <td><?php echo e(__($template->name)); ?> </td>
                                        <td>
                                            <span class="badge bg-soft-<?php echo e($template->status['mail'] == 1 ? "success" :  "danger"); ?> text-<?php echo e($template->status['mail'] == 1 ? "success" :  "danger"); ?>">
                                                <span class="legend-indicator bg-<?php echo e($template->status['mail'] == 1 ? "success" :  "danger"); ?>"></span> <?php echo e(__($template->status['mail'] == 1 ? "Active" :  "Inactive")); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <a class="btn btn-white btn-sm"
                                               href="<?php echo e(route('admin.email.template.edit', $template->id)); ?>">
                                                <i class="bi-pencil-fill me-1"></i> <?php echo app('translator')->get("Edit"); ?>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <div class="text-center p-4">
                                        <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                                        <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                                        <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                                    </div>
                                </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>


                        <div class="card-footer">
                            <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                                <div class="col-sm mb-2 mb-sm-0">
                                    <div
                                        class="d-flex justify-content-center justify-content-sm-start align-items-center">
                                        <span class="me-2"><?php echo app('translator')->get('Showing:'); ?></span>
                                        <div class="tom-select-custom">
                                            <select id="datatableEntries"
                                                    class="js-select form-select form-select-borderless w-auto"
                                                    autocomplete="off"
                                                    data-hs-tom-select-options='{
                                                        "searchInDropdown": false,
                                                        "hideSearch": true
                                                      }'>
                                                <option value="5">5</option>
                                                <option value="10 selected">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                        <span class="text-secondary me-2"><?php echo app('translator')->get('of'); ?></span>
                                        <span id="datatableWithPaginationInfoTotalQty"></span>
                                    </div>
                                </div>

                                <div class="col-sm-auto">
                                    <div class="d-flex  justify-content-center justify-content-sm-end">
                                        <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>


<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).on('ready', function () {

            HSCore.components.HSTomSelect.init('.js-select');

            $(document).on('click', '.set', function () {
                let url = $(this).data('route');
                let value = $(this).data('value');
                $('.method_value').val(value);
                $('.setRoute').attr('action', url);
            })

            HSCore.components.HSDatatables.init($('#datatable'), {
                language: {
                    zeroRecords: `<div class="text-center p-4">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                    <p class="mb-0">No data to show</p>
                    </div>`,
                },
            })


            $.fn.dataTable.ext.errMode = 'throw';
        });

    </script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/notification_templates/email_template/index.blade.php ENDPATH**/ ?>