
<?php $__env->startSection('page_title', __('Summary')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title"><?php echo app('translator')->get('Summary'); ?></h1>
            </div>
            <div class="col-sm-auto">
                <a href="<?php echo e(route('admin.monthly.plan.index')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Back to List'); ?></a>
                <?php if($status != 1): ?>
                <form method="POST" action="<?php echo e(route('admin.monthly.plan.approve', $configId)); ?>" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <button type="submit" class="btn btn-success" onclick="return confirm('Are you sure you want to approve this configuration?')">
                        <?php echo app('translator')->get('Approve Configuration'); ?>
                    </button>
                </form>
                <?php endif; ?>

            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <div class="row">
        <div class="col-lg-8">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title"><?php echo app('translator')->get('Mining Report'); ?></h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Customer ID'); ?></th>
                                    <th><?php echo app('translator')->get('Customer Name'); ?></th>
                                    <th><?php echo app('translator')->get('Machine ID'); ?></th>
                                    <th><?php echo app('translator')->get('Quantity'); ?></th>
                                    <th><?php echo app('translator')->get('Start Date'); ?></th>
                                    <th><?php echo app('translator')->get('End Date'); ?></th>
                                    <th><?php echo app('translator')->get('Days Vested'); ?></th>
                                    <th><?php echo app('translator')->get('Hash Rate'); ?></th>
                                    <th><?php echo app('translator')->get('Mining Reward'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $processedInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($investment['user_id']); ?></td>
                                    <td><?php echo e($investment['user_name']); ?></td>
                                    <td><?php echo e($investment['planId']); ?></td>
                                    <td><?php echo e($investment['quantity']); ?></td>
                                    <td><?php echo e($investment['effective_start_date']); ?></td>
                                    <td><?php echo e($investment['effective_end_date']); ?></td>
                                    <td><?php echo e($investment['days_invested']); ?></td>
                                    <td><?php echo e($investment['hashrate']); ?></td>
                                    <td><?php echo e($investment['calculated_reward']); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
<!--                             <tfoot>
                                <tr class="table-primary">
                                    <th style="background: #3F51B5 !important;color: #ffffff;"  colspan="3"><?php echo app('translator')->get('Total'); ?></th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;" ><?php echo e($summary['total_quantity']); ?></th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;"  colspan="4"></th>
                                    <th style="background: #3F51B5 !important;color: #ffffff;" ><?php echo e($summary['total_reward']); ?></th>
                                </tr>
                            </tfoot> -->
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title"><?php echo app('translator')->get('Summary'); ?></h4>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6><?php echo app('translator')->get('Period'); ?></h6>
                        <p><?php echo e($summary['start_date']); ?> to <?php echo e($summary['end_date']); ?></p>
                    </div>      
                    <div class="mb-3">
                        <h6><?php echo app('translator')->get('Total Date Period'); ?></h6>
                        <p><?php echo e($summary['total_date_period']); ?></p>
                    </div>
                    <div class="mb-3">
                        <h6><?php echo app('translator')->get('Total Reward'); ?></h6>
                        <p><?php echo e($summary['total_reward_setting']); ?></p>
                    </div>
                    <div class="mb-3">
                        <h6><?php echo app('translator')->get('Total Operation Cost'); ?></h6>
                        <p><?php echo e($summary['total_operation_cost']); ?></p>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <h6><?php echo app('translator')->get('Reward Per Day'); ?></h6>
                        <p><?php echo e($summary['reward_per_day']); ?></p>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <h6><?php echo app('translator')->get('Total Investments'); ?></h6>
                        <p><?php echo e($summary['total_investments']); ?></p>
                    </div>
                    <div class="mb-3">
                        <h6><?php echo app('translator')->get('Total Investments Machines'); ?></h6>
                        <p><?php echo e($summary['total_quantity']); ?></p>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <h5><?php echo app('translator')->get('Total Projected Rewards'); ?></h5>
                        <h4><?php echo e($summary['total_reward']); ?></h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/monthly_report/index.blade.php ENDPATH**/ ?>