@extends($theme.'layouts.user')

@section('title',trans('Asset Subscription'))

@section('content')

<style type="text/css">
    .machine-status {
        background-color: #0b2433;
        border-left: 15px solid #37b6ff;
        border-radius: 12px;
        padding: 1.3rem 0.8rem 1.2rem 0.8rem;
    }

    .machine-status .title {
        font-size: 18px;
        margin-right: 1.2rem;
    }

    .machine-status p:not(.title):not(:last-child) {
        border-right: 1px solid white;
    }

    .machine-plus {
        background: rgb(3, 37, 146);
        background: linear-gradient(90deg, rgba(3, 37, 146, 1) 0%, rgba(14, 115, 228, 1) 50%);
        padding: 1.3rem 0.8rem 1.2rem 0.8rem;
        border-radius: 12px;
        cursor: pointer;
    }

    .machine-type {
        background-color: #0b2433;
        border-radius: 5px;
        padding: 0.25rem 0.5rem;
        margin-bottom: 1.2rem;
        width: max-content;
        cursor: pointer;
    }

    .machine-type p {
        color: #37b6ff !important;
        font-size: 14px;
    }

    .icon-wrapper {
        background: rgba(255, 255, 255, 0.3);
        border-radius: 100%;
        min-width: 52px;
        width: 52px;
        height: 52px;
        position: relative;
    }

    .header-item img {
        position: absolute;
        top: -3px;
        left: -3px;
        width: 58px;
        min-width: 58px;
    }

    .header-item .units {
        background: rgb(3, 35, 144);
        background: linear-gradient(90deg, rgba(3, 35, 144, 1) 0%, rgba(55, 182, 255, 1) 80%);
        border-radius: 100%;
        width: max-content;
    }

    .header-item .units div {
        padding: 0.5rem 1.2rem;
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .header-item .units div p {
        font-size: 24px;
        font-weight: 700;
    }

    .header-item .units div span {
        font-size: 14px;
    }

    .earnings-item .earning {
        background-color: #0d2c3e;
        border: 1px solid #195273;
        border-radius: 5px;
        padding: 1rem;
    }

    .earnings-item .earning .subtitle {
        font-size: 14px;
    }

    .earnings-item .earning .currency {
        font-size: 20px;
        font-weight: 800;
    }

    .grid-container-earning {
        display: grid;
        gap: 1rem;
        grid-template-columns: 1fr;
    }

    .modal .modal-content {

        background: #071720 !important;

    }

    .header-item h4 {
        font-weight: 700;
        line-height: 1.5rem;
    }

    @media (min-width: 768px) {
        .grid-container-earning {
            grid-template-columns: repeat(2, 1fr);
        }

        .header-item h4 {
            font-size: 27px !important;
            line-height: 2rem;
        }
    }

    .outer-color {
        border: 1px solid rgb(44, 97, 118);
        border-radius: 24px;
    }

    .disclaimer {
        border-bottom: 5px solid #1362aa;
        border-radius: 10px;
        text-align: center;
        background: linear-gradient(0deg, #195273 0%, #0F324680 100%);
    }

    hr {
        border-top: #195273 solid;
        margin: 1rem 0 1.2rem 0;
    }

    .card-color {

        background: #0F3246;

        border-radius: 20px;

        border: 1px solid rgb(44, 97, 118);

        height: 100%;

    }

    li {

        font-size: 15px;

    }


    .list-icon {

        width: 30px;

        height: 30px;

        margin-right: 15px;

    }

    .investNow,
    .primary-button {
        width: 100%;
        border-radius: 8px;
        text-align: center;
        justify-content: center;
        background: linear-gradient(90deg, #03228F 0%, #0E73E4 100%);
    }

    .primary-button:disabled,
    .primary-button.disabled {
        opacity: 0.6;
        cursor: not-allowed;
        pointer-events: none;
        background: linear-gradient(90deg, #6c757d 0%, #adb5bd 100%);
    }

    .primary-button:not(:disabled):hover {
        filter: brightness(1.1);
    }

    .pricing-single .btn-1 {

        border-radius: 500px !important;

    }

    .common-item,
    .pricing-content {
        background-color: #0a202d;
        border: 1px solid #195273;
        border-radius: 12px;
        padding: 1.2rem;
    }

    .pricing-content {
        background-color: #0d2c3e;
        padding: 1.2rem 1.5rem;
    }

    .pricing-content ul li {
        font-size: 18px;
    }

    .common-item h6 {
        border-left: 4px solid #0e73e4;
    }

    .common-item .badge {
        background-color: rgba(55, 182, 255, 0.4);
        border-radius: 15px;
        color: #37b6ff !important;
        padding: 0.45rem 0.75rem 0.45rem 0.7rem !important;
        width: max-content;
    }

    .common-item .badge .fa-circle {
        color: #37b6ff !important;
        background-color: rgba(55, 182, 255, 0.4);
        border-radius: 100%;
        padding: 0.2rem;
    }

    .common-item .units {
        background: rgb(3, 35, 144);
        background: linear-gradient(90deg, rgba(3, 35, 144, 1) 0%, rgba(55, 182, 255, 1) 80%);
        border-radius: 100%;
        width: max-content;
    }

    .common-item .units div {
        padding: 0.5rem 1.2rem;
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .common-item .units div p {
        font-size: 24px;
        font-weight: 700;
    }

    .common-item .units div span {
        font-size: 14px;
    }

    .grid-container {
        display: grid;
        gap: 1rem;
        grid-template-columns: 1fr;
        width: 100%;
        max-width: 100%;
        box-sizing: border-box;
    }

    .grid-container>div {
        min-width: 0;
        max-width: 100%;
        box-sizing: border-box;
    }

    img,
    .grid-container * {
        max-width: 100%;
        box-sizing: border-box;
    }

    .item-1 {
        grid-column: 1;
    }

    .item-2 {
        grid-column: 1;
    }

    .item-3 {
        grid-column: 1;
        grid-row: 1;
    }

    .item-4 {
        grid-column: 1;
        grid-row: 3;
    }

    #pricingItem {
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.4s ease;
    }

    #pricingItem.expanded {
        max-height: 1000px; /* should be more than expected content height */
    }

    #toggleIcon {
        transform: rotate(180deg);
        transition: transform 0.3s ease;
    }

    #toggleIcon.rotate {
        transform: rotate(360deg);
        transition: transform 0.3s ease;
    }

    @media (max-width: 576px) {
        .machine-status p:not(.title) {
            font-size: 12px;
            margin-right: 0.5rem !important;
        }

        .icon-wrapper {
            min-width: 42px;
            width: 42px;
            height: 42px;
        }


        .header-item img {
            min-width: 46px;
            width: 46px;
            height: 46px;
            top: -2px;
            left: -2px;
        }

        .header-item .units div {
            padding: 0.6rem 0.85rem;
        }

        .header-item .units div p {
            font-size: 14px;
        }

        .header-item .units div span {
            font-size: 12px;
        }

        .pricing-content {
            padding: 1.2rem;
        }

        .list-icon {
            height: 20px;
            margin-right: 10px;
        }

        .pricing-content ul li {
            font-size: 14px;
        }

        .disclaimer p {
            font-size: 10px;
        }

        .machine-type img {
            width: 12px;
        }

        .machine-type p {
            font-size: 12px;
        }

        .earnings-item .earning .subtitle {
            font-size: 12px;
        }

        .earnings-item .earning .currency {
            font-size: 18px;
        }
    }

    @media (min-width: 768px) {
        .grid-container {
            display: grid;
            gap: 1rem;
            grid-template-columns: repeat(3, 1fr);
            grid-auto-rows: auto;
        }

        .item-1 {
            grid-column: span 2;
        }

        .item-2 {
            grid-column: span 2;
        }

        .item-3 {
            grid-column: 3;
            margin-bottom: 1rem;
        }

        .item-4 {
            grid-column: 3;
        }

        .item-wrapper {
            grid-column: 3;
            display: flex;
            flex-direction: column;
        }
    }
</style>

<div class="pagetitle">

    <h3 class="mt-2 mb-5 ms-1 font-bold">@lang('Asset Subscription')</h3>

</div>


<div class="grid-container">

    <!-- <div class="item item-1">

        <div class="machine-status d-flex flex-column align-items-start flex-md-row align-items-md-center">
            <p class="font-bold mb-0 title">Machine Activated</p>
            <div class="d-flex">
                <p class="mb-0 me-2 pe-2 pe-md-3">-1 Medium Noted</p>
                <p class="mb-0 me-2 pe-2 pe-md-3">711.24TH/s</p>
                <p class="mb-0">2.32 PH/s</p>
            </div>
        </div>

    </div> -->
    <div class="item item-2">
        @foreach($transactions as $transaction)
        <div class="p-2 outer-color">
            <div class="card-color">
                <div class="py-4 px-3 p-md-4">
                    <div class="header-item d-flex justify-content-between align-items-center mb-4">
                        <div class="d-flex align-items-center">
                            <div class="icon-wrapper">
                                <img src="{{ asset('assets/themes/light/images/icons/Lightning.svg') }}" alt="" />
                            </div>
                            <h4 class="font-bold ms-3">{{$transaction->plan->plan_name}}</h4>
                        </div>

                        <div class="units">
                            <div>
                                <p class="m-0 lh-sm">{{$transaction->quantity}}</p>
                                <span>Unit
                                    @if($transaction->quantity > 1)
                                        s
                                    @endif
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="grid-container-earning earnings-item">
                        <div class="earning element-1">
                            <p class="m-0 mb-2 ms-1 subtitle">Cost Paid</p>
                            <p class="m-0 ms-1 font-bold currency">USD {{$transaction->invest_amount}}</p>
                        </div>
                        <div class="earning element-2">
                            <p class="m-0 mb-2 ms-1 subtitle">Total Earnings</p>
                            <p class="m-0 ms-1 font-bold currency"><img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                {{$transaction->total_calculated_reward}}
                            </p>
                        </div>
                    </div>

                    <hr>

                    <!-- <div class="d-flex align-items-center machine-type mx-auto">
                        <img width="14" height="auto" src="https://petarig.fireworksmedia.com/project/assets/themes/light/images/icons/DoubleChevron.svg" alt="Plus icon">
                        <p class="m-0 ms-2 font-bold">Show less</p>
                    </div> -->

                    <div id="toggleButton" class="d-flex align-items-center machine-type mx-auto" style="cursor: pointer;">
                        <img id="toggleIcon" width="14" src="https://petarig.fireworksmedia.com/project/assets/themes/light/images/icons/DoubleChevron.svg" alt="Chevron icon" />
                        <p id="toggleText" class="m-0 ms-2 font-bold">Show more</p>
                    </div>

                    <div id="pricingItem" class="pricing-item p-0">
                        <div class="pricing-content">
                            <ul class="pricing-list mb-4">
                                <li class="mt-2 mb-3 font-bold"> <img class="list-icon" src="{{ asset(template(true).'images/custom/Gauge.svg') }}" alt="Gauge Icon" />{{$transaction->plan->text1}}</li>
                                <li class="my-3 font-bold"><img class="list-icon" src="{{ asset(template(true).'images/custom/FileText.svg') }}" alt="filetext Icon" />{{$transaction->plan->text2}}</li>
                                <li class="my-3 font-bold"><img class="list-icon" src="{{ asset(template(true).'images/custom/MoneyWavy.svg') }}" alt="moneywavy Icon" />{{$transaction->plan->text3}}</li>
                                <!-- <li class="my-3 font-bold"><img class="list-icon" src="{{ asset(template(true).'images/custom/HandWithdraw.svg') }}" alt="HandWithdraw Icon" />{{$transaction->plan->text4}}</li> -->
                                <li class="my-3 font-bold"><img class="list-icon" src="{{ asset(template(true).'images/custom/ChartBar.svg') }}" alt="ChartBar Icon" />{{$transaction->plan->text5}}</li>
                                <li class="my-3 font-bold"><img class="list-icon" src="{{ asset(template(true).'images/custom/CurrencyCircleDollar.svg') }}" alt="CurrencyCircleDollar Icon" />{{$transaction->plan->text6}}</li>
                            </ul>
                            <div class="disclaimer mb-3">
                                @php
                                    $shortDesc = str_replace('&nbsp;', ' ', $transaction->plan->short_description);

                                    // Split by first period + space to separate two sentences.
                                    $sentences = preg_split('/(\. )/', $shortDesc, 2, PREG_SPLIT_DELIM_CAPTURE);

                                    $formattedDesc = '';
                                    if (count($sentences) >= 2) {
                                        $formattedDesc = $sentences[0] . $sentences[1] . '<br>' . ($sentences[2] ?? '');
                                    } else {
                                        $formattedDesc = $shortDesc;
                                    } 
                                @endphp

                                <div class="px-2 py-3">
                                    <p class="m-0 mb-1 w-100" style="font-style: italic;text-align: left;">Notes:</p>
                                    <p class="m-0 w-100" style="font-style: italic;text-align: left;">{{ $sentences[0] . $sentences[1] }}</p>
                                    <p class="m-0 w-100" style="font-style: italic;text-align: left;">{{ $sentences[2] }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center machine-type mx-auto mb-0" style="padding: 0.6rem 0.9rem;"  data-bs-toggle="modal" data-bs-target="#InvestModal">
                                <img src="https://petarig.fireworksmedia.com/project/assets/themes/light/images/icons/Files.svg" alt="Plus icon">
                                <p class="m-0 ms-2 pe-auto">View Contract</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>

    <div class="item-wrapper">
        <div class="item item-3">

            <div class="machine-plus" onclick="window.location.href='{{ route('user.subscription.add') }}'">

                <p class="font-bold mb-0 text-center">Add Subscription</p>

            </div>

        </div>

        <div class="item item-4">

            <div class="common-item mt-lg-3">

                <h6 class="mb-2 ps-2 text-white font-bold">Purchase History</h6>

                <div>
                    @foreach($transactions as $transaction):
                    <div class="d-flex align-items-center mb-2">
                        <img class="me-2" src="{{ asset('assets/themes/light/images/icons/ThunderIcon.svg') }}" />
                        <div>
                            <p class="font-bold mb-0">{{$transaction->plan->plan_name}} x {{$transaction->quantity}}</p>
                            <span class="me-2" style="font-size: 14px;"><strong>Purchased at:</strong> {{ \Carbon\Carbon::parse($transaction->created_at)->format('d-m-Y') }}</span><br>
                            <span class="me-2" style="font-size: 14px;"><strong>Start:</strong> {{ \Carbon\Carbon::parse($transaction->created_at)->addDay()->format('d-m-Y') }}</span><br>
                            <span style="font-size: 14px;"><strong>Expiry:</strong> {{ \Carbon\Carbon::parse($transaction->plan_expiry_date)->format('d-m-Y') }}</span>
                        </div>
                    </div>
                    @endforeach
                </div>

            </div>

        </div>
    </div>
</div>


<div id="InvestModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-fullscreen" role="document"> 

        <div class="modal-content">

            <div class="modal-header text-white border-0">

                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>

            </div>

            <div class="d-flex justify-content-center align-items-center">

                <form action="{{route('user.investPlan')}}" method="post" class="col-md-8 col-12">

                    @csrf

                    <div class="modal-body">

                        <h3 class="modal-title text-center mb-2" id="contractModalLabel">{{ $content->subject }}</h3> 

                        <p class="text-center mb-3">Please read and accept the contract before paying the machine</p>
                        <div id="terms" class="p-3 bg-light rounded" style="color:white;overflow:scroll;max-height:55vh;">
                            {!! $content->content !!}
                        </div>

                    </div>

                    <div class="modal-footer border-0">

                        <button type="button" class="btn-2 primary-button planPurchaseSubmitButton" style="width: 100vw !important;" data-bs-dismiss="modal">Close<span></span></button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<script>
    document.getElementById('toggleButton').addEventListener('click', function () {
        console.log('clicked');
        const pricingItem = document.getElementById('pricingItem');
        const toggleIcon = document.getElementById('toggleIcon');
        const toggleText = document.getElementById('toggleText');

        const isExpanded = pricingItem.classList.contains('expanded');

        pricingItem.classList.toggle('expanded');
        toggleIcon.classList.toggle('rotate');
        toggleText.textContent = isExpanded ? 'Show more' : 'Show less';
    });
</script>

@endsection