@extends($theme.'layouts.user')

<link href="{{asset(template(true).'css/module-css/payment.css')}}?v={{ time() }}" rel="stylesheet">

@section('title',trans('Payment'))

@push('style')

<style>
    #header, #sidebar, .header-mining {
        display: none !important;
    }

    #main {
        margin-top: 0px;
    }

    #main, #footer,
    #main.collapsed-main, #footer.collapsed-footer {
        margin-left: 0px !important;
    }

    .payment {

        background: var(--bg-13) !important;

    }

    .payment-list {

        height: unset !important;

    }

    .payment-list .form-check-label {

        background-color: #0f3246 !important;
        border-radius: 12px;

    }

    .primary-button {

        width: 100%;
        border-radius: 8px;
        text-align: center;
        justify-content: center;
        background: linear-gradient(90deg, #03228F 0%, #0E73E4 100%);
        border: none;
        padding: 9px 20px;
        font-size: 14px;
        text-transform: capitalize;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        color: #ffffff;
        position: relative;
        overflow: hidden;
        z-index: 1;
        transition: .5s;

    }

    .payment-list .item {

        width: 100% !important;
        margin: 0 10px;

    }

    .payment-list .form-check-input {

        visibility: hidden;

    }

    .plan-details {

        background: #0f3246;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        border-radius: 12px;
        border: 1px solid #195273;

    }

    .modal .modal-content {
        
        background: #0f3246;

    }

    .paymentModal {
        display: block !important;
    }
</style>

@endpush

@section('content')

<section class="payment">

    <div class="container">

        <form action="{{route('user.plan.purchase.request')}}" method="post">

            @csrf

            <h3 class="payment-title text-center">Select payment</h3>

            <p class="text-center mb-5">We accept these form of payments</p>

            <div class="d-flex justify-content-center">

                <div class="plan-details col-12 col-lg-5 mb-5 p-4">

                    <img class="mb-2" style="width: 50px;height: 50px;" src="{{ asset(template(true).'images/custom/thunder-icon.svg') }}" alt="thunder Icon" />

                    <h4 class="mb-2 text-center">{{ $plan_detail->plan_name }}</h4>

                    <h5 class="mb-2"><strong>{{ number_format($plan_detail->plan_price, 2) }}</strong> x {{ $quantity }} unit(s)</h5>

                    <span>For {{ $plan_detail->plan_period }} {{ $plan_detail->plan_period_type }}(s)</span>

                </div>

            </div>

            <div class="row d-flex justify-content-center">

                <div class="col-12 col-lg-10">

                    <div class="payment-box">

                        <ul class="payment-list d-flex flex-column flex-md-row justify-content-md-between align-items-center">

                            @foreach($gateways as $method)

                            <li class="item {{ $method->name == 'CoinPayments' ? '' : '' }}">

                                <label class="form-check-label w-100" for="{{ $method->name }}">

                                    <input class="form-check-input selectPayment"

                                        value="{{ $method->id }}" type="radio"

                                        name="gateway_id"

                                        id="{{ $method->name }}"

                                        {{ $method->name == 'CoinPayments' ? 'checked' : '' }}>

                                    <div class="d-flex flex-column" style="width: 100%;">

                                        <span class="payment-list-content d-flex justify-content-center">

                                            <!-- <span class="payment-list-image">

                                                <img src="{{ getFile($method->driver,$method->image ) }}" alt="image">

                                            </span> -->

                                            <span class="payment-list-info">

                                                <span class="payment-list-title">{{ $method->name == 'CoinPayments' ? 'Pay with USDT' : 'Pay with Credit Card or E-Payment' }}</span>

                                                <!-- <p class="my-2">{{$method->name}}</p> -->

                                                <!-- <span class="payment-list-text">{{$method->description}}</span> -->

                                            </span>

                                        </span>

                                        <span class="payment-list-content">

                                            <button type="button" class="pay-now primary-button">Pay Now</button>

                                        </span>

                                    </div>

                                </label>

                            </li>

                            @endforeach

                        </ul>

                    </div>

                </div>



                <div class="col-md-12 col-lg-5 d-none">

                    <div class="payment-side-bar">

                        <div class="payment-side-box border border-white" id="GatewayForm">

                            <label class="text-white">@lang('Select Currency')</label>

                            <select class="selectpicker nice-select" name="supported_currency" id="supported_currency">



                            </select>



                            <span class="d-block text-danger errorMessage"></span>

                        </div>

                        <div class="payment-side-box border border-white payment-summary">

                            <h5>@lang('Payment Summary')</h5>

                            <div class="payment-summary-list">

                                <ul class="showCharge">



                                </ul>

                            </div>

                        </div>

                        <button type="submit" class="primary-button">@lang('Make Payment') <span></span></button>

                    </div>

                </div>

            </div>



            <div class="paymentModal">

                <!-- Modal section start -->

                <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false"

                    tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">

                    <div class="modal-dialog modal-dialog-centered">

                        <div class="modal-content">

                            <div class="modal-header border-0">

                                <h4 class="modal-title" id="staticBackdropLabel">@lang('Payment')</h4>

                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                            </div>

                            <div class="modal-body" id="paymentModalBody">





                            </div>

                        </div>

                    </div>

                </div>

                <!-- Modal section end -->

            </div>



        </form>

    </div>

    <!-- <ul>
        <li>

            {{ __('Amount In') }} ${response.currency}

            <span> ${response.amount} ${response.currency}</span>

            </li>



            <li >

            {{ __('Charge') }}

            <span>  ${response.charge} ${response.currency}</span>

            </li>





            <li >

            {{ __('Payable Amount') }}

            <span> ${response.payable_amount} ${response.currency}</span>

            </li>



            <li >

            <span>{{ __('Payable Amount') }} <sub>(In Base Currency)</sub></span>

            <span> ${response.amount_in_base_currency} ${currency}</span>

            </li>
    </ul> -->

</section>

<!-- payment -->



@endsection



@push('style')

<style>
    .main-footer-padding {

        padding-top: 60px;

    }
</style>

@endpush

@push('script')

<script>
    var gateway_id = null;

    $(document).on('click', '.selectPayment', function() {


        $('#paymentModalBody').html('');



        let updatedWidth = window.innerWidth;

        window.addEventListener('resize', () => {

            updatedWidth = window.innerWidth;

        });



        let html = `<div class="payment-side-box border border-white" id="GatewayForm">

                        <label class="text-white">@lang('Select Currency')</label>

                        <select class="selectpicker nice-select" name="supported_currency" id="supported_currency">



                        </select>



                        <span class="d-block text-danger errorMessage"></span>

                    </div>

                    <div class="payment-side-box border border-white payment-summary">

                        <h5>@lang('Payment Summary')</h5>

                        <div class="payment-summary-list">

                            <ul class="showCharge">



                            </ul>

                        </div>

                    </div>

                    <button type="submit" class="primary-button">@lang('Make Payment') <span></span></button>`;



        if (updatedWidth <= 991) {

            $('.payment-side-bar').html('');

            $('#paymentModalBody').html(html);

            let paymentModal = new bootstrap.Modal(document.getElementById('staticBackdrop'));

            paymentModal.show()

        } else {

            $('.payment-side-bar').html(html)

        }

        let id = $(this).val();

        gateway_id = id;

        supportCurrency(id)

    })



    $(document).on('click', '.pay-now', function () {

        // Find the closest label (which wraps the input)
        const $label = $(this).closest('label');

        // Find the radio input inside that label and select it
        $label.find('input[type="radio"]').prop('checked', true).trigger('change');

        $('#paymentModalBody').html('');



        let updatedWidth = window.innerWidth;

        window.addEventListener('resize', () => {

            updatedWidth = window.innerWidth;

        });



        let html = `<div class="payment-side-box border border-white" id="GatewayForm">

                        <label class="text-white">@lang('Select Currency')</label>

                        <select class="selectpicker nice-select" name="supported_currency" id="supported_currency">



                        </select>



                        <span class="d-block text-danger errorMessage"></span>

                    </div>

                    <div class="payment-side-box border border-white payment-summary">

                        <h5>@lang('Payment Summary')</h5>

                        <div class="payment-summary-list">

                            <ul class="showCharge">



                            </ul>

                        </div>

                    </div>

                    <button type="submit" class="primary-button">@lang('Make Payment') <span></span></button>`;



        // if (updatedWidth <= 991) {

        //     $('.payment-side-bar').html('');

        //     $('#paymentModalBody').html(html);

        //     let paymentModal = new bootstrap.Modal(document.getElementById('staticBackdrop'));

        //     paymentModal.show()

        // } else {

        //     $('.payment-side-bar').html(html)

        // }

        $('.payment-side-bar').html('');

        $('#paymentModalBody').html(html);

        let paymentModal = new bootstrap.Modal(document.getElementById('staticBackdrop'));

        paymentModal.show();

        let id = $label.find('input[type="radio"]').val();

        gateway_id = id;

        supportCurrency(id);

    });



    function supportCurrency(selectedGateway) {

        if (!selectedGateway) {

            console.error('Selected Gateway is undefined or null.');

            return;

        }

        $.ajax({

            url: "{{ route('supported.currency') }}",

            data: {
                gateway: selectedGateway
            },

            type: "GET",

            success: function(response) {

                $('#supported_currency').empty();

                if (response.data === "") {

                    $('#supported_currency').attr('name', 'supported_currency');

                    let markup = `<option value="USD">USD</option>`;

                    $('#supported_currency').append(markup);

                }

                if (response.currencyType == 1) {

                    $('#supported_currency').attr('name', 'supported_currency');

                    // let markup = '<option value="">Selected Currency</option>';

                    // $('#supported_currency').append(markup);

                    $(response.data).each(function(index, value) {

                        let markup = `<option value="${value}">${value}</option>`;

                        $('#supported_currency').append(markup);

                    });

                    if (response.data.length > 0) {

                        $('#supported_currency').val(response.data[0]).trigger('change');

                    }

                }

                if (response.currencyType == 0) {

                    $('#supported_currency').attr('name', 'supported_crypto_currency');

                    let markup2 = '<option value="">Select Crypto Currency</option>';

                    $('#supported_currency').append(markup2);

                    $(response.data).each(function(index, value) {

                        let markupOption = `<option value="${value}">${value}</option>`;

                        $('#supported_currency').append(markupOption);

                    });

                }

                $('.nice-select').niceSelect('update');



            },

            error: function(error) {

                console.error('AJAX Error:', error);

            }

        })

    }



    $(document).on('change', '#supported_currency', function() {

        if ($(this).attr('name') == 'supported_currency') {

            checkAmount($(this).val(), null);

        } else {

            checkAmount(null, $(this).val());

        }

    })



    function checkAmount(currency, cryptoCurrency) {

        let amount = '{{$amount}}';

        $.ajax({

            method: 'GET',

            url: "{{ route('payment.checkAmount') }}",

            dataType: "json",

            data: {

                'amount': amount,

                'selected_currency': currency,

                'select_gateway': gateway_id,

                'selectedCryptoCurrency': cryptoCurrency,

            },

            success: function(response) {

                console.log(response);

                $('.errorMessage').text('')

                if (response.status) {

                    let base_currency = "{{basicControl()->base_currency}}"

                    showCharge(response, base_currency);

                } else {

                    $('.errorMessage').text(response.message)

                    // console.log(response);

                }

            }

        })

    }



function showCharge(response, currency) {
    let txnDetails = `
        <li>
            {{ __('Payable Amount') }}
            <span> ${Number(response.amount).toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                })} ${response.currency}
            </span>
        </li>
        <li>
            {{ __('Merchant Fee') }}
            <span> ${Number(response.charge).toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                })} ${response.currency}
            </span>
        </li>
        <li>
            {{ __('Total Payable Amount') }}
            <span> ${Number(response.payable_amount).toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                })} ${response.currency}
            </span>
        </li>
    `;

    $('.showCharge').html(txnDetails);
}

</script>

@endpush





@push('style')

<style>
    .modal-backdrop {

        opacity: 0 !important;

        z-index: 0 !important;

    }

    .paymentModal {

        display: block !important;

    }

    .paymentModal .payment-side-box {

        display: flex !important;

        flex-direction: column !important;

    }

    .paymentModal .payment-side-box label {

        margin-bottom: 4px !important;

    }

    @media only screen and (max-width: 991px) {

        .payment-side-bar {

            display: none;

        }

    }



    @media screen and (max-width: 420px) {

        .payment-list-text {

            opacity: .7;

            font-size: 15px;

            font-weight: 500;

            line-height: normal;

            margin-top: 7px;

            margin-bottom: 25px;

            display: -webkit-box;

            -webkit-line-clamp: 2;

            -webkit-box-orient: vertical;

            overflow: hidden;

        }

    }
</style>

@endpush