<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8"/>

    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>

    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

    <link href="{{ getFile(basicControl()->favicon_driver, basicControl()->favicon) }}" rel="icon">





    <title>{{trans('Dashboard')}} | @lang(basicControl()->site_title) </title>



    <meta name="csrf-token" content="{{csrf_token()}}">



    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/all.min.css') }}"/>

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/flatpickr-min.css') }}"/>

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/bootstrap.min.css') }}"/>

    <link rel="stylesheet" href="{{ asset('assets/admin/css/fontawesome.min.css') }}">

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/select2.min.css') }}"/>

    <link href="{{asset(template(true).'css/swiper.min.css')}}" rel="stylesheet">

    <!-- custom css -->

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/user-style.css') }}?v={{ time() }}"/>

    <!-- owl carousel -->

    <link rel="stylesheet" href="{{asset($themeTrue.'css/owl.carousel.min.css')}}"/>

    <link rel="stylesheet" href="{{asset($themeTrue.'css/owl.theme.default.min.css')}}"/>

    <link rel="stylesheet" href="{{asset($themeTrue.'css/apexcharts.css')}}"/>

    <link href="{{asset($themeTrue.'css/fancy-box-carusol.css')}}" rel="stylesheet">

    <link
    rel="stylesheet"
    href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"
    />

    @stack('css-lib')

    @stack('style')

</head>

<body onload="preloaderFunction()" >





    <div id="preloader">

        <div class="load">

            <hr/>

            <hr/>

            <hr/>

            <hr/>

        </div>

    </div>



<!-- Header section start -->

<header id="header" class="header fixed-top d-flex align-items-center">

    <div class="d-flex align-items-center justify-content-between">

        <div class="logo-container">

            <a href="{{route('page')}}" class="logo d-flex align-items-center">

                <!-- <img src="{{logo(true)}}" alt="..."> -->
                <img width="50" src="{{ asset('assets/themes/light/images/icons/petarigs-logo.svg') }}" />

            </a>

        </div>

        <div class="d-none d-md-flex">

            @php
            use Illuminate\Support\Facades\Auth;
            use App\Models\InvestHistory;

            $planInvestment = InvestHistory::with('plan')->where('user_id', Auth::id())->first();
            @endphp

            @if($planInvestment)
            <div class="header-mining d-flex justify-content-between align-items-center ms-3">
                <div class="d-flex align-items-center me-2">
                    <i class="fa-solid fa-circle fa-xs me-1"></i>
                    <p class="m-0 font-bold ms-1">Mining in operation...</p>
                </div>
                <img width="25" src="{{ asset('assets/themes/light/images/icons/Spinner.png') }}" class="spinner-img" />
            </div>
            @endif

            
        </div>

        <!-- <button onclick="toggleSideMenu()" class="toggle-sidebar toggle-sidebar-btn d-none d-lg-block">

            <i class="fa-light fa-list"></i>

        </button> -->

    </div>

    <!-- End Logo -->





    <!-- Start Icons Navigation -->

    <nav class="header-nav ms-auto">

        <ul class="nav-icons">

            <li class="nav-item dropdown">

                <a class="nav-link nav-profile d-flex align-items-center pe-0 dropdown-toggle" href="#" data-bs-toggle="dropdown">
                    <div class="d-none d-lg-flex align-items-center ps-2">
                        <div class="image-area me-2">
                            <img src="{{ getFile($authUser->image_driver, $authUser->image) }}" id="profile" alt="" class="img-profile-view" />
                        </div>
                        <div class="me-3">
                            <p class="m-0 font-bold lh-sm">
                                {{ $authUser->firstname }}  {{ $authUser->lastname }}
                            </p>
                        </div> 
                    </div>
                </a>



                <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile" style="background: #071720 !important;">

                    <li class="dropdown-item px-0 pt-0 pb-3">
                        <div class="banner small mb-2"></div>

                        <div class="profile-details-section small">
                            <div class="d-flex flex-column justify-content-center align-items-center">
                                <div class="image-area mb-2">
                                    <img src="{{ getFile($authUser->image_driver, $authUser->image) }}" id="profile" alt="" class="img-profile-view" style="width: 45px; height: 45px; border-radius: 50%;">
                                </div>

                                <h6 class="text-white mb-0 lh-sm">{{ $authUser->firstname }}  {{ $authUser->lastname }}</h6>
                            </div>
                        </div>
                    </li>

                <!-- <li>

                    <a class="dropdown-item d-flex align-items-center px-0" href="{{ route('user.wallet') }}">

                        <img width="17" height="auto" class="me-2" src="{{ asset('assets/themes/light/images/icons/WalletIcon.svg') }}" />

                        <span>@lang('My Wallet')</span>

                        <span class="ms-auto">$120</span>

                    </a>

                </li> -->

                <li>

                    <a class="dropdown-item d-flex align-items-center px-0 border-0 pb-0" href="{{ route('user.profile') }}">

                        <img width="17" height="auto" class="me-2" src="{{ asset('assets/themes/light/images/icons/ProfileIcon.svg') }}" />

                        <span>@lang('My Account')</span>

                    </a>

                </li>

                <li>

                    <a class="dropdown-item sign-out d-flex justify-content-center align-items-center" href="{{ route('logout') }}"

                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();">

                    <span class="font-bold me-2">@lang('Sign Out')</span>

                    <!-- <i class="fa-regular fa-right-from-bracket"></i> -->
                    <img class="me-2" src="{{ asset('assets/themes/light/images/icons/LogoutIcon.svg') }}" />

                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">

                        @csrf

                    </form>

                </a>

            </li>

        </ul>

    </li>



</ul>

</nav>



<!-- End Icons Navigation -->



</header>



<!-- Bottom Mobile Tab nav section start -->

<ul class="nav bottom-nav fixed-bottom d-lg-none">

    <li class="nav-item">

        <a class="nav-link {{menuActive(['user.plans'])}} " href="{{route('user.plans')}}">

            <i class="fa-brands fa-codepen"></i>

        </a>

    </li>

    <li class="nav-item" onclick="toggleSideMenu()">

        <i class="fa-light fa-list" style="color: #000000;"></i>

    </li>

    <li class="nav-item">

        <a class="nav-link {{menuActive(['user.dashboard'])}}" href="{{route('user.dashboard')}}"><i

            class="fa-regular fa-house"></i></a>

        </li>

        <li class="nav-item">

            <a class="nav-link {{menuActive(['user.profile'])}}" href="{{route('user.profile')}}"><i

                class="fa-light fa-user"></i></a>

            </li>

        </ul>

<!-- Bottom Mobile Tab nav section end -->



@include($theme.'partials/sidebar')



<main id="main" class="main collapsed-main">

    @yield('content')

</main>





<!-- Footer section start -->

<footer id="footer" class="footer collapsed-footer">

    <div class="copyright">

        &copy; @lang('Copyright') <strong><span>{{basicControl()->site_title}}</span></strong>. @lang('All Rights Reserved')    </div>

    </footer>

<!-- Footer section end -->



<!-- bootstrap -->

<script src="{{asset($themeTrue.'js/bootstrap.bundle.min.js')}}"></script>

<script src="{{asset($themeTrue.'js/flatpickr-min.js')}}"></script>

<!-- jquery cdn -->

<script src="{{ asset('assets/global/js/jquery.min.js') }}"></script>



<script src="{{asset($themeTrue.'js/apexcharts.min.js')}}"></script>

<script src="{{ asset('assets/global/js/Chart.min.js') }}"></script>

<script src="{{ asset($themeTrue . 'js/select2.min.js') }}"></script>

<script src="{{asset($themeTrue.'js/owl.carousel.min.js')}}"></script>

<script src="{{asset($themeTrue.'js/waypoints.min.js')}}"></script>

<script src="{{ asset('assets/global/js/notiflix-aio-3.2.6.min.js') }}"></script>

<script src="{{ asset('assets/global/js/pusher.min.js') }}"></script>

<script src="{{ asset('assets/global/js/vue.min.js') }}"></script>

<script src="{{ asset('assets/global/js/axios.min.js') }}"></script>

<script src="{{ asset('assets/admin/js/jquery.uploadPreview.min.js') }}"></script>

<script src="{{asset(template(true).'js/swiper.min.js')}}"></script>

<script src="{{asset($themeTrue.'js/custom_share.js')}}"></script>

<script src="{{asset($themeTrue.'js/user-script.js')}}?v={{time()}}"></script>

@stack('js-lib')

@stack('script')

@include('plugins')





<script>

    function currencyPosition(amount) {

        var currencyPosition = @json(basicControl()->is_currency_position);

        var has_space_between_currency_and_amount = @json(basicControl()->has_space_between_currency_and_amount);

        var currency_symbol = @json(basicControl()->currency_symbol);

        var base_currency = @json(basicControl()->base_currency);

        amount = parseFloat(amount).toFixed(2);

        if (currencyPosition === 'left' && has_space_between_currency_and_amount) {

            return currency_symbol + '  ' + amount;

        } else if (currencyPosition === 'left' && !has_space_between_currency_and_amount) {

            return currency_symbol + ' ' + amount;

        } else if (currencyPosition === 'right' && has_space_between_currency_and_amount) {

            return amount + '  ' + base_currency;

        } else {

            return amount + '  ' + base_currency;

        }

    }

</script>

<script>

    'use strict';

    $(document).on('input', '.global-search', function() {

        var search = $(this).val().toLowerCase();



        if (search.length == 0) {

            $('.search-result').find('.content').html('');

            $(this).siblings('.search-backdrop').addClass('d-none');

            $(this).siblings('.search-result').addClass('d-none');

            return false;

        }



        $('.search-result').find('.content').html('');

        $(this).siblings('.search-backdrop').removeClass('d-none');

        $(this).siblings('.search-result').removeClass('d-none');



        var match = $('.sidebar-nav li').filter(function(idx, element) {

            if (!$(element).find('a').hasClass('has-dropdown') && !$(element).hasClass('menu-header'))

                return $(element).text().trim().toLowerCase().indexOf(search) >= 0 ? element : null;

        }).sort();



        if (match.length == 0) {

            $('.search-result').find('.content').append(

        `<div class="search-item"><a href="javascript:void(0)">No result found</a></div>`);

            return false;

        }



        match.each(function(index, element) {

            var item_text = $(element).text().replace(/(\d+)/g, '').trim();

            var item_url = $(element).find('a').attr('href');

            if (item_url != '#') {

                $('.search-result').find('.content').append(

            `<div class="search-item"><a href="${item_url}">${item_text}</a></div>`);

            }

        });

    });

</script>



<script>

    "use strict";

    var root = document.querySelector(':root');

    root.style.setProperty('--primary-color', '{{basicControl()->primary_color}}');

    root.style.setProperty('--secondary-color', '{{basicControl()->secondary_color}}');

</script>





@if(basicControl()->in_app_notification)

<script>

    'use strict';

    let pushNotificationArea = new Vue({

        el: "#pushNotificationArea",

        data: {

            items: [],

        },

        mounted() {

            this.getNotifications();

            this.pushNewItem();

        },

        methods: {

            getNotifications() {

                let app = this;

                axios.get("{{ route('user.push.notification.show') }}")

                .then(function (res) {

                    app.items = res.data;

                })

            },

            readAt(id, link) {

                let app = this;

                let url = "{{ route('user.push.notification.readAt', 0) }}";

                url = url.replace(/.$/, id);

                axios.get(url)

                .then(function (res) {

                    if (res.status) {

                        app.getNotifications();

                        if (link !== '#') {

                            window.location.href = link

                        }

                    }

                })

            },

            readAll() {

                let app = this;

                let url = "{{ route('user.push.notification.readAll') }}";

                axios.get(url)

                .then(function (res) {

                    if (res.status) {

                        app.items = [];

                    }

                })

            },

            pushNewItem() {

                let app = this;

                Pusher.logToConsole = false;

                let pusher = new Pusher("{{ env('PUSHER_APP_KEY') }}", {

                    encrypted: true,

                    cluster: "{{ env('PUSHER_APP_CLUSTER') }}"

                });

                let channel = pusher.subscribe('user-notification.' + "{{ Auth::id() }}");

                channel.bind('App\\Events\\UserNotification', function (data) {

                    app.items.unshift(data.message);

                });

                channel.bind('App\\Events\\UpdateUserNotification', function (data) {

                    app.getNotifications();

                });

            }

        }

    });

</script>

@endif









@if (session()->has('success'))

<script>

    Notiflix.Notify.success("@lang(session('success'))");

</script>

@endif







@if (session()->has('error'))

<script>

    Notiflix.Notify.failure("@lang(session('error'))");

</script>

@endif



@if (session()->has('warning'))

<script>

    Notiflix.Notify.warning("@lang(session('warning'))");

</script>

@endif



</body>

</html>











