@extends('admin.layouts.app')
@section('page_title', __('Commission Report'))

@section('content')
<div class="content container-fluid">

    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title">@lang('Commission Report')</h1>
            </div>
            <div class="col-sm-auto">
                <a href="{{ route('admin.monthly.plan.index') }}" class="btn btn-primary">@lang('Back to List')</a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title">@lang('Referral Commission Report')</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <style>
                            .group-container {
                                margin-bottom: 20px;
                            }
                            .group-container .group-header {
                                background-color: #f8f9fa;
                                border: 2px solid #dee2e6;
                                border-radius: 5px 5px 0 0;
                            }
                            .group-container .group-body {
                                border-left: 2px solid #dee2e6;
                                border-right: 2px solid #dee2e6;
                                border-bottom: 2px solid #dee2e6;
                                border-radius: 0 0 5px 5px;
                                overflow: hidden;
                            }
                            .group-container .group-body .sub-group {
                                border-left: 1px dashed #adb5bd;
                                margin-left: 20px;
                                padding-left: 10px;
                            }
                            .level-0-row {
                                background-color: #eff5ff !important;
                                color: #000000 !important;
                            }
                            .level-1-row {
                                background-color: #c3e5fd !important;
                                color: #000000 !important;
                            }
                            .level-2-row {
                                background-color: #9ab4f5 !important;
                                color: #000000 !important;

                            }
                            .level-3-row {
                                background-color: #c4b7f7 !important;
                                color: #000000 !important;

                            }
                            .toggle-btn {
                                width: 24px;
                                height: 24px;
                                display: inline-flex;
                                align-items: center;
                                justify-content: center;
                                padding: 0;
                            }
                            .indent-cell {
                                padding-left: 30px !important;
                                position: relative;
                            }
                            .indent-cell:before {
                                content: "";
                                position: absolute;
                                left: 15px;
                                top: 50%;
                                width: 15px;
                                height: 1px;
                                background-color: #adb5bd;
                            }
                        </style>

                        <table class="table">
                            <thead>
                                <tr>
                                    <th style="width: 50px;"></th>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Level</th>
                                    <th>Purchased At</th>
                                    <th>Start Date</th>
                                    <th>End Date</th>
                                    <th>Total Machines</th>
                                    <th>Reward Commission</th>
                                    <th>Reward Commission %</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                             @foreach($referralReport as $agentId => $agentData)
                             @php
                             $groupClass = "group-{$agentId}";
                             $hasLevel1 = !empty($agentData['level1']);
                             @endphp

                             <tr class="group-header level-0-row">
                                <td>
                                    @if($hasLevel1)
                                    <button class="btn btn-sm btn-outline-primary toggle-btn" data-target="{{ $groupClass }}">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                    @endif
                                </td>
                                <td>{{ $agentData['agent']['user_id'] }}</td>
                                <td>{{ $agentData['agent']['user_name'] }} (self)</td>
                                <td><span class="badge bg-info">Level 0</span></td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                                <td>-</td>
                            </tr>

                            @if($hasLevel1)
                            <tbody class="group-body d-none {{ $groupClass }}">
                                @foreach($agentData['level1'] as $index => $level1)
                                @php
                                $subGroupClass = "{$groupClass}-l1-{$index}";
                                $hasLevel2 = !empty($level1['level2']);
                                @endphp

                                {{-- Level 1 rows as usual --}}
                                <tr class="level-1-row">
                                    <td class="indent-cell">
                                        @if($hasLevel2)
                                        <button class="btn btn-sm btn-outline-secondary toggle-btn" data-target="{{ $subGroupClass }}">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                        @endif
                                    </td>
                                    <td>{{ $level1['user_id'] }}</td>
                                    <td>{{ $level1['user_name'] }}</td>
                                    <td><span class="badge bg-success">Level 1</span></td>
                                    <td>{{ $level1['purchased_date'] }}</td>
                                    <td>{{ $level1['start_date'] }}</td>
                                    <td>{{ $level1['end_date'] }}</td>
                                    <td>{{ $level1['quantity'] }}</td>
                                    <td>{{ number_format($level1['commission'], 4) }}</td>
                                    <td>{{ $level1['commission_rate'] }}</td>
                                    <td>-</td>
                                </tr>

                                @if($hasLevel2)
                                <tbody class="sub-group d-none {{ $subGroupClass }}">
                                    @foreach($level1['level2'] as $level2Index => $level2)
                                    @php $hasLevel3 = !empty($level2['level3']); @endphp
                                    <tr class="level-2-row">
                                        <td class="indent-cell">
                                            @if($hasLevel3)
                                            <button class="btn btn-sm btn-outline-secondary toggle-btn" data-target="{{ $subGroupClass }}-l2-{{ $level2Index }}">
                                                <i class="fas fa-plus"></i>
                                            </button>
                                            @endif
                                        </td>
                                        <td>{{ $level2['user_id'] }}</td>
                                        <td>{{ $level2['user_name'] }}</td>
                                        <td><span class="badge bg-warning">Level 2</span></td>
                                        <td>{{ $level2['purchased_date'] }}</td>
                                        <td>{{ $level2['start_date'] }}</td>
                                        <td>{{ $level2['end_date'] }}</td>
                                        <td>{{ $level2['quantity'] }}</td>
                                        <td>{{ number_format($level2['commission'], 4) }}</td>
                                        <td>{{ $level2['commission_rate'] }}</td>
                                        <td>-</td>
                                    </tr>

                                    @if($hasLevel3)
                                    <tbody class="sub-group d-none {{ $subGroupClass }}-l2-{{ $level2Index }}">
                                        @foreach($level2['level3'] as $level3)
                                        <tr class="level-3-row">
                                            <td class="indent-cell"></td>
                                            <td>{{ $level3['user_id'] }}</td>
                                            <td>{{ $level3['user_name'] }}</td>
                                            <td><span class="badge bg-danger">Level 3</span></td>
                                            <td>{{ $level3['purchased_date'] }}</td>
                                            <td>{{ $level3['start_date'] }}</td>
                                            <td>{{ $level3['end_date'] }}</td>
                                            <td>{{ $level3['quantity'] }}</td>
                                            <td>{{ number_format($level3['commission'], 4) }}</td>
                                            <td>{{ $level3['commission_rate'] }}</td>
                                            <td>-</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                    @endif
                                    @endforeach
                                </tbody>
                                @endif

                                @endforeach
                            </tbody>
                            @endif
                            @endforeach

                        </tbody>
                    </table>

                    <script>
                        document.querySelectorAll('.toggle-btn').forEach(button => {
                            button.addEventListener('click', function () {
                                const targetClass = this.dataset.target;
                                const targetElement = document.querySelector(`.${targetClass}`);

                                if (!targetElement) return;

                                const isExpanding = targetElement.classList.contains('d-none');
                                targetElement.classList.toggle('d-none');
                                const icon = this.querySelector('i');
                                if (icon) {
                                    icon.classList.remove('fa-plus', 'fa-minus');
                                    icon.classList.add(isExpanding ? 'fa-minus' : 'fa-plus');
                                }
                                if (this.classList.contains('btn-outline-primary') || this.classList.contains('btn-primary')) {
                                    this.classList.toggle('btn-outline-primary', !isExpanding);
                                    this.classList.toggle('btn-primary', isExpanding);
                                }

                                if (this.classList.contains('btn-outline-secondary') || this.classList.contains('btn-secondary')) {
                                    this.classList.toggle('btn-outline-secondary', !isExpanding);
                                    this.classList.toggle('btn-secondary', isExpanding);
                                }
                            });
                        });
                    </script>


                </div>
            </div>
        </div>
    </div>
</div>
</div>
@endsection