@extends('admin.layouts.app')
@section('page_title', __('Overview'))
@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title">@lang('Overview')</h1>
            </div>
            <div class="col-sm-auto">
                <a href="{{ route('admin.monthly.plan.index') }}" class="btn btn-primary">@lang('Back to List')</a>
                @if($status != 1)
                <form method="POST" action="{{ route('admin.monthly.plan.approve', $configId) }}" class="d-inline">
                    @csrf
                    @method('PATCH')
                    <button type="submit" class="btn btn-success" onclick="return confirm('Are you sure you want to approve this configuration?')">
                        @lang('Approve Configuration')
                    </button>
                </form>
                @endif

            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <div class="row">
        <div class="col-lg-8">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title">@lang('Mining Report')</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>@lang('Customer ID')</th>
                                    <th>@lang('Customer Name')</th>
                                    <th>@lang('Plan')</th>
                                    <th>@lang('Quantity')</th>
                                    <th>@lang('Purchased At')</th>
                                    <th>@lang('Start Date')</th>
                                    <th>@lang('End Date')</th>
                                    <th>@lang('Days Vested')</th>
                                    <th>@lang('Hash Rate')</th>
                                    <th>@lang('Mining Reward')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($processedInvestments as $investment)
                                <tr>
                                    <td>{{ $investment['user_id'] }}</td>
                                    <td>{{ $investment['user_name'] }}</td>
                                    <td>
                                        @php
                                        $plan = \App\Models\InvestmentPlan::find($investment['planId']);
                                        @endphp
                                        {{ $plan->plan_name ?? 'N/A' }}
                                    </td>                                  
                                    <td>{{ $investment['quantity'] }}</td>
                                    <td>{{ $investment['purchased_date'] }}</td>
                                    <td>{{ $investment['effective_start_date'] }}</td>
                                    <td>{{ $investment['effective_end_date'] }}</td>
                                    <td>{{ $investment['days_invested'] }}</td>
                                    <td>{{ $investment['hashrate'] }}</td>
                                    <td>{{ number_format($investment['calculated_reward'], 4, '.', ',') }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card mt-4">
                <div class="card-header">
                    <h4 class="card-header-title">@lang('Summary')</h4>
                </div>
<div class="card-body">
    <div class="mb-3">
        <h6>@lang('Period')</h6>
        <p>{{ $summary['start_date'] }} to {{ $summary['end_date'] }}</p>
    </div>      
    <div class="mb-3">
        <h6>@lang('Total Date Period')</h6>
        <p>{{ $summary['total_date_period'] }}</p>
    </div>
    <div class="mb-3">
        <h6>@lang('Total Reward')</h6>
        <p>{{ number_format($summary['total_reward_setting'], 4, '.', ',') }}</p>
    </div>
    <div class="mb-3">
        <h6>@lang('Total Operation Cost')</h6>
        <p>{{ number_format($summary['total_operation_cost'], 4, '.', ',') }}</p>
    </div>
    <hr>
    <div class="mb-3">
        <h6>@lang('Reward Per Day')</h6>
        <p>{{ number_format($summary['reward_per_day'], 4, '.', ',') }}</p>
    </div>
    <hr>
    <div class="mb-3">
        <h6>@lang('Total Investments')</h6>
        <p>{{ $summary['total_investments'] }}</p>
    </div>
    <div class="mb-3">
        <h6>@lang('Total Investments Machines')</h6>
        <p>{{ $summary['total_quantity'] }}</p>
    </div>
    <hr>
    <div class="mb-3">
        <h5>@lang('Total Projected Rewards')</h5>
        <h4>{{ number_format($summary['total_reward'], 4, '.', ',') }}</h4>
    </div>
</div>

            </div>
        </div>
    </div>
</div>
@endsection