@extends('admin.layouts.app')
@section('page_title',__('Investment Plan'))
@section('content')
<div class="content container-fluid bg-light">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item"><a class="breadcrumb-link"
                           href="javascript:void(0);">@lang('Dashboard')</a></li>
                           <li class="breadcrumb-item active" aria-current="page">@lang('Investment Plan List')</li>
                       </ol>
                   </nav>
                   <h1 class="page-header-title">@lang('Investment Plan List')</h1>
               </div>
           </div>
       </div>
<!-- Subscription Purchase Limit Update Section -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0">@lang('Subscription Purchase Limit')</h5>
    </div>
    <div class="card-body">
        @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <form method="POST" action="{{ route('admin.investment.plan.inventory.update') }}">
            @csrf
            <div class="row align-items-center">
                <div class="col-md-4">
                    <label for="quantity" class="form-label">@lang('Unit Quantity')</label>
                    <input type="number" name="quantity" id="quantity" class="form-control @error('quantity') is-invalid @enderror"
                    value="{{ old('quantity', $inventory ?? 0) }}" min="0" required>
                    @error('quantity')
                    <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-2 mt-3 mt-md-4">
                    <button type="submit" class="btn btn-primary w-100">@lang('Update')</button>
                </div>
            </div>
        </form>
        <div class="mb-3">
            <div class="d-flex align-items-center gap-3">
                <div>
                    <span class="badge bg-primary p-2">
                        <i class="bi-box-seam me-1"></i> Available: <strong>{{ $available }}</strong>
                    </span>
                </div>

                <div>
                    <span class="badge bg-warning text-dark p-2">
                        <i class="bi-cart-check me-1"></i> Purchased: <strong>{{ $planPurchased }}</strong>
                    </span>
                </div>

                <div>
                    @if($soldOut)
                    <span class="badge bg-danger p-2">
                        <i class="bi-x-circle me-1"></i> Sold Out
                    </span>
                    @else
                    <span class="badge bg-success p-2">
                        <i class="bi-check-circle me-1"></i> In Stock
                    </span>
                    @endif
                </div>
            </div>
        </div>

    </div>
</div>

<div class="card">
    <div class="card-header card-header-content-md-between">
        <div class="mb-2 mb-md-0">

            <div class="input-group input-group-merge navbar-input-group">
                <div class="input-group-prepend input-group-text">
                    <i class="bi-search"></i>
                </div>
                <input type="search" id="datatableSearch"
                class="search form-control form-control-sm"
                placeholder="@lang('Search plan')"
                aria-label="@lang('Search plan')"
                autocomplete="off">
                <a class="input-group-append input-group-text display-none" href="javascript:void(0)">
                    <i id="clearSearchResultsIcon" class="bi-x"></i>
                </a>
            </div>

        </div>

        <div class="d-grid d-sm-flex justify-content-md-end align-items-sm-center gap-2">
           <a href="{{route('admin.investment.plan.create')}}" class="btn btn-primary"><i class="fa-duotone fa-solid fa-plus me-1"></i>@lang('New Plan')</a>
       </div>
   </div>

   <div class=" table-responsive datatable-custom  ">
    <table id="datatable"
    class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
    data-hs-datatables-options='{
       "columnDefs": [{
          "targets": [0, 8],
          "orderable": false
      }],
      "order": [],
      "info": {
         "totalQty": "#datatableWithPaginationInfoTotalQty"
     },
     "search": "#datatableSearch",
     "entries": "#datatableEntries",
     "pageLength": 15,
     "isResponsive": false,
     "isShowPaging": false,
     "pagination": "datatablePagination"
 }'>
 <thead class="thead-light">
    <tr>
        <th>@lang('SL.')</th>
        <th>@lang('Name')</th>
        <th>@lang('Plan Range')</th>
        <th>@lang('Plan Period')</th>
        <th>@lang('Status')</th>
        <th>@lang('Return Period')</th>
        <th>@lang('Profit')</th>
        <th>@lang('Capital Back')</th>
        <th>@lang('Action')</th>
    </tr>
</thead>

<tbody>

</tbody>
</table>
</div>

<div class="card-footer">
    <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
        <div class="col-sm mb-2 mb-sm-0">
            <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                <span class="me-2">@lang('Showing:')</span>
                <!-- Select -->
                <div class="tom-select-custom">
                    <select id="datatableEntries"
                    class="js-select form-select form-select-borderless w-auto" autocomplete="off"
                    data-hs-tom-select-options='{
                        "searchInDropdown": false,
                        "hideSearch": true
                    }'>
                    <option value="10">10</option>
                    <option value="20" selected>20</option>
                    <option value="30">30</option>
                    <option value="40">40</option>
                </select>
            </div>
            <span class="text-secondary me-2">@lang('of')</span>
            <span id="datatableWithPaginationInfoTotalQty"></span>
        </div>
    </div>


    <div class="col-sm-auto">
        <div class="d-flex  justify-content-center justify-content-sm-end">
            <nav id="datatablePagination" aria-label="Activity pagination"></nav>
        </div>
    </div>
</div>
</div>

</div>
</div>


<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
data-bs-backdrop="static"
aria-hidden="true">
<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="deleteModalLabel"><i
                class="bi bi-check2-square"></i> @lang("Confirmation")</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="" method="post" id="setRoute">
                @csrf
                @method('DELETE')
                <div class="modal-body">
                    <p>@lang("Do you want to delete this Item")</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-bs-dismiss="modal">@lang('Close')</button>
                    <button type="submit" class="btn btn-primary">@lang('Confirm')</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Delete Modal -->

@endsection


@push('css-lib')
<link rel="stylesheet" href="{{ asset('assets/admin/css/tom-select.bootstrap5.css') }}">
<link rel="stylesheet" href="{{ asset('assets/admin/css/flatpickr.min.css') }}">
@endpush


@push('js-lib')
<script src="{{ asset('assets/admin/js/tom-select.complete.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/flatpickr.min.js') }}"></script>
@endpush


@push('script')
<script>

    $(document).on('click','.deleteBtn',function (){
        $('#setRoute').attr('action',$(this).data('route'))
    })
    $(document).on('ready', function () {

        HSCore.components.HSFlatpickr.init('.js-flatpickr')
        HSCore.components.HSTomSelect.init('.js-select', {
            maxOptions: 250,
        })
        HSCore.components.HSDatatables.init($('#datatable'), {
            processing: true,
            serverSide: true,
            ordering: false,
            ajax: {
                url: "{{ route("admin.investment.plan.list") }}",
            },

            columns: [
                {data: 'sl', name: 'sl'},
                {data: 'name', name: 'name'},
                {data: 'price', name: 'price'},
                {data: 'period', name: 'period'},
                {data: 'status', name: 'status'},
                {data: 'return_period', name: 'return_period'},
                {data: 'profit', name: 'profit'},
                {data: 'capital_back', name: 'capital_back'},
                {data: 'action', name: 'action'},
            ],

            language: {
                zeroRecords: `<div class="text-center p-4">
                    <img class="dataTables-image mb-3" src="{{ asset('assets/admin/img/oc-error.svg') }}" alt="Image Description" data-hs-theme-appearance="default">
                    <img class="dataTables-image mb-3" src="{{ asset('assets/admin/img/oc-error-light.svg') }}" alt="Image Description" data-hs-theme-appearance="dark">
                    <p class="mb-0">No data to show</p>
                </div>`,
                processing: `<div><div></div><div></div><div></div><div></div></div>`
            },
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });

</script>
@endpush




