@extends('admin.layouts.app')
@section('page_title', __('Edit Admin'))
@section('content')
<div class="content container-fluid">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm">
                <h1 class="page-header-title">@lang('Edit Admin')</h1>
            </div>
            <div class="col-sm-auto">
                <a href="{{ route('admin.admins.index') }}" class="btn btn-primary">@lang('Back to List')</a>
            </div>
        </div>
    </div>

    <form action="{{ route('admin.admins.update', $admin->id) }}" method="post">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header"><h4>@lang('Admin Information')</h4></div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Name -->
                            <div class="col-md-6 mb-4">
                                <label for="name">@lang('Name')</label>
                                <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror"
                                    value="{{ old('name', $admin->name) }}" required>
                                @error('name') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>

                            <!-- Username -->
                            <div class="col-md-6 mb-4">
                                <label for="username">@lang('Username')</label>
                                <input type="text" name="username" id="username" class="form-control @error('username') is-invalid @enderror"
                                    value="{{ old('username', $admin->username) }}" required>
                                @error('username') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>

                            <!-- Email -->
                            <div class="col-md-6 mb-4">
                                <label for="email">@lang('Email')</label>
                                <input type="email" name="email" id="email" class="form-control @error('email') is-invalid @enderror"
                                    value="{{ old('email', $admin->email) }}" required>
                                @error('email') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>

                            <!-- Password -->
                            <div class="col-md-6 mb-4">
                                <label for="password">@lang('Password')</label>
                                <input type="password" name="password" id="password" class="form-control @error('password') is-invalid @enderror">
                                <small class="form-text text-muted">@lang('Leave blank if not changing')</small>
                                @error('password') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>

                            <!-- Confirm Password -->
                            <div class="col-md-6 mb-4">
                                <label for="password_confirmation">@lang('Confirm Password')</label>
                                <input type="password" name="password_confirmation" id="password_confirmation"
                                    class="form-control @error('password_confirmation') is-invalid @enderror">
                                @error('password_confirmation') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>

                            <!-- Status -->
                            <div class="col-md-6 mb-4">
                                <label for="status">@lang('Status')</label>
                                <select name="status" id="status" class="form-control @error('status') is-invalid @enderror">
                                    <option value="1" {{ old('status', $admin->status) == 1 ? 'selected' : '' }}>@lang('Active')</option>
                                    <option value="0" {{ old('status', $admin->status) == 0 ? 'selected' : '' }}>@lang('Inactive')</option>
                                </select>
                                @error('status') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header"><h4>@lang('Actions')</h4></div>
                    <div class="card-body">
                        <div class="d-grid gap-3">
                            <button type="submit" class="btn btn-primary">@lang('Update Admin')</button>
                            <a href="{{ route('admin.admins.index') }}" class="btn btn-secondary">@lang('Cancel')</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
