<?php



namespace App\Http\Controllers\User;



use Illuminate\Http\Request;

use App\Models\WalletType;

use App\Models\Wallet;

use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\Controller;



class UserWalletController extends Controller

{

    public function __construct()

    {

        $this->middleware(['auth']);

        $this->middleware(function ($request, $next) {

            $this->user = auth()->user();

            return $next($request);

        });

        $this->theme = template();

    }

    public function index()

    {

        $walletAddresses = Wallet::where('user_id', Auth::id())->get();



        $walletTypes = WalletType::all();



        return view(template() . 'user.wallet.index', compact('walletAddresses', 'walletTypes'));



    }



    public function store(Request $request)

    {

        $validated = $request->validate([

            'wallet_type' => 'required|exists:wallet_type,id', 

            // 'address' => 'required|string|max:255',

            'address.0' => 'required|string',

        ]);

        
        $address = $validated['address'][0] ? $validated['address'][0] : null;




    // Check if user already has an address for the selected wallet type

        $existingWallet = Wallet::where('user_id', Auth::id())

        ->where('type', $validated['wallet_type'])

        ->first();



        if ($existingWallet) {

        // If the user already has a wallet address for this type, update it

            $existingWallet->address = $address;

            $existingWallet->save();

            return redirect()->route('user.wallet')->with('success', 'Wallet address updated successfully.');

        } else {

        // Otherwise, create a new wallet address

            $walletAddress = new Wallet();

            $walletAddress->user_id = Auth::id();

            $walletAddress->type = $validated['wallet_type'];

            $walletAddress->address = $address;

            $walletAddress->save();

            return redirect()->route('user.wallet')->with('success', 'Wallet address added successfully.');

        }

    }



    public function destroy($id)

    {

        $walletAddress = Wallet::where('id', $id)

        ->where('user_id', Auth::id())

        ->first();



        if ($walletAddress) {

            $walletAddress->delete();

            return redirect()->route('user.wallet')->with('success', 'Wallet address deleted successfully.');

        }



        return redirect()->route('user.wallet')->with('error', 'Wallet address not found.');

    }

}

