<?php



namespace App\Http\Controllers;



use App\Models\Deposit;

use App\Models\Gateway;

use App\Models\Order;

use App\Models\Page;

use App\Models\InvestmentPlan;

use App\Traits\Notify;

use App\Traits\Upload;

use Carbon\Carbon;

use Illuminate\Http\Request;

use Facades\App\Services\BasicService;

use Exception;

use Illuminate\Support\Facades\Validator;





class PaymentController extends Controller

{



    use Upload, Notify;



    public function __construct()

    {

        $this->theme = template();

    }



    public function index()

    {

        try {

            //to get amount and decrypt

            $amount = session()->get('amount');

            $amount = decrypt($amount);

            //to get plan and decrypt

            $getPlan=session()->get('plan_id');

            $plan_id = decrypt($getPlan);

            $plandetail=InvestmentPlan::find($plan_id);

            //once get and calculate the quantity

            $unitPrice=$plandetail->getUnitPrice();

            $getquantity = (int) ($amount / $unitPrice);

            //return amount and qunatity

            $data['quantity'] = $getquantity;

            $data['amount'] = $amount;

            //to return the description of the plan

            $data['plan_detail'] = $plandetail;

            //return payment method

            $data['gateways'] = Gateway::where('status', 1)->orderBy('sort_by', 'ASC')->get();

            return view(template().'pages.payment',$data);



        }catch (Exception $e){

            return back()->with('error', $e->getMessage());

        }

    }

    //this is to test the payment details



    public function test(){

        $amount=30000;

        $getPlan=session()->get('plan_id');

        $plan_id = decrypt($getPlan);

        $plandetail=InvestmentPlan::find($plan_id);

        $unitPrice=$plandetail->getUnitPrice();

        $getquantity = (int) ($amount / $unitPrice);

        dd($plandetail);

    }



    public function checkAmount(Request $request)

    {

        $amount = $request->amount;

        $selectedCurrency = $request->selected_currency;

        $selectGateway = $request->select_gateway;

        $selectedCryptoCurrency = $request->selectedCryptoCurrency;

        $data = $this->checkAmountValidate($amount, $selectedCurrency, $selectGateway, $selectedCryptoCurrency);

        return response()->json($data);

    }



    public function checkAmountValidate($amount, $selectedCurrency, $selectGateway, $selectedCryptoCurrency = null)

    {

        $selectGateway = Gateway::where('id', $selectGateway)->where('status', 1)->first();

        if (!$selectGateway) {

            return ['status' => false, 'message' => "Payment method not available for this transaction"];

        }





        if ($selectGateway->currency_type == 1) {

            $selectedCurrency = array_search($selectedCurrency, $selectGateway->supported_currency);

            if ($selectedCurrency !== false) {

                $selectedPayCurrency = $selectGateway->supported_currency[$selectedCurrency];

            } else {

                return ['status' => false, 'message' => "Please choose the currency you'd like to use for payment"];

            }

        }



        if ($selectGateway->currency_type == 0) {

            $selectedCurrency = array_search($selectedCryptoCurrency, $selectGateway->supported_currency);

            if ($selectedCurrency !== false) {

                $selectedPayCurrency = $selectGateway->supported_currency[$selectedCurrency];

            } else {

                return ['status' => false, 'message' => "Please choose the currency you'd like to use for payment"];

            }

        }



        if ($selectGateway) {

            $receivableCurrencies = $selectGateway->receivable_currencies;

            if (is_array($receivableCurrencies)) {

                if ($selectGateway->id < 999) {

                    $currencyInfo = collect($receivableCurrencies)->where('name', $selectedPayCurrency)->first();

                } else {

                    if ($selectGateway->currency_type == 1) {

                        $currencyInfo = collect($receivableCurrencies)->where('currency', $selectedPayCurrency)->first();

                    } else {

                        $currencyInfo = collect($receivableCurrencies)->where('currency', $selectedCryptoCurrency)->first();

                    }

                }

            } else {

                return null;

            }

        }





        $currencyType = $selectGateway->currency_type;

        $limit = $currencyType == 0 ? 8 : 2;

        $amount = getAmount($amount * $currencyInfo->conversion_rate, $limit);

        $status = false;



        if ($currencyInfo) {

            $percentage = getAmount($currencyInfo->percentage_charge, $limit);

            $percentage_charge = getAmount(($amount * $percentage) / 100, $limit);

            $fixed_charge = getAmount($currencyInfo->fixed_charge, $limit);

            $min_limit = getAmount($currencyInfo->min_limit, $limit);

            $max_limit = getAmount($currencyInfo->max_limit, $limit);

            $charge = getAmount($percentage_charge + $fixed_charge, $limit);

        }



        $basicControl = basicControl();

        $payable_amount = getAmount($amount + $charge, $limit);

        $amount_in_base_currency = getAmount($payable_amount / $currencyInfo->conversion_rate ?? 1, $limit);



        if ($amount < $min_limit || $amount > $max_limit) {

            $message = "minimum payment $min_limit and maximum payment limit $max_limit";

        } else {

            $status = true;

            $message = "Amount : $amount" . " " . $selectedPayCurrency;

        }



        $data['status'] = $status;

        $data['message'] = $message;

        $data['fixed_charge'] = $fixed_charge;

        $data['percentage'] = $percentage;

        $data['percentage_charge'] = $percentage_charge;

        $data['min_limit'] = $min_limit;

        $data['max_limit'] = $max_limit;

        $data['payable_amount'] = $payable_amount;

        $data['charge'] = $charge;

        $data['amount'] = $amount;

        $data['conversion_rate'] = $currencyInfo->conversion_rate ?? 1;

        $data['amount_in_base_currency'] = number_format($amount_in_base_currency, 2);

        $data['currency'] = ($selectGateway->currency_type == 1) ? ($currencyInfo->name ?? $currencyInfo->currency) : "USD";

        $data['base_currency'] = $basicControl->base_currency;

        $data['currency_limit'] = $limit;





        return $data;

    }



    public function depositConfirm($trx_id)

    {

        try {

            $deposit = Deposit::with('user', 'depositable')->where(['trx_id' => $trx_id, 'status' => 0])->first();

            if (!$deposit) {

                throw new Exception('Invalid Payment Request.');

            }

            $gateway = Gateway::findOrFail($deposit->payment_method_id);

            if (!$gateway) {

                throw new Exception('Invalid Payment Gateway.');

            }



            if (999 < $gateway->id) {

                return view(template() . 'user.payment.manual', compact('deposit'));

            }



            $gatewayObj = 'App\\Services\\Gateway\\' . $gateway->code . '\\Payment';

            $data = $gatewayObj::prepareData($deposit, $gateway);

            $data = json_decode($data);



        } catch (Exception $exception) {

            session()->flash('warning', 'Something went wrong. Please try again.');

            return back()->with('error', $exception->getMessage());

        }



        if (isset($data->error)) {

            return back()->with('error', $data->message);

        }



        if (isset($data->redirect)) {

            return redirect($data->redirect_url);

        }



        $page_title = 'Payment Confirm';

        return view($this->theme . $data->view, compact('data', 'page_title', 'deposit'));



    }



    public function gatewayIpn(Request $request, $code, $trx = null, $type = null)

    {

        if (isset($request->m_orderid)) {

            $trx = $request->m_orderid;

        }



        if ($code == 'coinbasecommerce') {

            $gateway = Gateway::where('code', $code)->first();

            $postdata = file_get_contents("php://input");

            $res = json_decode($postdata);



            if (isset($res->event)) {

                $deposit = Deposit::with('user')->where('trx_id', $res->event->data->metadata->trx)->orderBy('id', 'DESC')->first();

                $sentSign = $request->header('X-Cc-Webhook-Signature');

                $sig = hash_hmac('sha256', $postdata, $gateway->parameters->secret);



                if ($sentSign == $sig) {

                    if ($res->event->type == 'charge:confirmed' && $deposit->status == 0) {

                        BasicService::preparePaymentUpgradation($deposit);

                    }

                }

            }

            session()->flash('success', 'You request has been processing.');



            return redirect()->route('success');

        }



        try {

            $gateway = Gateway::where('code', $code)->first();

            if (!$gateway) {

                throw new Exception('Invalid Payment Gateway.');

            }

            if (isset($trx)) {

                $deposit = Deposit::with('user')->where('trx_id', $trx)->first();

                if (!$deposit) throw new Exception('Invalid Payment Request.');

            }



            $gatewayObj = 'App\\Services\\Gateway\\' . $code . '\\Payment';

            $data = $gatewayObj::ipn($request, $gateway, $deposit ?? null, $trx ?? null, $type ?? null);



        } catch (\Exception $exception) {

            return back()->with('error', $exception->getMessage());

        }

        if (isset($data['redirect'])) {

            return redirect($data['redirect'])->with($data['status'], $data['msg']);

        }

    }





    public function fromSubmit(Request $request, $trx_id)

    {

        $data = Deposit::where('trx_id', $trx_id)->orderBy('id', 'DESC')->with(['gateway', 'user'])->first();

        if (is_null($data)) {

            return redirect()->route('pricing')->with('error', 'Invalid Request');

        }

        if ($data->status != 0) {

            return redirect()->route('failed')->with('error', 'Invalid Request');

        }



        $params = optional($data->gateway)->parameters;

        $reqData = $request->except('_token', '_method');

        $rules = [];

        if ($params !== null) {

            foreach ($params as $key => $cus) {

                $rules[$key] = [$cus->validation == 'required' ? $cus->validation : 'nullable'];

                if ($cus->type === 'file') {

                    $rules[$key][] = 'image';

                    $rules[$key][] = 'mimes:jpeg,jpg,png';

                    $rules[$key][] = 'max:2048';

                } elseif ($cus->type === 'text') {

                    $rules[$key][] = 'max:191';

                } elseif ($cus->type === 'number') {

                    $rules[$key][] = 'integer';

                } elseif ($cus->type === 'textarea') {

                    $rules[$key][] = 'min:3';

                    $rules[$key][] = 'max:300';

                }

            }

        }



        $validator = Validator::make($reqData, $rules);

        if ($validator->fails()) {

            return back()->withErrors($validator)->withInput();

        }



        $reqField = [];

        if ($params != null) {

            foreach ($request->except('_token', '_method', 'type') as $k => $v) {

                foreach ($params as $inKey => $inVal) {

                    if ($k == $inKey) {

                        if ($inVal->type == 'file' && $request->hasFile($inKey)) {

                            try {

                                $file = $this->fileUpload($request[$inKey], config('filelocation.deposit.path'), config('filesystems.default'), null, null, null, null, 40);

                                $reqField[$inKey] = [

                                    'field_name' => $inVal->field_name,

                                    'field_value' => $file['path'],

                                    'field_driver' => $file['driver'],

                                    'validation' => $inVal->validation,

                                    'type' => $inVal->type,

                                ];

                            } catch (\Exception $exp) {

                                session()->flash('error', 'Could not upload your ' . $inKey);

                                return back()->withInput();

                            }

                        } else {

                            $reqField[$inKey] = [

                                'field_name' => $inVal->field_name,

                                'validation' => $inVal->validation,

                                'field_value' => $v,

                                'type' => $inVal->type,

                            ];

                        }

                    }

                }

            }

        }



        $data->update([

            'information' => $reqField,

            'created_at' => Carbon::now(),

            'status' => 2,

        ]);



        $msg = [

            'username' => optional($data->user)->username,

            'amount' => currencyPosition($data->amount),

            'gateway' => optional($data->gateway)->name

        ];

        $action = [

            "name" => optional($data->user)->firstname . ' ' . optional($data->user)->lastname,

            "image" => getFile(optional($data->user)->image_driver, optional($data->user)->image),

            "link" => route('admin.user.payment', $data->user_id),

            "icon" => "fa fa-money-bill-alt text-white"

        ];



        $this->adminPushNotification('PAYMENT_REQUEST', $msg, $action);

        $this->adminFirebasePushNotification('PAYMENT_REQUEST', $msg, $action);

        $this->adminMail('PAYMENT_REQUEST', $msg);



        session()->flash('success', 'You request has been taken.');

        return redirect()->route('user.fund.index');



    }



    public function success($id = null)

    {

        if ($id){

            $order = Order::findOrFail($id);

            return view(template().'pages.order_completed',compact('order'));

        }

        return view('success');

    }



    public function failed()

    {

        return view('failed');

    }



}

