<?php

namespace App\Http\Controllers\Auth;

use App\Helpers\UserSystemInfo;
use App\Http\Controllers\Controller;
use App\Models\ContentDetails;
use App\Models\NotificationPermission;
use App\Models\Page;
use App\Models\ReferralBonus;
use App\Models\User;
use App\Models\UserLogin;
use App\Traits\Notify;
use Facades\App\Services\BasicService;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Password;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\JsonResponse;
use App\Rules\PhoneLength;
use App\Models\ContentSetting;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers,Notify;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */

    protected $maxAttempts = 3; // Change this to 4 if you want 4 tries
    protected $decayMinutes = 5; // Change this according to your
    protected $redirectTo = '/user/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->theme = template();
        $this->middleware('guest')->except('register2','sendemailtest');
    }

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\View\View
     */
    public function showRegistrationForm(Request $request)
    {
        $basic = basicControl();
        if ($basic->registration == 0) {
            return redirect('/')->with('warning', 'Registration Has Been Disabled.');
        }
        $section = 'register_section';
        $footer_section = ContentDetails::with('content')
        ->whereHas('content', function ($query) use ($section) {
            $query->where('name', $section);
        })
        ->get();
        $single_content = $footer_section->where('content.name', 'register_section')->where('content.type', 'single')->first();
        $data['register_section']= [
            'single' => $single_content? collect($single_content->description ?? [])->merge($single_content->content->only('media')) : [],
        ];
        $data['siteKey'] = config('google.recaptcha_site_key');
        $data['referral_code'] = '';

        if (!empty($request->ref)) {
            $refUser = User::where('referral_code', $request->ref)->first();

            if ($refUser) {
                $data['referral_code'] = $refUser->referral_code;
            }
        }
        $data['contract_content'] = ContentSetting::where("type", "register_contract_and_agreement")->first();


        $page= Page::where('slug', 'register')->first();
        $data['pageSeo'] = [
            'page_title' => $page->page_title,
            'meta_title' => $page->meta_title,
            'meta_keywords' => isset($page->meta_keywords) && $page->meta_keywords ?implode(',', $page->meta_keywords ?? []):'',
            'meta_description' => $page->meta_description,
            'og_description' => $page->og_description,
            'meta_robots' => $page->meta_robots,
            'meta_image' => getFile($page->meta_image_driver, $page->meta_image),
            'breadcrumb_image' => $page->breadcrumb_status ?
            getFile($page->breadcrumb_image_driver, $page->breadcrumb_image) : null,
        ];
        return view(template() . 'auth.register',$data);
    }

    protected function validator(array $data)
    {
        $basicControl = basicControl();

        $rules['password'] = ["required", 'confirmed',
        Password::min(6)->mixedCase()
        ->letters()
        ->numbers()
        ->symbols()];

        if ($basicControl->google_recaptcha && $basicControl->google_recaptcha_user_registration) {
            $rules['g-recaptcha-response'] = ['sometimes', 'required'];
        }

        if ($basicControl->manual_recaptcha && basicControl()->manual_recaptcha_user_registration){
            $rules['captcha'] = ['required',function($attribute, $value, $fail){
                if ($value !== session()->get('captcha')){
                    $fail('The captcha does not match');
                }
            }];
        }

        $rules['first_name'] = ['required', 'string', 'max:91'];
        $rules['last_name'] = ['required', 'string', 'max:91'];
        $rules['email'] = ['required', 'string', 'email', 'max:255',  'unique:users,email'];
        if (!empty($data['referral_code'])) {
            $ref_id = User::where('referral_code', $data['referral_code'])->first();
            if (!$ref_id) {
                $rules['referral_code'] = ['exists:users,referral_code'];
            }
        }

        return Validator::make($data, $rules, [
            'first_name.required' => 'First Name Field is required',
            'last_name.required' => 'Last Name Field is required',
            'g-recaptcha-response.required' => 'The reCAPTCHA field is required.',
            'referral_code.exists' => 'The provided referral code is invalid.',
        ]);
    }

    protected function create(array $data)
    {
        $basic = basicControl();
        $referID = User::where('referral_code', $data['referral_code'])->value('id');
        
        $user = User::create([
            'firstname' => $data['first_name'],
            'lastname' => $data['last_name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
            'email_verification' => ($basic->email_verification) ? 0 : 1,
            'sms_verification' => 0,
            'referral_id' => $referID ?? null,
        ]);
        
        // Generate a unique referral code
        $randomString = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 6);
        $user->referral_code = $randomString . $user->id;
        $user->save();
        
        return $user;
    }


    public function register(Request $request)
    {
        $this->validator($request->all())->validate();

        $user = $this->create($request->all());

        $this->setNotificationPermission($user);

        if (basicControl()->registration_bonus){
            $this->sendRegistrationBonus($user);
        }

        $params = [
            'username' => $user->firstname,

        ];
        $this->sendMailSms($user, 'NEW_USER_REGISTRATION', $params);
        $this->guard()->login($user);

        if ($response = $this->registered($request, $user)) {
            return $response;
        }

        if ($request->ajax()) {
            return route('user.home');
        }

        return $request->wantsJson()
        ? new JsonResponse([], 201)
        : redirect($this->redirectPath());
    }
    public function register2(Request $request)
    {
        $this->validator($request->all())->validate();

        $user = $this->create($request->all());

        $params = [
            'email' => $user->email,
            'password' => $request->password, 
            'username' => $user->firstname,

        ];
        $this->sendMailSms($user, 'NEW_USER_REGISTRATION_OFFLINE', $params);


        return redirect('https://petarig.fireworksmedia.com/project/admin/users/all');

    }
    public function sendemailtest()
    {
        $user = User::find(2);
        //dd($user);
        // $params = [
        //     'email' => $user->email,
        //     'password' => 'test1234', 
        //     'username' => $user->firstname . ' ' . $user->lastname,
        // ];

        //$this->sendMailSms($user, 'NEW_USER_REGISTRATION_OFFLINE', $params);
        // $params = [
        //     'username' => 'john_doe',
        //     'quantity' => 5,
        //     'plan_name' => 'Premium Investment',
        //     'payment_date' => '9th May, 2025',
        //     'invoice_number' => 'INV-123456',
        //     'amount' => '$1,500.75',
        //     'total_payment' => '$1,500.75',
        // ];

        // $this->sendMailSms($user, 'PLAN_INVEST_USER', $params);

        // $params = [
        //     'plan_name' => 'Premium Investment',
        //     'payment_date' => '9th May, 2025',
        //     'expired_date' => '8th June, 2025',
        // ];

        // $this->sendMailSms($user, 'PLAN_INVEST_USER_CONFIRM', $params);
        $params = [
            'bonus_from' => "shengchi2",
        ];
        $this->sendMailSms($user, 'REFERRAL_BONUS', $params);

    }

    public function setNotificationPermission($user) :void
    {
        NotificationPermission::create([
            'notifyable_id' => $user->id,
            'notifyable_type' => User::class,
            'template_email_key' => config('notifypermission.email'),
            'template_in_app_key' => config('notifypermission.in_app'),
            'template_push_key' => config('notifypermission.push'),
            'template_sms_key' => config('notifypermission.sms'),

        ]);
    }


    public function sendRegistrationBonus($user):void
    {
/*        $user->profit_balance += basicControl()->registration_bonus_amount;
        $user->save();
        $transaction = BasicService::makeTransaction($user, basicControl()->registration_bonus_amount, 0, '+', null, 'Signup Bonus',$user,'profit');
        $user->transactional()->save($transaction);

        $params = [
            'transaction_id' => $transaction->trx_id,
            'bonus_amount' => currencyPosition(getAmount(basicControl()->registration_bonus_amount)),
            'username' => $user->firstname.' '.$user->lastname,

        ];
        $action = [
            'link' => '#',
            'icon' => 'fa fa-money-bill-alt text-white'
        ];*/

        //$this->userPushNotification($user, 'REGISTRATION_BONUS', $params, $action);
        //$this->userFirebasePushNotification($user, 'REGISTRATION_BONUS', $params, '#');
        //$this->sendMailSms($user, 'REGISTRATION_BONUS', $params);

        if ($user->referral){
            $referralUser = $user->referral;
/*            $referralUser->profit_balance += basicControl()->referral_user_bonus_amount;
            $referralUser->save();

            $transaction = BasicService::makeTransaction($referralUser, basicControl()->referral_user_bonus_amount, 0, '+', null, 'Signup Referral Bonus',$referralUser,'profit');
            $trx = $transaction->trx_id;

            $bonus = new ReferralBonus();
            $bonus->from_user_id = $referralUser->id; // those person who Referred for investment
            $bonus->to_user_id = $user->id; // those person who signup
            $bonus->level = 1;
            $bonus->amount = getAmount(basicControl()->referral_user_bonus_amount);
            $bonus->commission_type = 'Registration Bonus';
            $bonus->trx_id = $trx;
            $bonus->remarks = 'Referral bonus From' . ' '.$user->firstname.' '.$user->lastname;
            $bonus->save();
            $bonus->transactional()->save($transaction);*/

            $params = [
                'transaction_id' => "123",
                'amount' => 0,
                'bonus_from' => $user->firstname.' '.$user->lastname,
                'final_balance' => 0,
                'level' => 1
            ];
/*            $action = [
                'link' => route('user.referral.bonus'),
                'icon' => 'fa fa-money-bill-alt text-white'
            ];*/
          //  $firebaseAction = route('user.referral.bonus');

            //$this->userPushNotification($referralUser, 'REFERRAL_BONUS', $params, $action);
           // $this->userFirebasePushNotification($referralUser, 'REFERRAL_BONUS', $params, $firebaseAction);
            $this->sendMailSms($referralUser, 'REFERRAL_BONUS', $params);
        }


    }

    protected function registered(Request $request, $user)
    {
        $user->last_login = Carbon::now();
        $user->last_seen = Carbon::now();
        $user->two_fa_verify = ($user->two_fa == 1) ? 0 : 1;
        $user->save();

        $info = @json_decode(json_encode(getIpInfo()), true);
        $ul['user_id'] = $user->id;

        $ul['longitude'] = (!empty(@$info['long'])) ? implode(',', $info['long']) : null;
        $ul['latitude'] = (!empty(@$info['lat'])) ? implode(',', $info['lat']) : null;
        $ul['country_code'] = (!empty(@$info['code'])) ? implode(',', $info['code']) : null;
        $ul['location'] = (!empty(@$info['city'])) ? implode(',', $info['city']) . (" - " . @implode(',', @$info['area']) . "- ") . @implode(',', $info['country']) . (" - " . @implode(',', $info['code']) . " ") : null;
        $ul['country'] = (!empty(@$info['country'])) ? @implode(',', @$info['country']) : null;

        $ul['ip_address'] = UserSystemInfo::get_ip();
        $ul['browser'] = UserSystemInfo::get_browsers();
        $ul['os'] = UserSystemInfo::get_os();
        $ul['get_device'] = UserSystemInfo::get_device();

        UserLogin::create($ul);

        $msg = [
            'username' => $user->username,
        ];
        $action = [
            "link" => '#',
            "icon" => "fa fa-money-bill-alt"
        ];
        //$this->userPushNotification($user,'NEW_USER_REGISTRATION',$msg,$action);
        //$this->userFirebasePushNotification($user,'NEW_USER_REGISTRATION',$msg,'#');
        //$this->sendMailSms($user,'NEW_USER_REGISTRATION',$msg);

    }

    protected function guard()
    {
        return Auth::guard();
    }

}
