<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Carbon\Carbon;
use App\Models\Admin;

use DateTime;

class AdminController extends Controller
{
	public function index()
	{
		$admins = Admin::all();
		return view('admin.admin.index', compact('admins'));
	}

	public function create()
	{
		return view('admin.admin.create');
	}

	public function store(Request $request)
	{
		$validated = $request->validate([
			'name' => 'required|string|max:255',
			'username' => 'required|string|max:255|unique:admins,username',
			'email' => 'required|email|max:255|unique:admins,email',
			'password' => 'required|string|min:6|confirmed',
			'status' => 'required|in:0,1',
		]);

		$validated['password'] = bcrypt($validated['password']);

		Admin::create($validated);

		return redirect()
		->route('admin.admins.index')
		->with('success', 'Admin added successfully.');
	}
	public function edit($id)
	{
		$admin = Admin::findOrFail($id);
		return view('admin.admin.edit', compact('admin'));
	}
	public function update(Request $request, $id)
	{
		$admin = Admin::findOrFail($id);

		$validated = $request->validate([
			'name' => 'required|string|max:255',
			'username' => 'required|string|max:255|unique:admins,username,' . $admin->id,
			'email' => 'required|email|max:255|unique:admins,email,' . $admin->id,
			'password' => 'nullable|string|min:6|confirmed',
			'status' => 'required|in:0,1',
		]);

		if (!empty($validated['password'])) {
			$validated['password'] = bcrypt($validated['password']);
		} else {
			unset($validated['password']);
		}

		$admin->update($validated);

		return redirect()
		->route('admin.admins.index')
		->with('success', 'Admin updated successfully.');
	}
	public function destroy($id)
	{
		$admin = Admin::findOrFail($id);

		if (auth('admin')->id() === $admin->id) {
			return redirect()
			->route('admin.admins.index')
			->with('error', 'You cannot delete your own admin account.');
		}

		$admin->delete();

		return redirect()
		->route('admin.admins.index')
		->with('success', 'Admin deleted successfully.');
	}



}