
<?php $__env->startSection('title',trans('Plan Investment')); ?>
<?php $__env->startSection('content'); ?>
    <div class="pagetitle">
        <h3 class="mb-1"><?php echo app('translator')->get('Plan Investment'); ?></h3>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                <li class="breadcrumb-item active"><?php echo app('translator')->get('Plan Investment'); ?></li>
            </ol>
        </nav>
    </div>

    <div class="card mt-50">
        <div class="card-header btn-area d-flex justify-content-end">
            <button type="button" class="btn-custom btn-white btn-custom-sm" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSearch" aria-controls="offcanvasExample"><i class="fa-light fa-search me-1"></i><?php echo app('translator')->get('Filter'); ?> <span></span> </button>
        </div>

        <div class="card-body">
            <div class="cmn-table">
                <div class="table-responsive">
                    <table class="table  align-middle">
                        <thead>
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('SL'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Plan'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Profit'); ?>
                                <i class="fa-sharp fa-thin fa-circle-info ms-1"
                                                               data-bs-toggle="tooltip" data-bs-placement="top"
                                                               aria-label="Per Return"
                                                               data-bs-original-title="Per Return"></i></th>
                            <th scope="col"><?php echo app('translator')->get('Return Period'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Received Amount'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Upcoming Payment'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $planInvestment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('SL'); ?>"><?php echo e($planInvestment->firstItem()+$key); ?></td>
                                <td data-label="<?php echo app('translator')->get('Plan'); ?>"><?php echo $value->getUserPlanInv(); ?></td>
                                <td data-label="<?php echo app('translator')->get('Profit'); ?>"><?php echo e(currencyPosition($value->profit)); ?> </td>
                                <td data-label="<?php echo app('translator')->get('Return Period'); ?>"><?php echo $value->returnPeriod(); ?></td>
                                <td data-label="<?php echo app('translator')->get('Received Amount'); ?>"><?php echo $value->receivedAmount(); ?></td>
                                <td data-label="<?php echo app('translator')->get('Upcoming Payment'); ?>"><?php echo $value->userNextPayment(); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php if(count($planInvestment??[]) == 0): ?>
                    <div class="row d-flex text-center justify-content-center">
                        <div class="col-4">
                            <img src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" id="no-data-image" class="no-data-image" alt="" srcset="">
                            <p><?php echo app('translator')->get('No data to show'); ?></p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="pagination-section">
        <nav aria-label="...">
            <?php echo e($planInvestment->appends($_GET)->links($theme.'partials.user-pagination')); ?>

        </nav>
    </div>


    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasSearch" aria-labelledby="offcanvasExampleLabel" aria-modal="true" role="dialog">
        <div class="offcanvas-header d-flex justify-content-between">
            <h5 class="offcanvas-title" id="offcanvasExampleLabel me-2"><?php echo app('translator')->get('Plan Investment Filter'); ?></h5>
            <button type="button" class="cmn-btn-close" data-bs-dismiss="offcanvas" aria-label="Close">
                <i class="fa-light fa-arrow-right"></i>
            </button>
        </div>
        <div class="offcanvas-body">
            <form action="<?php echo e(route('user.plan.investment')); ?>" method="GET">
                <div class="row g-4">
                    <div>
                        <label for="Title" class="form-label"><?php echo app('translator')->get('Plan Name'); ?></label>
                        <input placeholder="Plan Name" name="name"  type="text" class="form-control form-control-sm">
                    </div>
                    <div>
                        <label for="CreatedAt" class="form-label"> <?php echo app('translator')->get('Date Range'); ?> </label>
                        <input type="text" name="date_range" class="form-control date flatpickr-input active"  readonly="readonly" placeholder="<?php echo app('translator')->get('Select Dates'); ?>">
                    </div>

                    <div class="btn-area">
                        <button type="submit" class="btn-1"> <i class="fa-light fa-search"></i><?php echo app('translator')->get('Apply'); ?> <span></span> </button>
                    </div>
                </div>

            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function (){
            function updateTime() {
                $('.next-payment').each(function() {
                    const nextPaymentTime = new Date($(this).data('payment'));

                    if (nextPaymentTime){
                        const now = new Date();
                        let timeDifference = nextPaymentTime - now;

                        if (timeDifference > 0) {
                            const days = Math.floor(timeDifference / (1000 * 60 * 60 * 24));
                            timeDifference -= days * 1000 * 60 * 60 * 24;
                            const hours = Math.floor(timeDifference / (1000 * 60 * 60));
                            timeDifference -= hours * 1000 * 60 * 60;
                            const minutes = Math.floor(timeDifference / (1000 * 60));
                            timeDifference -= minutes * 1000 * 60;
                            const seconds = Math.floor(timeDifference / 1000);

                            $(this).text(`${days}d ${hours}h ${minutes}m ${seconds}s`);
                        } else {
                            $(this).html(`<span class="text-danger"><?php echo e(trans('Time has passed')); ?></span>`)
                        }
                    }
                });
            }

            // Initial call to set up the time
            updateTime();
            // Update every second
            setInterval(updateTime, 1000);

        })
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        flatpickr(".date",{
            mode: "range",
        });
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/user/investment/plan_investment.blade.php ENDPATH**/ ?>