
<?php $__env->startSection('page_title',__('Rank List')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Rank List'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Rank List'); ?></h1>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header card-header-content-md-end">

                <div class="d-grid d-sm-flex justify-content-md-end align-items-sm-center gap-2">
                    <a href="<?php echo e(route('admin.rankCreate')); ?>"  class="btn btn-primary"><i class="fa-duotone fa-solid fa-plus me-1"></i><?php echo app('translator')->get('Add New'); ?></a>
                </div>
            </div>

            <div class=" table-responsive datatable-custom  ">
                <table id="datatable"
                       class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                       data-hs-datatables-options='{
                       "columnDefs": [{
                          "targets": [0, 8],
                          "orderable": false
                        }],
                       "order": [],
                       "info": {
                         "totalQty": "#datatableWithPaginationInfoTotalQty"
                       },
                       "search": "#datatableSearch",
                       "entries": "#datatableEntries",
                       "pageLength": 15,
                       "isResponsive": false,
                       "isShowPaging": false,
                       "pagination": "datatablePagination"
                     }'>
                    <thead class="thead-light">
                    <tr>

                        <th scope="col"><?php echo app('translator')->get('Rank Name'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Rank Level'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Rank Icon'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Min Invest'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Min Deposit'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Min Earning'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Details'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('status'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $rankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr data-id="<?php echo e($item->id); ?>">
                            <td data-label="<?php echo app('translator')->get('Rank Name'); ?>">
                                <?php echo app('translator')->get($item->rank_name); ?>
                            </td>
                            <td data-label="<?php echo app('translator')->get('Rank Level'); ?>">
                                <p class="font-weight-bold"><?php echo e($item->rank_lavel); ?></p>
                            </td>

                            <td data-label="<?php echo app('translator')->get('Rank icon'); ?>">
                                <img src="<?php echo e(getFile($item->driver,$item->rank_icon)); ?>"
                                     alt="<?php echo app('translator')->get('not found'); ?>" width="60">
                            </td>

                            <td data-label="<?php echo app('translator')->get('Minimum Earning'); ?>">
                                <p class="font-weight-bold"><?php echo e($item->min_invest); ?> <?php echo e(config('basic.currency')); ?></p>
                            </td>

                            <td data-label="<?php echo app('translator')->get('Minimum Earning'); ?>">
                                <p class="font-weight-bold"><?php echo e($item->min_deposit); ?> <?php echo e(config('basic.currency')); ?></p>
                            </td>

                            <td data-label="<?php echo app('translator')->get('Minimum Earning'); ?>">
                                <p class="font-weight-bold"><?php echo e($item->min_earning); ?> <?php echo e(config('basic.currency')); ?></p>
                            </td>

                            <td data-label="<?php echo app('translator')->get('Bonus'); ?>">
                                <p class="font-weight-bold"><?php echo app('translator')->get($item->description); ?></p>
                            </td>

                            <td data-label="<?php echo app('translator')->get('Status'); ?>">

                                <?php
                                    $bg =   $item->status == 1 ? 'success' : 'danger';
                                ?>

                                <span class="badge bg-soft-<?php echo e($bg); ?> text-<?php echo e($bg); ?>">
                                        <span class="legend-indicator bg-<?php echo e($bg); ?>"></span>
                                              <?php if($item->status == 1): ?>
                                        <?php echo app('translator')->get('Active'); ?>
                                    <?php else: ?>
                                        <?php echo app('translator')->get('Deactive'); ?>
                                    <?php endif; ?>
                                      </span>

                            </td>

                            <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                <div class="btn-group" role="group">
                                    <a class="btn btn-white btn-sm" href="<?php echo e(route('admin.rankEdit',$item->id)); ?>">
                                        <i class="bi-pencil-fill me-1"></i> <?php echo app('translator')->get('Edit'); ?>
                                    </a>

                                    <!-- Button Group -->
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-white btn-icon btn-sm dropdown-toggle dropdown-toggle-empty" id="productsEditDropdown1" data-bs-toggle="dropdown" aria-expanded="false"></button>

                                        <div class="dropdown-menu dropdown-menu-end mt-1" aria-labelledby="productsEditDropdown1" style="">
                                            <a class="dropdown-item deleteBtn" href="javascript:void(0)"
                                               data-route="<?php echo e(route('admin.rankDelete',$item->id)); ?>"
                                               data-bs-toggle="modal"
                                               data-bs-target="#deleteModal"
                                            >
                                                <i class="bi-trash dropdown-item-icon"></i> <?php echo app('translator')->get('Delete'); ?>
                                            </a>
                                        </div>
                                    </div>
                                    <!-- End Button Group -->
                                </div>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="100%" class="text-center">
                                <div class="text-center p-4">
                                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                                    <p class="mb-0"><?php echo app('translator')->get('No data to show'); ?></p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="card-footer">
                <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                    <div class="col-sm mb-2 mb-sm-0">
                        <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                            <span class="me-2"><?php echo app('translator')->get('Showing:'); ?></span>
                            <!-- Select -->
                            <div class="tom-select-custom">
                                <select id="datatableEntries"
                                        class="js-select form-select form-select-borderless w-auto" autocomplete="off"
                                        data-hs-tom-select-options='{
                                            "searchInDropdown": false,
                                            "hideSearch": true
                                          }'>
                                    <option value="10">10</option>
                                    <option value="20" selected>20</option>
                                    <option value="30">30</option>
                                    <option value="40">40</option>
                                </select>
                            </div>
                            <span class="text-secondary me-2"><?php echo app('translator')->get('of'); ?></span>
                            <span id="datatableWithPaginationInfoTotalQty"></span>
                        </div>
                    </div>


                    <div class="col-sm-auto">
                        <div class="d-flex  justify-content-center justify-content-sm-end">
                            <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
         data-bs-backdrop="static"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteModalLabel"><i
                            class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="" method="post" id="setRoute">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <div class="modal-body">
                        <p><?php echo app('translator')->get("Do you want to delete this Item"); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Delete Modal -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>

        $(document).on('click','.deleteBtn',function (){
            $('#setRoute').attr('action',$(this).data('route'))
        })


    </script>
<?php $__env->stopPush(); ?>





<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/ranking/index.blade.php ENDPATH**/ ?>