
<?php $__env->startSection('page_title',__('Investment Plan')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid bg-light">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item"><a class="breadcrumb-link"
                           href="javascript:void(0);"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                           <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Investment Plan List'); ?></li>
                       </ol>
                   </nav>
                   <h1 class="page-header-title"><?php echo app('translator')->get('Investment Plan List'); ?></h1>
               </div>
           </div>
       </div>
<!-- Subscription Purchase Limit Update Section -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title mb-0"><?php echo app('translator')->get('Subscription Purchase Limit'); ?></h5>
    </div>
    <div class="card-body">
        <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('admin.investment.plan.inventory.update')); ?>">
            <?php echo csrf_field(); ?>
            <div class="row align-items-center">
                <div class="col-md-4">
                    <label for="quantity" class="form-label"><?php echo app('translator')->get('Unit Quantity'); ?></label>
                    <input type="number" name="quantity" id="quantity" class="form-control <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                    value="<?php echo e(old('quantity', $inventory ?? 0)); ?>" min="0" required>
                    <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-2 mt-3 mt-md-4">
                    <button type="submit" class="btn btn-primary w-100"><?php echo app('translator')->get('Update'); ?></button>
                </div>
            </div>
        </form>
        <div class="mb-3">
            <div class="d-flex align-items-center gap-3">
                <div>
                    <span class="badge bg-primary p-2">
                        <i class="bi-box-seam me-1"></i> Available: <strong><?php echo e($available); ?></strong>
                    </span>
                </div>

                <div>
                    <span class="badge bg-warning text-dark p-2">
                        <i class="bi-cart-check me-1"></i> Purchased: <strong><?php echo e($planPurchased); ?></strong>
                    </span>
                </div>

                <div>
                    <?php if($soldOut): ?>
                    <span class="badge bg-danger p-2">
                        <i class="bi-x-circle me-1"></i> Sold Out
                    </span>
                    <?php else: ?>
                    <span class="badge bg-success p-2">
                        <i class="bi-check-circle me-1"></i> In Stock
                    </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="card">
    <div class="card-header card-header-content-md-between">
        <div class="mb-2 mb-md-0">

            <div class="input-group input-group-merge navbar-input-group">
                <div class="input-group-prepend input-group-text">
                    <i class="bi-search"></i>
                </div>
                <input type="search" id="datatableSearch"
                class="search form-control form-control-sm"
                placeholder="<?php echo app('translator')->get('Search plan'); ?>"
                aria-label="<?php echo app('translator')->get('Search plan'); ?>"
                autocomplete="off">
                <a class="input-group-append input-group-text display-none" href="javascript:void(0)">
                    <i id="clearSearchResultsIcon" class="bi-x"></i>
                </a>
            </div>

        </div>

        <div class="d-grid d-sm-flex justify-content-md-end align-items-sm-center gap-2">
           <a href="<?php echo e(route('admin.investment.plan.create')); ?>" class="btn btn-primary"><i class="fa-duotone fa-solid fa-plus me-1"></i><?php echo app('translator')->get('New Plan'); ?></a>
       </div>
   </div>

   <div class=" table-responsive datatable-custom  ">
    <table id="datatable"
    class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
    data-hs-datatables-options='{
       "columnDefs": [{
          "targets": [0, 8],
          "orderable": false
      }],
      "order": [],
      "info": {
         "totalQty": "#datatableWithPaginationInfoTotalQty"
     },
     "search": "#datatableSearch",
     "entries": "#datatableEntries",
     "pageLength": 15,
     "isResponsive": false,
     "isShowPaging": false,
     "pagination": "datatablePagination"
 }'>
 <thead class="thead-light">
    <tr>
        <th><?php echo app('translator')->get('SL.'); ?></th>
        <th><?php echo app('translator')->get('Name'); ?></th>
        <th><?php echo app('translator')->get('Plan Range'); ?></th>
        <th><?php echo app('translator')->get('Plan Period'); ?></th>
        <th><?php echo app('translator')->get('Status'); ?></th>
        <th><?php echo app('translator')->get('Return Period'); ?></th>
        <th><?php echo app('translator')->get('Profit'); ?></th>
        <th><?php echo app('translator')->get('Capital Back'); ?></th>
        <th><?php echo app('translator')->get('Action'); ?></th>
    </tr>
</thead>

<tbody>

</tbody>
</table>
</div>

<div class="card-footer">
    <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
        <div class="col-sm mb-2 mb-sm-0">
            <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                <span class="me-2"><?php echo app('translator')->get('Showing:'); ?></span>
                <!-- Select -->
                <div class="tom-select-custom">
                    <select id="datatableEntries"
                    class="js-select form-select form-select-borderless w-auto" autocomplete="off"
                    data-hs-tom-select-options='{
                        "searchInDropdown": false,
                        "hideSearch": true
                    }'>
                    <option value="10">10</option>
                    <option value="20" selected>20</option>
                    <option value="30">30</option>
                    <option value="40">40</option>
                </select>
            </div>
            <span class="text-secondary me-2"><?php echo app('translator')->get('of'); ?></span>
            <span id="datatableWithPaginationInfoTotalQty"></span>
        </div>
    </div>


    <div class="col-sm-auto">
        <div class="d-flex  justify-content-center justify-content-sm-end">
            <nav id="datatablePagination" aria-label="Activity pagination"></nav>
        </div>
    </div>
</div>
</div>

</div>
</div>


<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
data-bs-backdrop="static"
aria-hidden="true">
<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="deleteModalLabel"><i
                class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="" method="post" id="setRoute">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <div class="modal-body">
                    <p><?php echo app('translator')->get("Do you want to delete this Item"); ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- End Delete Modal -->

<?php $__env->stopSection(); ?>


<?php $__env->startPush('css-lib'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/flatpickr.min.css')); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js-lib'); ?>
<script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/flatpickr.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
<script>

    $(document).on('click','.deleteBtn',function (){
        $('#setRoute').attr('action',$(this).data('route'))
    })
    $(document).on('ready', function () {

        HSCore.components.HSFlatpickr.init('.js-flatpickr')
        HSCore.components.HSTomSelect.init('.js-select', {
            maxOptions: 250,
        })
        HSCore.components.HSDatatables.init($('#datatable'), {
            processing: true,
            serverSide: true,
            ordering: false,
            ajax: {
                url: "<?php echo e(route("admin.investment.plan.list")); ?>",
            },

            columns: [
                {data: 'sl', name: 'sl'},
                {data: 'name', name: 'name'},
                {data: 'price', name: 'price'},
                {data: 'period', name: 'period'},
                {data: 'status', name: 'status'},
                {data: 'return_period', name: 'return_period'},
                {data: 'profit', name: 'profit'},
                {data: 'capital_back', name: 'capital_back'},
                {data: 'action', name: 'action'},
            ],

            language: {
                zeroRecords: `<div class="text-center p-4">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                    <p class="mb-0">No data to show</p>
                </div>`,
                processing: `<div><div></div><div></div><div></div><div></div></div>`
            },
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });

</script>
<?php $__env->stopPush(); ?>





<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/investment_plan/index.blade.php ENDPATH**/ ?>