<div id="passwordSection" class="card">
    <div class="card-header">
        <h2 class="card-title h4"><?php echo app('translator')->get('Change your password'); ?></h2>
    </div>
    <div class="card-body">
        <form action="<?php echo e(route('admin.user.password.update', $user->id)); ?>" id="changePasswordForm" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row mb-4">
                <label for="newPassword" class="col-sm-3 col-form-label form-label">
                    <?php echo app('translator')->get('New password'); ?>
                </label>
                <div class="col-sm-9">
                    <div class="input-group input-group-merge">
                        <input type="password" class="js-toggle-password form-control" id="multiToggleCurrentPasswordLabel" name="newPassword" placeholder="<?php echo app('translator')->get("Enter new password"); ?>"
                               data-hs-toggle-password-options='{
                             "target": [".js-change-password-multi-1"],
                             "defaultClass": "bi-eye-slash",
                             "showClass": "bi-eye",
                             "classChangeTarget": "#showMultiPassIcon1"
                           }'>
                        <a class="js-change-password-multi-1 input-group-append input-group-text" href="javascript:void(0)">
                            <i id="showMultiPassIcon1"></i>
                        </a>
                        <?php $__errorArgs = ['newPassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="row mb-4">
                <label for="confirmNewPasswordLabel" class="col-sm-3 col-form-label form-label">
                    <?php echo app('translator')->get('Confirm new password'); ?>
                </label>
                <div class="col-sm-9">
                    <div class="mb-3">
                        <div class="input-group input-group-merge">
                            <input type="password" class="js-toggle-password form-control"  name="confirmNewPassword" id="multiToggleNewPasswordLabel" placeholder="<?php echo app('translator')->get("Confirm your new password"); ?>"
                                   data-hs-toggle-password-options='{
                                 "target": [".js-change-password-multi-2"],
                                 "defaultClass": "bi-eye-slash",
                                 "showClass": "bi-eye",
                                 "classChangeTarget": "#showMultiPassIcon2"
                               }'>
                            <a class="js-change-password-multi-2 input-group-append input-group-text" href="javascript:void(0)">
                                <i id="showMultiPassIcon2"></i>
                            </a>
                            <?php $__errorArgs = ['confirmNewPassword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <?php if($basicControl->strong_password): ?>
                        <h5><?php echo app('translator')->get('Password requirements:'); ?></h5>
                        <p class="fs-6 mb-2"><?php echo app('translator')->get('Ensure that these requirements are met:'); ?></p>
                        <ul class="fs-6">
                            <li><?php echo app('translator')->get('Minimum 8 characters long - the more, the better'); ?></li>
                            <li><?php echo app('translator')->get('At least one lowercase character'); ?></li>
                            <li><?php echo app('translator')->get('At least one uppercase character'); ?></li>
                            <li><?php echo app('translator')->get('At least one number, symbol, or whitespace character'); ?></li>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
            <div class="d-flex justify-content-start">
                <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save Changes'); ?></button>
            </div>
        </form>
    </div>
</div>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset("assets/admin/js/hs-toggle-password.js")); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function() {
            new HSTogglePassword('.js-toggle-password')
        })();
    </script>
<?php $__env->stopPush(); ?>

<?php /**PATH /home/petarig/public_html/project/resources/views/admin/user_management/components/password_section.blade.php ENDPATH**/ ?>