<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="utf-8">

    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">



    <meta content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>" name="description">

    <meta content="<?php echo e(is_array(@$pageSeo['meta_keywords']) ? implode(', ', @$pageSeo['meta_keywords']) : @$pageSeo['meta_keywords']); ?>"

    name="keywords">

    <meta name="theme-color" content="<?php echo e(basicControl()->primary_color); ?>">

    <meta name="author" content="<?php echo e(basicControl()->site_title); ?>">

    <meta name="robots" content="<?php echo e(isset($pageSeo['meta_robots']) ? $pageSeo['meta_robots'] : ''); ?>">



    <meta property="og:type" content="website">

    <meta property="og:site_name" content="<?php echo e(isset(basicControl()->site_title) ? basicControl()->site_title : ''); ?>">

    <meta property="og:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">

    <meta property="og:description" content="<?php echo e(isset($pageSeo['og_description']) ? $pageSeo['og_description'] : ''); ?>">

<meta property="og:image" content="https://via.placeholder.com/500.png">

    <meta property="og:image:width" content="300">

    <meta property="og:image:height" content="300">



    <meta name="twitter:card" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">

    <meta name="twitter:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">

    <meta name="twitter:description" content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>">

    <meta name="twitter:image" content="<?php echo e(getFile(@$pageSeo['meta_image_driver'], @$pageSeo['meta_image'])); ?>">

    <!-- Favicons -->

    <link href="<?php echo e(getFile(basicControl()->favicon_driver, basicControl()->favicon)); ?>" rel="icon">

    <title> <?php echo e(basicControl()->site_title); ?>


        <?php if(isset($pageSeo['page_title'])): ?>

        | <?php echo e(str_replace(basicControl()->site_title, ' ',$pageSeo['page_title'])); ?>


        <?php else: ?>

        | <?php echo $__env->yieldContent('title'); ?>

        <?php endif; ?>

    </title>



    <!-- Stylesheets -->

    <link href="<?php echo e(asset(template(true).'css/style.css')); ?>?v=<?php echo e(time()); ?>" rel="stylesheet">

    <link href="<?php echo e(asset(template(true).'css/01-global.css')); ?>?v=<?php echo e(time()); ?>" rel="stylesheet">

    <link href="<?php echo e(asset(template(true).'css/module-css/19-signin-signup.css')); ?>?v=<?php echo e(time()); ?>" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/bootstrap.min.css')); ?>"/>

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/user-style.css')); ?>?v=<?php echo e(time()); ?>"/>

    <?php echo $__env->yieldPushContent('css-lib'); ?>

    <style>

        body {

            height: 100vh;

            background: #071720;

        }



        .loader-wrap {

            display: flex;

            justify-content: center;

            align-items: center;

            height: 100vh;

            background-color: #fff;

        }



        .preloader {

            display: flex;

            justify-content: center;

            align-items: center;

        }



        .loader {

            width: 3px;

            height: 40px;

            background: #000;

            animation: loading 1s infinite ease-in-out;

        }



        .form-check-input {

            margin-top: 0.5em;

        }



        @keyframes loading {



            0%,

            100% {

                transform: scaleY(1);

            }



            50% {

                transform: scaleY(2);

            }

        }

    </style>

</head>



<body>

    <div class="page-wrapper overflow-y-auto">

        <!-- preloader -->

        <div class="loader-wrap">

            <div class="preloader">

                <div id="handle-preloader" class="handle-preloader">

                    <div class="animation-preloader">

                        <div class="loader"></div>

                    </div>

                </div>

            </div>

        </div>

        <!-- preloader end -->



        <?php echo $__env->yieldContent('content'); ?>

        

    </div>







    <!--Scroll to top-->

    <!-- <div class="scroll-to-top">

        <div>

            <div class="scroll-top-inner">

                <div class="scroll-bar">

                    <div class="bar-inner"></div>

                </div>

                <div class="scroll-bar-text"><?php echo app('translator')->get('Go To Top'); ?></div>

            </div>

        </div>

    </div> -->

    <!-- Scroll to top end -->



    <script src="<?php echo e(asset('assets/global/js/jquery.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/bootstrap.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/select2.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/jquery.nice-select.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/appear.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/wow.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/owl.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/TweenMax.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/odometer.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/swiper.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/parallax-scroll.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/jarallax.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/jquery.paroller.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/jquery.magnific-popup.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/isotope.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/flatpickr-min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/socialSharing.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/script.js')); ?>?v=<?php echo e(time()); ?>"></script>

    <script src="<?php echo e(asset('assets/global/js/notiflix-aio-3.2.6.min.js')); ?>"></script>

    <?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>









    <script>

        "use strict";

        var root = document.querySelector(':root');

        root.style.setProperty('--primary', '<?php echo e(basicControl()->primary_color); ?>');

        root.style.setProperty('--secondary', '<?php echo e(basicControl()->secondary_color); ?>');

    </script>





    <?php echo $__env->yieldPushContent('js-lib'); ?>



    <?php echo $__env->yieldPushContent('script'); ?>



    <?php if(session()->has('success')): ?>

    <script>

        Notiflix.Notify.success("<?php echo app('translator')->get(session('success')); ?>");

    </script>

    <?php endif; ?>



    <?php if(session()->has('error')): ?>

    <script>

        Notiflix.Notify.failure("<?php echo app('translator')->get(session('error')); ?>");

    </script>

    <?php endif; ?>



    <?php if(session()->has('warning')): ?>

    <script>

        Notiflix.Notify.warning("<?php echo app('translator')->get(session('warning')); ?>");

    </script>

    <?php endif; ?>



</body>



</html><?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/layouts/login.blade.php ENDPATH**/ ?>