
<?php $__env->startSection('page_title', __('Summary')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title"><?php echo app('translator')->get("Summary"); ?></h1>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header card-header-content-md-between">
                    <div class="mb-2 mb-md-0">
                        <div class="input-group input-group-merge navbar-input-group">
                            <div class="input-group-prepend input-group-text">
                                <i class="bi-search"></i>
                            </div>
                            <input type="search" id="datatableSearch"
                            class="search form-control form-control-sm"
                            placeholder="<?php echo app('translator')->get('Search Records'); ?>"
                            aria-label="<?php echo app('translator')->get('Search Records'); ?>"
                            autocomplete="off">
                        </div>
                    </div>
                </div>
            </div>

            <div class="table-responsive datatable-custom" style="overflow-x: auto;">
                <table id="datatable"
                    class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                    data-hs-datatables-options='{
                        "columnDefs": [{
                            "targets": [9],
                            "orderable": false
                        }],
                        "order": [],
                        "info": {
                            "totalQty": "#datatableWithPaginationInfoTotalQty"
                        },
                        "search": "#datatableSearch",
                        "entries": "#datatableEntries",
                        "pageLength": 10,
                        "isResponsive": false,
                        "isShowPaging": false,
                        "pagination": "datatablePagination"
                    }'>
                    <thead class="thead-light">
                        <tr>
                            <th><?php echo app('translator')->get('Customer ID'); ?></th>
                            <th><?php echo app('translator')->get('Customer Name'); ?></th>
                            <th><?php echo app('translator')->get('Total Machines'); ?></th>
                            <th><?php echo app('translator')->get('Days Invested'); ?></th>
                            <th><?php echo app('translator')->get('Hashrate'); ?></th>
                            <th><?php echo app('translator')->get('Mining Reward'); ?></th>
                            <th><?php echo app('translator')->get('Commission Reward'); ?></th>
                            <th><?php echo app('translator')->get('Total Reward'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>

            <div class="card-footer">
                <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                    <div class="col-sm mb-2 mb-sm-0">
                        <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                            <span class="me-2"><?php echo app('translator')->get('Showing:'); ?></span>
                            <div class="tom-select-custom">
                                <select id="datatableEntries"
                                    class="js-select form-select form-select-borderless w-auto"
                                    autocomplete="off"
                                    data-hs-tom-select-options='{
                                        "searchInDropdown": false,
                                        "hideSearch": true
                                    }'>
                                    <option value="5">5</option>
                                    <option value="10" selected>10</option>
                                    <option value="15">15</option>
                                    <option value="20">20</option>
                                </select>
                            </div>
                            <span class="text-secondary me-2"><?php echo app('translator')->get('of'); ?></span>
                            <span id="datatableWithPaginationInfoTotalQty"></span>
                        </div>
                    </div>

                    <div class="col-sm-auto">
                        <div class="d-flex justify-content-center justify-content-sm-end">
                            <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
</div>
<?php echo $__env->make('admin.user_management.components.multiple_user_approve_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
<script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/select.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/appear.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/hs-counter.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).on('ready', function () {
        var parentId = "<?php echo e(request()->route('id')); ?>";

        HSCore.components.HSDatatables.init($('#datatable'), {
            processing: true,
            serverSide: true,
            ordering: false,
            ajax: {
                url: "<?php echo e(route('admin.monthly.plan.listsummary')); ?>",
                data: function (d) {
                    d.id = parentId;
                }
            },
            columns: [
                {data: 'user_id', name: 'user_id'},
                {data: 'name', name: 'name'},
                {data: 'total_machines', name: 'total_machines'},
                {data: 'days_invested', name: 'days_invested'},
                {data: 'hashrate', name: 'hashrate'},
                {data: 'mining_reward', name: 'mining_reward'},
                {data: 'commission_reward', name: 'commission_reward'},
                {data: 'total_reward', name: 'total_reward'},
                {data: 'status', name: 'status', orderable: false, searchable: false },
                {data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            language: {
                zeroRecords: `<div class="text-center p-4">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                    <p class="mb-0">No data found for the given criteria.</p>
                </div>`,
                processing: `<div><div></div><div></div><div></div><div></div></div>`
            },
        });
    });

    $.fn.dataTable.ext.errMode = 'throw';

    $(document).on('click', '.loginAccount', function () {
        let route = $(this).data('route');
        $('.loginAccountAction').attr('action', route)
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/monthly_report/summary.blade.php ENDPATH**/ ?>