
<?php $__env->startSection('page_title', __('Admin Login')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card card-lg mt-lg-5">
        <div class="card-body">
            <?php if(Session::has('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <span class="fw-semibold"><?php echo e(Session::get('error')); ?></span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <form method="post" action="<?php echo e(route('admin.login.submit')); ?>" class="js-validate needs-validation"
                  novalidate>
                <?php echo csrf_field(); ?>
                <div class="text-center">
                    <div class="mb-5">
                        <h1 class="display-5"><?php echo app('translator')->get('Sign in'); ?></h1>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label" for="signinSrEmail"><?php echo app('translator')->get('Email or Username'); ?></label>
                    <input type="text"
                           class="form-control form-control-lg <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           name="username"
                           value="<?php echo e(old('username', config('demo.IS_DEMO') ? (request()->username ?? 'admin') : '')); ?>"
                           id="signinSrEmail" autocomplete="off"
                           tabindex="0" placeholder="Enter Email or Username" required>
                    <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <!-- End Form -->

                <!-- Form -->
                <div class="mb-2">
                    <label class="form-label w-100" for="signupSrPassword">
                        <span><?php echo app('translator')->get("Password"); ?></span>
                    </label>
                    <div class="input-group input-group-merge" data-hs-validation-validate-class>
                        <input type="password"
                               tabindex="1"
                               class="js-toggle-password form-control form-control-lg <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               name="password" value="<?php echo e(old('password', config('demo.IS_DEMO') ? (request()->username ?? 'admin') : '')); ?>"
                               id="signupSrPassword"
                               placeholder="Enter Password"
                               data-hs-toggle-password-options='
                               {
                                "target": "#changePassTarget",
                                "defaultClass": "bi-eye-slash",
                                "showClass": "bi-eye",
                                "classChangeTarget": "#changePassIcon"
                                }'>
                        <a id="changePassTarget" class="input-group-append input-group-text"
                           href="javascript:void(0);">
                            <i id="changePassIcon" class="bi-eye"></i>
                        </a>
                    </div>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <span class="d-flex justify-content-end align-items-center">
                    <a class="form-label-link mb-0" href="<?php echo e(route('admin.password.request')); ?>">
                        <?php echo app('translator')->get("Forgot Password?"); ?></a>
                    </span>
                </div>

                <?php if($basicControl->google_recaptcha === 1 && $basicControl->google_reCapture_admin_login === 1): ?>
                    <div class="form-group mb-2">
                        <?php echo NoCaptcha::renderJs(); ?>

                        <?php echo NoCaptcha::display(); ?>

                        <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger"><?php echo app('translator')->get($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                <?php endif; ?>

                    <div class="mb-4">
                        <label class="form-label" for="captcha"><?php echo app('translator')->get('Captcha Code'); ?></label>
                        <input type="text" tabindex="2"
                               class="form-control form-control-lg <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               name="captcha" id="captcha" autocomplete="off"
                               placeholder="Enter Captcha" required>
                        <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-4">
                        <div class="input-group input-group-merge" data-hs-validation-validate-class>
                            <img src="<?php echo e(route('captcha').'?rand='. rand()); ?>" id='captcha_image'>
                            <a class="input-group-append input-group-text"
                               href='javascript: refreshCaptcha();'>
                                <i class="bi-arrow-repeat fs-1 text-primary"></i>
                            </a>
                        </div>
                    </div>

                <div class="form-check mb-4">
                    <input class="form-check-input" type="checkbox" name="remember_me" value=""
                           id="termsCheckbox" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="termsCheckbox">
                        <?php echo app('translator')->get('Remember me'); ?>
                    </label>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary btn-lg"><?php echo app('translator')->get('Sign in'); ?></button>
                </div>
            </form>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';

        function refreshCaptcha() {
            let img = document.images['captcha_image'];
            img.src = img.src.substring(
                0, img.src.lastIndexOf("?")
            ) + "?rand=" + Math.random() * 1000;
        }
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/auth/login.blade.php ENDPATH**/ ?>