
<?php $__env->startSection('page_title', __('Payment Gateway')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="javascript:void(0);"><?php echo app('translator')->get("Dashboard"); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get("Payment Settings"); ?></li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get("Payment Gateway"); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get("Payment Gateway"); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-header-title"><?php echo app('translator')->get('Payment Methods'); ?></h4>
                        </div>

                        <!-- Table -->
                        <div class="table-responsive datatable-custom">
                            <table
                                class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                                data-hs-datatables-options='{
                                   "order": [],
                                   "info": {
                                     "totalQty": "#datatableEntriesInfoTotalQty"
                                   },
                                   "ordering":false,
                                   "pageLength": 40,
                                   "entries": "#datatableEntries",
                                   "isResponsive": false,
                                   "isShowPaging": false,
                                   "pagination": "datatableWithPaginationPagination"
                                 }'>
                                <thead class="thead-light">
                                <tr>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Gateway Currencies'); ?></th>
                                    <th><?php echo app('translator')->get('Supported Currency'); ?></th>
                                    <th><?php echo app('translator')->get('Description'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                                </thead>
                                <tbody class="js-sortable "
                                       data-hs-sortable-options='{
                                          "animation": 150,
                                          "handle": ".sortablejs-custom-handle"
                                        }'
                                >
                                <?php $__empty_1 = true; $__currentLoopData = $paymentGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr data-code="<?php echo e($method->code); ?>">
                                        <td>
                                            <a class="d-flex align-items-center" href="<?php echo e(route("admin.edit.payment.methods", $method->id)); ?>">
                                                <i class="sortablejs-custom-handle bi-grip-horizontal list-group-icon"></i>
                                                <div class="flex-shrink-0">
                                                    <div class="avatar avatar-circle">
                                                        <img class="avatar-img"
                                                             src="<?php echo e(getFile($method->driver, $method->image)); ?>"
                                                             alt="Image Description">
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <span class="h5 text-inherit">
                                                        <?php echo app('translator')->get($method->name); ?>
                                                    </span>
                                                </div>
                                            </a>
                                        </td>
                                        <td>
                                            <span
                                                class="badge bg-soft-dark text-dark"><?php echo e($method->countGatewayCurrency()); ?></span>
                                        </td>
                                        <td>
                                            <span
                                                class="badge bg-soft-dark text-dark"><?php echo app('translator')->get(count($method->supported_currency ?? 0)); ?></span>
                                        </td>
                                        <td>
                                            <?php echo e(Str::limit($method->description, 32)); ?>

                                        </td>
                                        <td>
                                            <?php if($method->status == 1): ?>
                                                <span class="badge bg-soft-success text-success">
                                                    <span class="legend-indicator bg-success"></span><?php echo app('translator')->get('Active'); ?>
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-soft-danger text-danger">
                                                    <span class="legend-indicator bg-danger"></span><?php echo app('translator')->get('Inactive'); ?>
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a class="btn btn-white btn-sm"
                                                   href="<?php echo e(route('admin.edit.payment.methods', $method->id)); ?>">
                                                    <i class="bi-pencil-fill me-1"></i> <?php echo app('translator')->get('Edit'); ?>
                                                </a>
                                                <div class="btn-group">
                                                    <button type="button"
                                                            class="btn btn-white btn-icon btn-sm dropdown-toggle dropdown-toggle-empty"
                                                            id="productsEditDropdown" data-bs-toggle="dropdown"
                                                            aria-expanded="false"></button>
                                                    <div class="dropdown-menu dropdown-menu-end mt-1"
                                                         aria-labelledby="productsEditDropdown"
                                                         data-popper-placement="bottom-end">
                                                        <a class="dropdown-item disableBtn" href="javascript:void(0)"
                                                           data-code="<?php echo e($method->code); ?>"
                                                           data-status="<?php echo e($method->status); ?>"
                                                           data-message="<?php echo e(($method->status == 0)?'enable':'disable'); ?>"
                                                           data-bs-toggle="modal" data-bs-target="#statusModal">
                                                            <i class="fa-light fa-<?php echo e(($method->status == 0)?'check':'ban'); ?> dropdown-item-icon"></i> <?php echo e(($method->status == 0)?'Mark As Enable':'Mark As Disable'); ?>

                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <div class="text-center p-4">
                                            <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                                            <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                                            <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                                        </div>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="accountAddCardModalLabel" data-bs-backdrop="static"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="statusModalLabel"><i
                            class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('admin.payment.methods.deactivate')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="code">
                        <p><?php echo app('translator')->get("Do you want to"); ?> <span class="messageShow"></span> <?php echo app('translator')->get('this payment gateway?'); ?></p>
                        <div class="d-flex justify-content-end gap-3 pt-2">
                            <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get("Close"); ?></button>
                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("Confirm"); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/sortable.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).ready(function () {
            HSCore.components.HSSortable.init('.js-sortable')
            HSCore.components.HSDatatables.init($('.js-datatable'), {
                language: {
                    zeroRecords: `<div class="text-center p-4">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                    <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                    <p class="mb-0">No data to show</p>
                    </div>`,
                    processing: `<div><div></div><div></div><div></div><div></div></div>`
                },

            })

            $('.js-sortable').on('change', function () {
                let methods = [];
                $('.js-sortable tr').each(function (key, val) {
                    let methodCode = $(val).data('code');
                    methods.push(methodCode);
                });
                $.ajax({
                    'url': "<?php echo e(route('admin.sort.payment.methods')); ?>",
                    'method': "POST",
                    'data': {sort: methods}
                })
            })

            $(document).on('click', '.disableBtn', function () {
                let status = $(this).data('status');
                $('.messageShow').text($(this).data('message'));
                let modal = $('#statusModal');
                modal.find('input[name=code]').val($(this).data('code'));
            })

            HSCore.components.HSTomSelect.init('.js-select', {
                maxOptions: 250,
            })

        });


    </script>
<?php $__env->stopPush(); ?>





<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/payment_methods/list.blade.php ENDPATH**/ ?>