
<?php $__env->startSection('page_title', __('Commission Report')); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">

    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title"><?php echo app('translator')->get('Transfer'); ?></h1>
            </div>
            <div class="col-sm-auto">
                <a href="<?php echo e(route('admin.monthly.plan.index')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Back to List'); ?></a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card mt-4 shadow-sm border-0">
                <div class="card-header bg-gradient-primary text-white rounded-top">
                    <h4 class="card-header-title mb-0">
                        <i class="bi-bar-chart-line-fill me-2"></i> <?php echo app('translator')->get('Summary'); ?>
                    </h4>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="bg-light p-3 rounded">
                                <h6 class="text-muted mb-1">Total Machine</h6>
                                <h4 class="mb-0 text-dark fw-semibold">
                                    <i class="bi-cpu me-1 text-primary"></i><?php echo e($monthlyPlansUser->total_machines); ?>

                                </h4>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="bg-light p-3 rounded">
                                <h6 class="text-muted mb-1">Reward Status</h6>
                                <h4 class="mb-0">
                                    <?php if($monthlyPlansUser->status == 0): ?>
                                    <span class="badge bg-warning text-dark">
                                        <i class="bi-clock me-1"></i> Pending
                                    </span>
                                    <?php else: ?>
                                    <span class="badge bg-success">
                                        <i class="bi-check-circle me-1"></i> Transferred
                                    </span>
                                    <?php endif; ?>
                                </h4>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="bg-light p-3 rounded">
                                <h6 class="text-muted mb-1">Mining Reward</h6>
                                <h4 class="mb-0 text-dark fw-semibold">
                                    <img class="currency-coin" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                    <?php echo e($monthlyPlansUser->mining_reward); ?>

                                </h4>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="bg-light p-3 rounded">
                                <h6 class="text-muted mb-1">Referral Commission Reward</h6>
                                <h4 class="mb-0 text-dark fw-semibold">
                                 <img class="currency-coin" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                 <?php echo e($monthlyPlansUser->commission_reward); ?>

                             </h4>
                         </div>
                     </div>

                     <div class="col-12">
                        <div class="bg-light p-3 rounded">
                            <h6 class="text-muted mb-1">Total Rewards</h6>
                            <h4 class="mb-0 text-dark fw-bold">
                                <img class="currency-coin" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                <?php echo e($monthlyPlansUser->total_reward); ?>

                            </h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-lg-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-gradient-secondary text-white rounded-top">
                <h4 class="card-header-title mb-0">
                    <i class="bi-wallet2 me-2"></i> <?php echo app('translator')->get('Reward Claim Checkout'); ?>
                </h4>
            </div>
            <div class="card-body">
                <div class="row align-items-center g-4">

                    
                    <div class="col-md-4 text-center">
                        <div class="bg-light p-3 rounded position-relative">
                            <h6 class="text-muted mb-2"><?php echo app('translator')->get('Scan to Send'); ?></h6>

                            <div id="qrcode" class="d-flex justify-content-center mb-3"></div>

                            <p class="mt-3 mb-1 small text-muted"><?php echo app('translator')->get('Wallet Address'); ?></p>

                            <div class="input-group">
                                <input type="text" id="walletAddress" class="form-control form-control-sm bg-white" readonly value="<?php echo e($wallet->address); ?>">
                                <button type="button" class="btn btn-outline-secondary btn-sm" onclick="copyWalletAddress()">
                                    <i class="bi-clipboard"></i> <?php echo app('translator')->get('Copy'); ?>
                                </button>
                            </div>
                            <small class="text-success d-none mt-1" id="copySuccess"><?php echo app('translator')->get('Copied!'); ?></small>
                        </div>
                    </div>

                    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
                    <script>
                        document.addEventListener("DOMContentLoaded", function () {
                            var walletAddress = <?php echo json_encode($wallet->address, 15, 512) ?>;
                            new QRCode(document.getElementById("qrcode"), {
                                text: walletAddress,
                                width: 180,
                                height: 180,
                                colorDark: "#000000",
                                colorLight: "#ffffff",
                                correctLevel: QRCode.CorrectLevel.H
                            });
                        });
                    </script>



                    
                    <div class="col-md-4">
                        <div class="bg-light p-4 rounded text-center">
                            <h6 class="text-muted mb-2"><?php echo app('translator')->get('Amount to Send'); ?></h6>
                            <h2 class="text-primary fw-bold">
                                <img class="currency-coin" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                <?php echo e($monthlyPlansUser->total_reward); ?>

                            </h2>
                            <p class="small text-muted"><?php echo app('translator')->get('Please send exactly this amount to the wallet address provided.'); ?></p>
                        </div>
                    </div>

                    
                    <div class="col-md-4">
                        <form method="POST" action="<?php echo e(route('admin.monthly.plan.maketransfer', ['id' => $id, 'user_id' => $user_id])); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="bg-light p-4 rounded">
                                <h6 class="text-muted mb-2"><?php echo app('translator')->get('Transaction Hash'); ?></h6>

                                <div class="form-group">
                                    <?php if($monthlyPlansUser->status == 0): ?>
                                    <input type="text" class="form-control" name="transaction_hash" placeholder="<?php echo app('translator')->get('Enter your transaction hash'); ?>" required <?php echo e($monthlyPlansUser->status != 0 ? 'disabled' : ''); ?>>
                                    <?php else: ?>
                                    <h2 class="text-primary fw-bold">
                                        <?php echo e($hash->tx_id); ?>

                                    </h6>
                                    <?php endif; ?>
                                </div>

                                <?php if($monthlyPlansUser->status == 0): ?>
                                <button type="submit" class="btn btn-primary mt-3 w-100">
                                    <i class="bi-send me-1"></i> <?php echo app('translator')->get('Submit Transaction'); ?>
                                </button>
                                <?php else: ?>
                                <button type="button" class="btn btn-secondary mt-3 w-100" disabled>
                                    <i class="bi-check-circle me-1"></i> <?php echo app('translator')->get('Transferred'); ?>
                                </button>
                                <?php endif; ?>
                            </div>
                        </form>
                    </div>



                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('script'); ?>
<script>
    function copyWalletAddress() {
        let walletInput = document.getElementById("walletAddress");
        let successMsg = document.getElementById("copySuccess");

        walletInput.select();
        walletInput.setSelectionRange(0, 99999); // For mobile
        document.execCommand("copy");

        successMsg.classList.remove('d-none');
        setTimeout(() => {
            successMsg.classList.add('d-none');
        }, 1500);
    }
</script>
<?php $__env->stopPush(); ?>


<div class="row">
    <div class="col-lg-12">
        <div class="card mt-4">
            <div class="card-header">
                <h4 class="card-header-title"><?php echo app('translator')->get('Mining Reward'); ?></h4>
            </div>
            <div class="card-body">
                <div class="table-responsive" style="overflow-x: auto;">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Customer ID'); ?></th>
                                <th><?php echo app('translator')->get('Customer Name'); ?></th>
                                <th><?php echo app('translator')->get('Plan'); ?></th>
                                <th><?php echo app('translator')->get('Quantity'); ?></th>
                                <th><?php echo app('translator')->get('Purchased At'); ?></th>
                                <th><?php echo app('translator')->get('Start Date'); ?></th>
                                <th><?php echo app('translator')->get('End Date'); ?></th>
                                <th><?php echo app('translator')->get('Days Vested'); ?></th>
                                <th><?php echo app('translator')->get('Hash Rate'); ?></th>
                                <th><?php echo app('translator')->get('Mining Reward'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $processedInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($investment['user_id']); ?></td>
                                <td><?php echo e($investment['user_name']); ?></td>
                                <td>
                                    <?php
                                    $plan = \App\Models\InvestmentPlan::find($investment['planId']);
                                    ?>
                                    <?php echo e($plan->plan_name ?? 'N/A'); ?>

                                </td>                                    
                                <td><?php echo e($investment['quantity']); ?></td>
                                <td><?php echo e($investment['purchased_date']); ?></td>
                                <td><?php echo e($investment['effective_start_date']); ?></td>
                                <td><?php echo e($investment['effective_end_date']); ?></td>
                                <td><?php echo e($investment['days_invested']); ?></td>
                                <td><?php echo e($investment['hashrate']); ?></td>
                                <td><?php echo e($investment['calculated_reward']); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card mt-4">
            <div class="card-header">
                <h4 class="card-header-title"><?php echo app('translator')->get('Referral Commission'); ?></h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <style>
                        .group-container {
                            margin-bottom: 20px;
                        }
                        .group-container .group-header {
                            background-color: #f8f9fa;
                            border: 2px solid #dee2e6;
                            border-radius: 5px 5px 0 0;
                        }
                        .group-container .group-body {
                            border-left: 2px solid #dee2e6;
                            border-right: 2px solid #dee2e6;
                            border-bottom: 2px solid #dee2e6;
                            border-radius: 0 0 5px 5px;
                            overflow: hidden;
                        }
                        .group-container .group-body .sub-group {
                            border-left: 1px dashed #adb5bd;
                            margin-left: 20px;
                            padding-left: 10px;
                        }
                        .level-0-row {
                            background-color: #eff5ff !important;
                            color: #000000 !important;
                        }
                        .level-1-row {
                            background-color: #c3e5fd !important;
                            color: #000000 !important;
                        }
                        .level-2-row {
                            background-color: #9ab4f5 !important;
                            color: #000000 !important;

                        }
                        .level-3-row {
                            background-color: #c4b7f7 !important;
                            color: #000000 !important;

                        }
                        .toggle-btn {
                            width: 24px;
                            height: 24px;
                            display: inline-flex;
                            align-items: center;
                            justify-content: center;
                            padding: 0;
                        }
                        .indent-cell {
                            padding-left: 30px !important;
                            position: relative;
                        }
                        .indent-cell:before {
                            content: "";
                            position: absolute;
                            left: 15px;
                            top: 50%;
                            width: 15px;
                            height: 1px;
                            background-color: #adb5bd;
                        }
                    </style>

                    <table class="table">
                        <thead>
                            <tr>
                                <th style="width: 50px;"></th>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Level</th>
                                <th>Purchased At</th>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th>Total Machines</th>
                                <th>Reward Commission</th>
                                <th>Reward Commission %</th>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $__currentLoopData = $referralReport; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agentId => $agentData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <?php
                           $groupClass = "group-{$agentId}";
                           $hasLevel1 = !empty($agentData['level1']);
                           ?>

                           <tr class="group-header level-0-row">
                            <td>
                                <?php if($hasLevel1): ?>
                                <button class="btn btn-sm btn-outline-primary toggle-btn" data-target="<?php echo e($groupClass); ?>">
                                    <i class="fas fa-plus"></i>
                                </button>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($agentData['agent']['user_id']); ?></td>
                            <td><?php echo e($agentData['agent']['user_name']); ?> (self)</td>
                            <td><span class="badge bg-info">Level 0</span></td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                        </tr>

                        <?php if($hasLevel1): ?>
                        <tbody class="group-body d-none <?php echo e($groupClass); ?>">
                            <?php $__currentLoopData = $agentData['level1']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $level1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $subGroupClass = "{$groupClass}-l1-{$index}";
                            $hasLevel2 = !empty($level1['level2']);
                            ?>

                            
                            <tr class="level-1-row">
                                <td class="indent-cell">
                                    <?php if($hasLevel2): ?>
                                    <button class="btn btn-sm btn-outline-secondary toggle-btn" data-target="<?php echo e($subGroupClass); ?>">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($level1['user_id']); ?></td>
                                <td><?php echo e($level1['user_name']); ?></td>
                                <td><span class="badge bg-success">Level 1</span></td>
                                <td><?php echo e($level1['purchased_date']); ?></td>
                                <td><?php echo e($level1['start_date']); ?></td>
                                <td><?php echo e($level1['end_date']); ?></td>
                                <td><?php echo e($level1['quantity']); ?></td>
                                <td><?php echo e(number_format($level1['commission'], 4)); ?></td>
                                <td><?php echo e($level1['commission_rate']); ?></td>
                            </tr>

                            <?php if($hasLevel2): ?>
                            <tbody class="sub-group d-none <?php echo e($subGroupClass); ?>">
                                <?php $__currentLoopData = $level1['level2']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level2Index => $level2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $hasLevel3 = !empty($level2['level3']); ?>
                                <tr class="level-2-row">
                                    <td class="indent-cell">
                                        <?php if($hasLevel3): ?>
                                        <button class="btn btn-sm btn-outline-secondary toggle-btn" data-target="<?php echo e($subGroupClass); ?>-l2-<?php echo e($level2Index); ?>">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($level2['user_id']); ?></td>
                                    <td><?php echo e($level2['user_name']); ?></td>
                                    <td><span class="badge bg-warning">Level 2</span></td>
                                    <td><?php echo e($level2['purchased_date']); ?></td>
                                    <td><?php echo e($level2['start_date']); ?></td>
                                    <td><?php echo e($level2['end_date']); ?></td>
                                    <td><?php echo e($level2['quantity']); ?></td>
                                    <td><?php echo e(number_format($level2['commission'], 4)); ?></td>
                                    <td><?php echo e($level2['commission_rate']); ?></td>
                                </tr>

                                <?php if($hasLevel3): ?>
                                <tbody class="sub-group d-none <?php echo e($subGroupClass); ?>-l2-<?php echo e($level2Index); ?>">
                                    <?php $__currentLoopData = $level2['level3']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="level-3-row">
                                        <td class="indent-cell"></td>
                                        <td><?php echo e($level3['user_id']); ?></td>
                                        <td><?php echo e($level3['user_name']); ?></td>
                                        <td><span class="badge bg-danger">Level 3</span></td>
                                        <td><?php echo e($level3['purchased_date']); ?></td>
                                        <td><?php echo e($level3['start_date']); ?></td>
                                        <td><?php echo e($level3['end_date']); ?></td>
                                        <td><?php echo e($level3['quantity']); ?></td>
                                        <td><?php echo e(number_format($level3['commission'], 4)); ?></td>
                                        <td><?php echo e($level3['commission_rate']); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <?php endif; ?>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>

                <script>
                    document.querySelectorAll('.toggle-btn').forEach(button => {
                        button.addEventListener('click', function () {
                            const targetClass = this.dataset.target;
                            const targetElement = document.querySelector(`.${targetClass}`);

                            if (!targetElement) return;

                            const isExpanding = targetElement.classList.contains('d-none');
                            targetElement.classList.toggle('d-none');
                            const icon = this.querySelector('i');
                            if (icon) {
                                icon.classList.remove('fa-plus', 'fa-minus');
                                icon.classList.add(isExpanding ? 'fa-minus' : 'fa-plus');
                            }
                            if (this.classList.contains('btn-outline-primary') || this.classList.contains('btn-primary')) {
                                this.classList.toggle('btn-outline-primary', !isExpanding);
                                this.classList.toggle('btn-primary', isExpanding);
                            }

                            if (this.classList.contains('btn-outline-secondary') || this.classList.contains('btn-secondary')) {
                                this.classList.toggle('btn-outline-secondary', !isExpanding);
                                this.classList.toggle('btn-secondary', isExpanding);
                            }
                        });
                    });
                </script>


            </div>
        </div>
    </div>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/monthly_report/transfer.blade.php ENDPATH**/ ?>