<?php $__env->startSection('page_title', __('Verify Code')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card card-lg mt-lg-5">
        <div class="card-body">
            <?php if(Session::has('status')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <span class="fw-semibold"><?php echo e(Session::get('status')); ?></span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <span class="fw-semibold"><?php echo e($errors->first()); ?></span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('admin.monthly.verify.code')); ?>" class="js-validate needs-validation" novalidate>
                <?php echo csrf_field(); ?>
                <div class="text-center">
                    <div class="mb-5">
                        <h1 class="display-5"><?php echo app('translator')->get('Verify Code'); ?></h1>
                        <p class="text-muted"><?php echo app('translator')->get('Enter the 6-digit code sent to your email.'); ?></p>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label" for="verify_code"><?php echo app('translator')->get('Verification Code'); ?></label>
                    <input type="text"
                           class="form-control form-control-lg <?php $__errorArgs = ['verify_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                           name="verify_code"
                           id="verify_code"
                           placeholder="Enter 6-digit code"
                           required>
                    <?php $__errorArgs = ['verify_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary btn-lg"><?php echo app('translator')->get('Verify'); ?></button>
                </div>
            </form>
            <form method="POST" action="<?php echo e(route('admin.monthly.verify.resend')); ?>">
                <?php echo csrf_field(); ?>
                <div class="d-grid">
                    <button type="submit" class="btn btn-link">Resend Code</button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/monthly_report/verify.blade.php ENDPATH**/ ?>