
<?php $__env->startSection('page_title',__('View Profile')); ?>
<?php $__env->startSection('content'); ?>

<!-- Content -->
<div class="content container-fluid">
    <div class="row justify-content-lg-center">
        <div class="col-lg-10">

            <?php echo $__env->make('admin.user_management.components.header_user_profile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="row">
                <div class="col-lg-4">
                    <div class="card mb-3 mb-lg-5">
                        <div class="card-header card-header-content-between">
                            <h4 class="card-header-title"><?php echo app('translator')->get('Profile'); ?></h4>
                        </div>

                        <div class="card-body">
                            <ul class="list-unstyled list-py-2 text-dark mb-0">
                                <li class="pb-0"><span class="card-subtitle"><?php echo app('translator')->get('About'); ?></span></li>
                                <li>
                                    <i class="bi-person dropdown-item-icon"></i> <?php echo app('translator')->get($user->firstname . ' ' . $user->lastname); ?>
                                </li>
                                <li>
                                    <i class="bi-at dropdown-item-icon"></i> <?php echo e($user->email); ?>

                                    <i
                                    class="bi-patch-check-fill text-<?php echo e($user->email_verification == 1 ? 'success' : 'danger'); ?>"
                                    data-bs-toggle="tooltip"
                                    data-bs-placement="top"
                                    aria-label="<?php echo e($user->email_verification == 1 ? 'Email Verified' : 'Email Unverified'); ?>"
                                    data-bs-original-title="<?php echo e($user->email_verification == 1 ? 'Email Verified' : 'Email Unverified'); ?>">
                                </i>
                            </li>
                        </ul>
                    </div>
                </div>

            </div>

            <div class="col-lg-8">
                <div class="card card-centered mb-3 mb-lg-5">
                    <div class="card-header card-header-content-between">
                        <h4 class="card-header-title"><?php echo app('translator')->get('Transaction'); ?></h4>
                    </div>


                    <?php if(count($transactions) == 0): ?>
                    <div class="card-body card-body-height">
                        <img class="avatar avatar-xxl mb-3"
                        src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>"
                        alt="Image Description" data-hs-theme-appearance="default"/>
                        <img class="avatar avatar-xxl mb-3"
                        src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>"
                        alt="Image Description" data-hs-theme-appearance="dark"/>
                        <p class="card-text"><?php echo app('translator')->get('No data to show'); ?></p>
                    </div>
                    <?php endif; ?>

                    <?php if(0 < count($transactions)): ?>
                    <div class="table-responsive">
                        <table
                        class="table table-thead-bordered table-nowrap table-align-middle card-table">
                        <thead class="thead-light">
                            <tr>
                                <th><?php echo app('translator')->get('No.'); ?></th>
                                <th><?php echo app('translator')->get('TRX'); ?></th>
                                <th><?php echo app('translator')->get('Amount'); ?></th>
                                <th><?php echo app('translator')->get('Remarks'); ?></th>
                                <th><?php echo app('translator')->get('Date-Time'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>  $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <?php echo e($loop->index + 1); ?>

                                </td>
                                <td>
                                    <?php echo e($transaction->trx_id); ?>

                                </td>
                                <td>
                                    <h6 class="mb-0 <?php echo e($transaction->trx_type == '+' ? 'text-success' : 'text-danger'); ?>"><?php echo e($transaction->trx_type . currencyPosition($transaction->amount)); ?></h6>
                                </td>
                                <td> <?php echo app('translator')->get($transaction->remarks); ?></td>
                                <td><?php echo e(dateTime($transaction->created_at, 'd M Y h:i A')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>

            <div class="card card-centered mb-3 mb-lg-5">
                <div class="card-header card-header-content-between">
                    <h4 class="card-header-title"><?php echo app('translator')->get('Referral List'); ?></h4>
                </div>

                <div class="table-responsive">
                    <table class="table table-thead-bordered table-nowrap table-align-middle card-table">
                        <thead class="thead-light">
                            <tr>
                                <th><?php echo app('translator')->get('Level'); ?></th>
                                <th><?php echo app('translator')->get('Referrals'); ?></th>
                                <th class="text-end"><?php echo app('translator')->get('Total Earnings'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <?php echo app('translator')->get('Level 1'); ?> 
                                    <span class="badge bg-soft-primary text-primary ms-2"><?php echo e($lvl1percentage); ?>%</span>
                                </td>
                                <td>
                                    <?php echo e($lvl1); ?> <?php echo app('translator')->get('referrals'); ?>
                                </td>
                                <td class="text-end">
                                    <span class="d-inline-flex align-items-center">
                                        <img src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" alt="icon" class="me-1" width="20">
                                        <strong><?php echo e($lvl1_total); ?></strong>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <?php echo app('translator')->get('Level 2'); ?>
                                    <span class="badge bg-soft-secondary text-secondary ms-2"><?php echo e($lvl2percentage); ?>%</span>
                                </td>
                                <td>
                                    <?php echo e($lvl2); ?> <?php echo app('translator')->get('referrals'); ?>
                                </td>
                                <td class="text-end">
                                    <span class="d-inline-flex align-items-center">
                                        <img src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" alt="icon" class="me-1" width="20">
                                        <strong><?php echo e($lvl2_total); ?></strong>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <?php echo app('translator')->get('Level 3'); ?>
                                    <span class="badge bg-soft-info text-info ms-2"><?php echo e($lvl3percentage); ?>%</span>
                                </td>
                                <td>
                                    <?php echo e($lvl3); ?> <?php echo app('translator')->get('referrals'); ?>
                                </td>
                                <td class="text-end">
                                    <span class="d-inline-flex align-items-center">
                                        <img src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" alt="icon" class="me-1" width="20">
                                        <strong><?php echo e($lvl3_total); ?></strong>
                                    </span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card card-centered mb-3 mb-lg-5">
                <div class="card-header card-header-content-between">
                    <h4 class="card-header-title"><?php echo app('translator')->get('Referral Listing'); ?></h4>
                </div>

                <div class="table-responsive">
                    <table class="table table-thead-bordered table-nowrap table-align-middle card-table referral-listing mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th><?php echo app('translator')->get('Username'); ?></th>
                                <th><?php echo app('translator')->get('Email'); ?></th>
                                <th><?php echo app('translator')->get('Level'); ?></th>
                                <th><?php echo app('translator')->get('Date Purchased'); ?></th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php $__currentLoopData = $referral_structure; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $level1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $hasLevel2 = !empty($level1['level2']); ?>
                            <tr class="level-1-row">
                                <td class="fw-bold">
                                    <?php if($hasLevel2): ?>
                                    <button class="btn btn-sm btn-outline-primary toggle-btn" data-target="level1-<?php echo e($index); ?>">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                    <?php endif; ?>
                                    <?php echo e($level1['username']); ?>

                                </td>
                                <td><?php echo e($level1['email']); ?></td>
                                <td><span class="badge bg-success">Level 1</span></td>
                                <td><?php echo e($level1['date'] ?: 'N/A'); ?></td>
                            </tr>

                            <?php if($hasLevel2): ?>
                            <tbody class="d-none level1-<?php echo e($index); ?>">
                                <?php $__currentLoopData = $level1['level2']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l2index => $level2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $hasLevel3 = !empty($level2['level3']); ?>
                                <tr class="level-2-row">
                                    <td class="ps-4">
                                        <?php if($hasLevel3): ?>
                                        <button class="btn btn-sm btn-outline-secondary toggle-btn" data-target="level2-<?php echo e($index); ?>-<?php echo e($l2index); ?>">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                        <?php endif; ?>
                                        <?php echo e($level2['username']); ?>

                                    </td>
                                    <td><?php echo e($level2['email']); ?></td>
                                    <td><span class="badge bg-warning">Level 2</span></td>
                                    <td><?php echo e($level2['date'] ?: 'N/A'); ?></td>
                                </tr>

                                <?php if($hasLevel3): ?>
                                <tbody class="d-none level2-<?php echo e($index); ?>-<?php echo e($l2index); ?>">
                                    <?php $__currentLoopData = $level2['level3']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="level-3-row">
                                        <td class="ps-5"><?php echo e($level3['username']); ?></td>
                                        <td><?php echo e($level3['email']); ?></td>
                                        <td><span class="badge bg-danger">Level 3</span></td>
                                        <td><?php echo e($level3['date'] ?: 'N/A'); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>




        </div>

    </div>

</div>
</div>
</div>
</div>


<?php echo $__env->make('admin.user_management.components.login_as_user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.user_management.components.update_balance_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.user_management.components.block_profile_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
<script>
    document.querySelectorAll('.toggle-btn').forEach(button => {
        button.addEventListener('click', function () {
            const targetClass = this.dataset.target;
            const targetElement = document.querySelector(`.${targetClass}`);

            if (!targetElement) return;

            const isExpanding = targetElement.classList.contains('d-none');
            targetElement.classList.toggle('d-none');

            const icon = this.querySelector('i');
            if (icon) {
                icon.classList.remove('fa-plus', 'fa-minus');
                icon.classList.add(isExpanding ? 'fa-minus' : 'fa-plus');
            }

            if (this.classList.contains('btn-outline-primary') || this.classList.contains('btn-primary')) {
                this.classList.toggle('btn-outline-primary', !isExpanding);
                this.classList.toggle('btn-primary', isExpanding);
            }

            if (this.classList.contains('btn-outline-secondary') || this.classList.contains('btn-secondary')) {
                this.classList.toggle('btn-outline-secondary', !isExpanding);
                this.classList.toggle('btn-secondary', isExpanding);
            }
        });
    });
</script>

<script>
    'use strict';
    $(document).on('click', '.loginAccount', function () {
        let route = $(this).data('route');
        $('.loginAccountAction').attr('action', route)
    });

    $(document).on('click', '.blockProfile', function () {
        let route = $(this).data('route');
        $('.blockProfileAction').attr('action', route)
    });

</script>
<?php $__env->stopPush(); ?>








<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/user_management/user_view_profile.blade.php ENDPATH**/ ?>