<!DOCTYPE html>

<html lang="en" <?php if(session()->get('rtl') == 1): ?> dir="rtl" <?php endif; ?>>

<head>

    <meta charset="utf-8" />

    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo app('translator')->get('Payment Failed'); ?></title>

    <link href='https://fonts.googleapis.com/css?family=Lato:300,400|Montserrat:700' rel='stylesheet' type='text/css'>

    <link rel="stylesheet" href="<?php echo e(asset('assets/themes/light/css/all.min.css')); ?>">

    <link href="<?php echo e(asset('assets/global/css/success_faield.css')); ?>?v=<?php echo e(time()); ?>" rel="stylesheet" type="text/css">

    <link rel="shortcut icon" href="<?php echo e(getFile(basicControl()->favicon_driver, basicControl()->favicon)); ?>"

        type="image/x-icon">

</head>

<body>

    <header class="site-header" id="header">

        <h1 class="site-header__title" data-lead-id="site-header-title"><?php echo app('translator')->get('Sorry'); ?>!</h1>

    </header>



    <div class="main-content">

        <i class="fa fa-times main-content__times" id="checkmark"></i>

        <p class="main-content__body" data-lead-id="main-content-body">

            <?php echo app('translator')->get('We really appreciate you giving us a moment of your time today but unfortunately the payment was unsuccessful due to'); ?>

            <?php echo e(session('error') ?? __('it seems some issue in server to server communication. Kindly connect with administrator')); ?>

        </p>

    </div>

    <footer class="site-footer" id="footer">

        <button type="button" class="primary-button mb-4" onclick="window.location.href='<?php echo e(route('user.plans')); ?>'">

            <?php echo app('translator')->get('Go Back to Dashboard'); ?>

        </button>

        <p class="site-footer__fineprint" id="fineprint">

            <?php echo app('translator')->get('Copyright'); ?> <?php echo app('translator')->get('©'); ?> <?php echo e(date('Y')); ?> | <?php echo app('translator')->get('All Rights Reserved'); ?>

            <a href="<?php echo e(url('/')); ?>" class="site_title"><?php echo e(__(basicControl()->site_title)); ?></a>

        </p>

    </footer>

</body>

</html><?php /**PATH /home/petarig/public_html/project/resources/views/failed.blade.php ENDPATH**/ ?>