
<?php $__env->startSection('page_title', __('Edit email template')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get("Dashboard"); ?>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                <a class="breadcrumb-link" href="<?php echo e(route('admin.settings')); ?>"><?php echo app('translator')->get('Settings'); ?></a>
                            </li>
                            <li class="breadcrumb-item active"
                                aria-current="page"><?php echo app('translator')->get("Edit email template"); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get("Edit email template"); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title"><?php echo app('translator')->get("Edit Email Template"); ?></h4>
                        </div>
                        <div class="card-body">
                            <p class="card-text"><?php echo app('translator')->get('Short keys for use in '); ?> <?php echo e(__($template->name)); ?></p>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-thead-bordered table-nowrap table-align-middle card-table">
                                <thead class="thead-light">
                                <tr>
                                    <th width="50%"> <?php echo app('translator')->get('SHORTCODE'); ?> </th>
                                    <th width="50%"> <?php echo app('translator')->get('DESCRIPTION'); ?> </th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $template->short_keys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <pre>[[<?php echo app('translator')->get($key); ?>]]</pre>
                                        </td>
                                        <td><?php echo app('translator')->get($value); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body pt-0">
                            <ul class="nav nav-tabs mb-3" role="tablist">
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a id="nav-<?php echo e($value->id); ?>-eg1-tab" href="#nav-<?php echo e($value->id); ?>-eg1"
                                           data-bs-toggle="pill" data-bs-target="#nav-<?php echo e($value->id); ?>-eg1" role="tab"
                                           aria-controls="nav-<?php echo e($value->id); ?>-eg1"
                                           aria-selected="<?php echo e(old('language_id') == $value->id ? 'true' : (!old('language_id') && $key == 0 ? 'true' : 'false')); ?>"
                                           class="nav-link <?php echo e(old('language_id') == $value->id ? 'active' : (!old('language_id') && $key == 0 ? 'active' : '')); ?>">
                                            <i class="mdi mdi-home-variant d-lg-none d-block mr-1"></i>
                                            <span class="d-none d-lg-block"><?php echo e(__($value->name)); ?></span>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="tab-content">
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div
                                        class="tab-pane <?php echo e(old('language_id') == $value->id ? 'show active' : (!old('language_id') && $key == 0 ? 'show active' : '')); ?>"
                                        id="nav-<?php echo e($value->id); ?>-eg1" role="tabpanel"
                                        aria-labelledby="nav-<?php echo e($value->id); ?>-eg1-tab">
                                        <form method="post"
                                              action="<?php echo e(route('admin.email.template.update', [$template->id, $value->id])); ?>"
                                              enctype="multipart/form-data"
                                              class="base-form">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('put'); ?>
                                            <div class="my-4 section-title"><?php echo e(trans('Mail in')); ?>  <?php echo e(__($value->name)); ?>

                                                : <?php echo e(__(isset($templates[$key]) ? $templates[$key]->name : '')); ?></div>
                                            <div class="row mb-4 d-flex align-items-center">
                                                <div class="col-md-6">
                                                    <label class="form-label"><?php echo app('translator')->get('Subject'); ?></label>
                                                    <input
                                                        class="form-control <?php $__errorArgs = ['subject.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        type="text" name="subject[<?php echo e($value->id); ?>]"
                                                        value="<?php echo e(old('subject.'.$value->id, isset($templates[$key]) ? $templates[$key]->subject : '')); ?>"
                                                        autocomplete="off">
                                                    <?php $__errorArgs = ['subject.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback">
                                                        <?php echo e(__($message)); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-md-6">
                                                    <label class="form-label"><?php echo app('translator')->get('Mail From'); ?></label>
                                                    <input
                                                        class="form-control <?php $__errorArgs = ['email_from.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        type="text" name="email_from[<?php echo e($value->id); ?>]"
                                                        value="<?php echo e(old('email_from.'.$value->id, isset($templates[$key]) ? $templates[$key]->email_from : '')); ?>"
                                                        autocomplete="off">
                                                    <?php $__errorArgs = ['email_from.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback">
                                                        <?php echo e(__($message)); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-md-6 mt-2">
                                                    <label class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                                                    <input
                                                        class="form-control <?php $__errorArgs = ['name.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        type="text" name="name[<?php echo e($value->id); ?>]"
                                                        value="<?php echo e(old('name.'.$value->id, isset($templates[$key]) ? $templates[$key]->name : '')); ?>"
                                                        autocomplete="off">
                                                    <?php $__errorArgs = ['name.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback">
                                                        <?php echo e(__($message)); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-md-6 mt-2">
                                                    <label class="row form-check form-switch"
                                                           for="status[<?php echo e($value->id); ?>]">
                                                                <span class="col-8 col-sm-9 ms-0 mt-4">
                                                                  <span class="d-block text-dark"><?php echo app('translator')->get("Status"); ?></span>
                                                                  <span
                                                                      class="d-block fs-5"><?php echo app('translator')->get("Enable status for email notification."); ?></span>
                                                                </span>
                                                        <span class="col-4 col-sm-2 text-end">
                                                                <input type='hidden' value='0' name='mail_status'>
                                                                <input
                                                                    class="form-check-input <?php $__errorArgs = ['mail_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                    type="checkbox" name="mail_status"
                                                                    id="mail_status[<?php echo e($value->id); ?>]"
                                                                    value="1" <?php echo e(old('mail_status.'.$value->id, $templates[$key]->status['mail'] ?? 0 ) == 1 ? 'checked' : ''); ?>>

                                                            </span>
                                                        <?php $__errorArgs = ['mail_status.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger">
                                                        <?php echo e(__($message)); ?>

                                                    </span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="form-group col-md-12">
                                                    <label><?php echo app('translator')->get('Message'); ?></label>
                                                    <textarea class="form-control summernote <?php $__errorArgs = ['email_template.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        name="email_template[<?php echo e($value->id); ?>]"><?php echo e(old('email_template.'.$value->id, $templates[$key]->email ?? '')); ?></textarea>
                                                    <?php $__errorArgs = ['email_template.'.$value->id];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback">
                                                        <?php echo e(__($message)); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <button type="submit"
                                                    class="btn btn-primary mt-3"><?php echo app('translator')->get('Save Changes'); ?></button>
                                        </form>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('css-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/summernote-bs5.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/summernote-bs5.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).ready(function () {
            $('.summernote').summernote({
                height: 200,
                callbacks: {
                    onBlurCodeview: function () {
                        let codeviewHtml = $(this).siblings('div.note-editor').find('.note-codable')
                            .val();
                        $(this).val(codeviewHtml);
                    }
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>





<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/notification_templates/email_template/edit.blade.php ENDPATH**/ ?>