<!--Start of Google analytic Script-->
<?php if(basicControl()->analytic_status): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(basicControl()->measurement_id); ?>"></script>
    <script>
        "use strict";
        var MEASUREMENT_ID = "<?php echo e(basicControl()->measurement_id); ?>";
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }

        gtag('js', new Date());
        gtag('config', MEASUREMENT_ID);
    </script>
<?php endif; ?>
<!--End of Google analytic Script-->


<!--Start of Tawk.to Script-->
<?php if(basicControl()->tawk_status): ?>
    <script type="text/javascript">
        // $(document).ready(function () {
        var Tawk_SRC = 'https://embed.tawk.to/' + "<?php echo e(trim(basicControl()->tawk_id)); ?>";
        var Tawk_API = Tawk_API || {}, Tawk_LoadStart = new Date();
        (function () {
            var s1 = document.createElement("script"), s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = Tawk_SRC;
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();
        // });
    </script>
<?php endif; ?>


<!--start of Facebook Messenger Script-->
<?php if(basicControl()->fb_messenger_status): ?>
    <div id="fb-root"></div>
    <script>
        "use strict";
        var fb_app_id = "<?php echo e(basicControl()->fb_app_id); ?>";
        window.fbAsyncInit = function () {
            FB.init({
                appId: fb_app_id,
                autoLogAppEvents: true,
                xfbml: true,
                version: 'v10.0'
            });
        };
        (function (d, s, id) {
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) return;
            js = d.createElement(s);
            js.id = id;
            js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js';
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    </script>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/en_US/sdk.js"></script>
    <div class="fb-customerchat" page_id="<?php echo e(basicControl()->fb_page_id); ?>"></div>
<?php endif; ?>
<!--End of Facebook Messenger Script-->

<?php if(basicControl()->cookie_status): ?>

    <div class="cookies-allert" id="cookiesAlert">
        <img src="<?php echo e(getFile(basicControl()->cookie_driver,basicControl()->cookie_image)); ?>" class=""
             alt="<?php echo e(basicControl()->site_title??'FarmTrader'); ?> cookies">
        <h4 class="mt-2 text-center"><?php echo e(basicControl()->cookie_title); ?></h4>
        <span class="d-block mt-2 text-center"><?php echo e(basicControl()->cookie_short_text); ?> <a
                href="<?php echo e(basicControl()->cookie_button_url); ?>"
                class="seemoreButton"><?php echo e(basicControl()->cookie_button_name); ?></a></span>
        <a href="javascript:void(0);" class="mt-3 cookieButton btn-1 justify-content-center" type="button"
           onclick="acceptCookiePolicy()"><?php echo app('translator')->get('Accept'); ?><span></span></a>
        <a href="javascript:void(0);" class="mt-2 cookieClose text-center" type="button" onclick="closeCookieBanner()">Close</a>
    </div>

    <script>
        function setCookie(name, value, days) {
            var expires = "";
            if (days) {
                var date = new Date();
                date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                expires = "; expires=" + date.toUTCString();
            }
            document.cookie = name + "=" + value + expires + "; path=/";
        }

        // Function to check if the user has accepted the cookie policy
        function hasAcceptedCookiePolicy() {
            return document.cookie.indexOf('<?php echo e(basicControl()->site_title); ?>'+"_cookie_policy_accepted=true") !== -1;
        }

        // Function to handle the user accepting the cookie policy
        function acceptCookiePolicy() {
            setCookie('<?php echo e(basicControl()->site_title); ?>'+"_cookie_policy_accepted=true", true, 365);
            document.getElementById("cookiesAlert").style.display = "none";
        }

        // Function to handle the user closing the cookie banner without accepting
        function closeCookieBanner() {
            document.getElementById("cookiesAlert").style.display = "none";
        }
        // Display the cookie banner if the user has not accepted the policy
        document.addEventListener('DOMContentLoaded',()=>{

            if (!hasAcceptedCookiePolicy()) {
                document.getElementById("cookiesAlert").style.display = "block";
            }
        })

    </script>

<?php endif; ?>


<script>
    "use strict";
    var root = document.querySelector(':root');
    root.style.setProperty('--primary', '<?php echo e(basicControl()->primary_color); ?>');
    root.style.setProperty('--secondary', '<?php echo e(basicControl()->secondary_color); ?>');
</script>
<?php /**PATH /home/petarig/public_html/project/resources/views/plugins.blade.php ENDPATH**/ ?>