
<?php $__env->startSection('page_title', __('Monthly General')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item"><a class="breadcrumb-link" href="javascript:void(0)"><?php echo app('translator')->get("Dashboard"); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get("Monthly General"); ?></li>
                    </ol>
                </nav>
                <h1 class="page-header-title"><?php echo app('translator')->get("Monthly General"); ?></h1>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header card-header-content-md-between">
                    <div class="mb-2 mb-md-0">
                        <div class="input-group input-group-merge navbar-input-group">
                            <div class="input-group-prepend input-group-text">
                                <i class="bi-search"></i>
                            </div>
                            <input type="search" id="datatableSearch"
                            class="search form-control form-control-sm"
                            placeholder="<?php echo app('translator')->get('Search Records'); ?>"
                            aria-label="<?php echo app('translator')->get('Search Records'); ?>"
                            autocomplete="off">
                        </div>
                    </div>

                    <div class="d-grid d-sm-flex justify-content-md-end align-items-sm-center gap-2">
                        <a href="<?php echo e(route('admin.monthly.general.create')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Create General Setting'); ?></a>
                    </div>
                </div>

                <div class="table-responsive datatable-custom">
                    <table id="datatable"
                    class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                    data-hs-datatables-options='{
                       "columnDefs": [{
                          "targets": [6],
                          "orderable": false
                      }],
                      "order": [],
                      "info": {
                         "totalQty": "#datatableWithPaginationInfoTotalQty"
                     },
                     "search": "#datatableSearch",
                     "entries": "#datatableEntries",
                     "pageLength": 10,
                     "isResponsive": false,
                     "isShowPaging": false,
                     "pagination": "datatablePagination"
                 }'>
                 <thead class="thead-light">
                    <tr>
                        <th><?php echo app('translator')->get('ID'); ?></th>
                        <th><?php echo app('translator')->get('Period Start'); ?></th>
                        <th><?php echo app('translator')->get('Period End'); ?></th>
                        <th><?php echo app('translator')->get('Total HashRate'); ?></th>
                        <th><?php echo app('translator')->get('Daily Coin Generated'); ?></th>
                        <th><?php echo app('translator')->get('Total Machine'); ?></th>
                        <th><?php echo app('translator')->get('Created At'); ?></th>
                        <th><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                </thead>

                <tbody></tbody>
            </table>
        </div>

        <div class="card-footer">
            <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                        <span class="me-2"><?php echo app('translator')->get('Showing:'); ?></span>
                        <div class="tom-select-custom">
                            <select id="datatableEntries"
                            class="js-select form-select form-select-borderless w-auto"
                            autocomplete="off"
                            data-hs-tom-select-options='{
                                "searchInDropdown": false,
                                "hideSearch": true
                            }'>
                            <option value="5">5</option>
                            <option value="10" selected>10</option>
                            <option value="15">15</option>
                            <option value="20">20</option>
                        </select>
                    </div>
                    <span class="text-secondary me-2"><?php echo app('translator')->get('of'); ?></span>
                    <span id="datatableWithPaginationInfoTotalQty"></span>
                </div>
            </div>

            <div class="col-sm-auto">
                <div class="d-flex justify-content-center justify-content-sm-end">
                    <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" data-bs-backdrop="static"
aria-hidden="true">
<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="deleteModalLabel"><i
                class="bi bi-check2-square"></i> <?php echo app('translator')->get("Confirmation"); ?></h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="" method="post" class="setRoute">
                <?php echo csrf_field(); ?>
                <?php echo method_field("delete"); ?>
                <div class="modal-body">
                    <p><?php echo app('translator')->get("Do you want to delete this record?"); ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
<script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/select.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/appear.min.js')); ?>"></script>
<script src="<?php echo e(asset("assets/admin/js/hs-counter.min.js")); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route('admin.monthly.general.list')); ?>",
            searching: true,
            ordering: false,
            pageLength: 10,
            lengthMenu: [5, 10, 15, 20],
            language: {
                search: '',
                searchPlaceholder: "<?php echo app('translator')->get('Search Records'); ?>",
                zeroRecords: `<div class="text-center p-4">
                    <img class="mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="No Data">
                    <p class="mb-0"><?php echo app('translator')->get('No data to show'); ?></p>
                </div>`,
            },
            columns: [
                { data: 'id', name: 'id' },
                { data: 'period_start', name: 'period_start' },
                { data: 'period_end', name: 'period_end' },
                { data: 'total_hashrate', name: 'total_hashrate' },
                { data: 'total_coin_generated', name: 'total_coin_generated' },
                { data: 'total_machine', name: 'total_machine' },
                { data: 'created_at', name: 'created_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });

        $('#datatableSearch').on('keyup', function () {
            $('#datatable').DataTable().search(this.value).draw();
        });

        $('#datatableEntries').on('change', function () {
            $('#datatable').DataTable().page.len(this.value).draw();
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/monthly_general/index.blade.php ENDPATH**/ ?>