<?php $__env->startSection('page_title',__('Admin Management')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title"><?php echo app('translator')->get('Admin Users List'); ?></h1>
            </div>
            <div class="col-sm-auto">
                <a class="btn btn-primary" href="<?php echo e(route('admin.admins.create')); ?>">
                    <i class="bi-person-plus-fill me-1"></i> <?php echo app('translator')->get('Add Admin'); ?>
                </a>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Admin Users Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle">
                    <thead class="thead-light">
                        <tr>
                            <th><?php echo app('translator')->get('Full Name'); ?></th>
                            <th><?php echo app('translator')->get('Email'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($admin->name); ?></td>
                            <td><?php echo e($admin->email); ?></td>
                            <td><?php echo e($admin->status ? 'Active' : 'Inactive'); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.admins.edit', $admin->id)); ?>" class="btn btn-sm btn-warning"><?php echo app('translator')->get('Edit'); ?></a>
                                <?php if($admin->id!=1){ ?>

                                    <form action="<?php echo e(route('admin.admins.destroy', $admin->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('<?php echo app('translator')->get('Are you sure you want to delete this admin?'); ?>')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger"><?php echo app('translator')->get('Delete'); ?></button>
                                    <?php } ?>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- End Admin Users Table -->
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/admin/index.blade.php ENDPATH**/ ?>