<?php $__env->startSection('title',trans('Transactions')); ?>

<?php $__env->startPush('style'); ?>
<style>
    .text-primary {
        color: #0e73e4 !important;
    }

    .text-success {
        color: #5ad57b !important
    }

    .filter-btn,
    .download-btn {
        color: white;
        border-radius: 10px;
        background-color: #0f3246;
        padding: 0.5rem 0.9rem;
    }

    .filter-btn img,
    .download-btn img {
        margin-right: 0.6rem;
    }

    .download-btn {
        background-color: #0e73e4;
    }

    .table-responsive {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    .transaction-table {
        border-collapse: separate;
        border-spacing: 0;
        border-radius: 12px;
        border: 1px solid #195273;
        overflow: hidden;
        width: 100%;
    }

    .transaction-table tbody tr:nth-child(odd) {
        background-color: #0a202d;
    }

    .transaction-table tbody tr:nth-child(even) {
        background-color: #0d2b3c;
    }

    .transaction-table tbody tr td:first-child {
        padding: 1.2rem 0 1.2rem 1.4rem;
    }

    .transaction-table tbody tr td:nth-child(2) {
        padding: 1.2rem 1.4rem 1.2rem 0;
    }

    .transaction-table span {
        font-size: 12px;
    }

    .transaction-table td {
        vertical-align: middle;
    }

    .transaction-table .title {
        display: -webkit-box;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .transaction-icon {
        width: 40px;
        height: auto;
        display: block;
    }

    .transaction-coin {
        width: 18px;
        height: auto;
        display: block;
    }

    @media (max-width: 425px) {
        .transaction-icon {
            width: 20px;
        }

        .transaction-table .title {
            font-size: 14px !important;
            -webkit-line-clamp: 2;
        }

        .transaction-table tbody tr td:first-child {
            padding: 1rem 0 1rem 1.2rem;
        }

        .transaction-table tbody tr td:nth-child(2) {
            padding: 1rem 1.2rem 1rem 0;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<div class="pagetitle">
    <h3 class="mt-2 mb-5 ms-1 font-bold"><?php echo app('translator')->get('Transaction History'); ?></h3>
</div>

<div class="mt-50">

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center mt-4 mb-3">
        <p class="mb-2 mb-md-0 ms-1">
            Last <?php echo e($transactions->count() + count($data['transaction_allocation'])); ?> transactions
        </p>

        <div class="d-flex align-items-center">
            <div class="d-flex align-items-center filter-btn" data-bs-toggle="modal" data-bs-target="#filterModal" role="button">
                <img src="<?php echo e(asset('assets/themes/light/images/icons/FilterIcon.svg')); ?>" alt="" />
                Filter
            </div>

            <div class="dropdown ms-3">
                <button class="d-flex align-items-center download-btn dropdown-toggle" data-bs-toggle="dropdown">
                    <img src="<?php echo e(asset('assets/themes/light/images/icons/DownloadSimple.svg')); ?>" alt="" />
                    Download
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#" id="downloadCSV">Download CSV</a></li>
                    <li><a class="dropdown-item" href="#" id="downloadPDF">Download PDF</a></li>
                </ul>
            </div>

        </div>
    </div>

    
    <div class="modal fade" id="filterModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content bg-dark text-white border-0 rounded-3">
                <div class="modal-body p-0">
                    <form method="GET" action="<?php echo e(route('user.transaction.transaction-history')); ?>">
                        <div class="common-item">
                            <h6 class="mb-3 ps-2 text-white font-bold">Filter Transactions</h6>

                            <div class="d-flex justify-content-between align-items-center mb-3 gap-2">
                                <div class="filter-item <?php echo e(request('date_range') ? '' : 'active'); ?>" data-range="all">All Time</div>
                                <div class="filter-item <?php echo e(request('date_range') && \Str::contains(request('date_range'), 'to') ? '' : ''); ?>" data-range="last_month">Last Month</div>
                                <div class="filter-item <?php echo e(request('date_range') && \Str::contains(request('date_range'), 'to') ? 'active' : ''); ?>" data-range="pick_date">Pick Date</div>
                            </div>

                            <input type="text" class="w-100 border-0 filter-date mt-3 date" name="date_range" value="<?php echo e(request('date_range')); ?>" placeholder="Pick date range" style="display: <?php echo e(request('date_range') ? 'block' : 'none'); ?>;" />

                            <div class="btn-area d-flex mt-5">
                                <button type="submit" class="btn-2 submit-btn w-100 d-flex justify-content-center font-bold"><?php echo app('translator')->get('Apply Filter'); ?></button>
                            </div>

                            <div class="btn-area d-flex">
                                <button type="button" class="cancel-btn text-white w-100 d-flex justify-content-center font-bold pt-3" data-bs-dismiss="modal"><?php echo app('translator')->get('Cancel'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    
    <div class="table-responsive">
        <table class="transaction-table mb-4">
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $data['transaction_allocation']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="transaction-row">
                    <td class="align-middle d-flex align-items-center">
                        <img class="transaction-icon" src="<?php echo e(asset('assets/themes/light/images/icons/ThunderCoinIcon.svg')); ?>" />
                        <div style="margin-left: 0.8rem;">
                            <p class="mb-0 font-bold title">
                                <img class="currency-coin" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                                <?php echo e($trx['amount']); ?>

                            </p>
                            <span><?php echo e(\Carbon\Carbon::parse($trx['month_allocation'])->format('d-m-Y, H:i:s')); ?></span>
                        </div>
                    </td>
                    <td class="text-end align-middle">
                        <p class="mb-1 font-bold title">
                            <img class="currency-coin" src="<?php echo e(asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg')); ?>" />
                            <?php echo e(number_format($trx['amount'], 4)); ?>

                        </p>
                        <span class="d-flex justify-content-end">via <span class="text-primary ps-1">Petarigs</span></span>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="2" class="text-center text-muted p-4"><?php echo app('translator')->get('No transactions found.'); ?></td>
                </tr>
                <?php endif; ?>
                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="transaction-row">
                    <td class="align-middle d-flex align-items-center">
                        <img class="transaction-icon" src="<?php echo e(asset('assets/themes/light/images/icons/ThunderCoinIcon.svg')); ?>" />
                        <div style="margin-left: 0.8rem;">
                            <p class="mb-0 font-bold title"><?php echo e($trx->plan->plan_name); ?> x<?php echo e($trx->quantity); ?></p>
                            <span class="me-2">
                             <strong>    Purchased at:</strong> <?php echo e(\Carbon\Carbon::parse($trx->created_at)->format('d-m-Y')); ?>

                         </span><br>
                         <span class="me-2">
                            <strong>Start:</strong> <?php echo e(\Carbon\Carbon::parse($trx->created_at)->addDay()->format('d-m-Y')); ?>

                        </span><br>
                        <span>
                            <strong>Expiry:</strong> <?php echo e(\Carbon\Carbon::parse($trx->plan_expiry_date)->format('d-m-Y')); ?>

                        </span>
                    </div>
                </td>
                <td class="text-end align-middle">
                    <p class="mb-1 font-bold title">USD <?php echo e(number_format($trx->invest_amount, 2)); ?></p>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="2" class="text-center text-muted p-4"><?php echo app('translator')->get('No transactions found.'); ?></td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>


<div class="mt-3">
    <?php echo e($transactions->appends(request()->only('date_range'))->links()); ?>

</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    'use strict';

    flatpickr(".date", {
        mode: "range",
        dateFormat: "Y-m-d"
    });

    $('.filter-item').on('click', function() {
        $('.filter-item').removeClass('active');
        $(this).addClass('active');

        const selected = $(this).data('range');
        if (selected === 'pick_date') {
            $('.filter-date').slideDown().val('');
        } else {
            $('.filter-date').slideUp();
            let from, to;
            const today = new Date();
            const lastMonth = new Date();
            lastMonth.setMonth(today.getMonth() - 1);

            if (selected === 'last_month') {
                from = lastMonth.toISOString().slice(0, 10);
                to = today.toISOString().slice(0, 10);
                $('.filter-date').val(`${from} to ${to}`);
            } else if (selected === 'all') {
                $('.filter-date').val('');
            }
        }
    });
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.28/jspdf.plugin.autotable.min.js"></script>

<script>
    function getTableData() {
        const rows = [];
        document.querySelectorAll('.transaction-table .transaction-row').forEach(row => {
            const cols = row.querySelectorAll('td');
            const title = cols[0].querySelector('.title')?.textContent.trim();
            const date = cols[0].querySelector('span')?.textContent.trim();
            const amount = cols[1].querySelector('.title')?.textContent.trim();
            rows.push([title, date, amount]);
        });
        return rows;
    }

    // CSV
    document.getElementById('downloadCSV').addEventListener('click', function() {
        const rows = getTableData();
        let csvContent = "data:text/csv;charset=utf-8,Title,Date,Amount\n" +
        rows.map(e => e.join(",")).join("\n");

        const encodedUri = encodeURI(csvContent);
        const link = document.createElement("a");
        link.setAttribute("href", encodedUri);
        link.setAttribute("download", "transactions.csv");
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    });

    // PDF
    document.getElementById('downloadPDF').addEventListener('click', function() {
        const rows = getTableData();
        const {
            jsPDF
        } = window.jspdf;
        const doc = new jsPDF();

        doc.text("Transaction History", 14, 16);
        doc.autoTable({
            head: [
                ['Title', 'Date', 'Amount']
            ],
            body: rows,
            startY: 20,
            styles: {
                fontSize: 10
            }
        });

        doc.save("transactions.pdf");
    });
</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/user/transaction/history.blade.php ENDPATH**/ ?>