
<?php $__env->startSection('page_title', __('Dashboard')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item">
                                <a class="breadcrumb-link" href="javascript:void(0);">
                                    <?php echo app('translator')->get('Dashboard'); ?>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Profile Setting'); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get('Profile Setting'); ?></h1>
                </div>
            </div>
        </div>


        <div class="row d-flex justify-content-center">
            <div class="col-lg-9">
                <div class="d-grid gap-3 gap-lg-5">
                    <form action="<?php echo e(route("admin.profile.update")); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field("put"); ?>
                        <div>
                            <div class="profile-cover">
                                <div class="profile-cover-img-wrapper">
                                    <img id="profileCoverImg" class="profile-cover-img"
                                         src="<?php echo e(asset('assets/admin/img/img1.jpg')); ?>"
                                         alt="Image Description">
                                </div>
                            </div>

                            <label class="avatar avatar-xxl avatar-circle avatar-uploader profile-cover-avatar"
                                   for="editAvatarUploaderModal">
                                <img id="editAvatarImgModal" class="avatar-img"
                                     src="<?php echo e(getFile($admin->image_driver, $admin->image)); ?>"
                                     alt="Image Description">
                                <input type="file" class="js-file-attach avatar-uploader-input"
                                       id="editAvatarUploaderModal"
                                       name="image"
                                       data-hs-file-attach-options='{
                                    "textTarget": "#editAvatarImgModal",
                                    "mode": "image",
                                    "targetAttr": "src",
                                    "allowTypes": [".png", ".jpeg", ".jpg"]
                                 }'>
                                <span class="avatar-uploader-trigger">
                              <i class="bi-pencil-fill avatar-uploader-icon shadow-sm"></i>
                            </span>
                            </label>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h2 class="card-title h4"><?php echo app('translator')->get("Admin Information"); ?></h2>
                            </div>
                            <div class="card-body">
                                <div class="row mb-4">
                                    <label for="nameLabel"
                                           class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get("Name"); ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="name" id="nameLabel"
                                               placeholder="<?php echo app('translator')->get("Name"); ?>" aria-label="<?php echo app('translator')->get("Name"); ?>"
                                               value="<?php echo e(old("name", $admin->name)); ?>"
                                               autocomplete="off">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="row mb-4">
                                    <label for="userNameLabel"
                                           class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get("Username"); ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="username" id="userNameLabel"
                                               placeholder="<?php echo app('translator')->get("Username"); ?>" aria-label="<?php echo app('translator')->get("Username"); ?>"
                                               value="<?php echo e(old("username", $admin->username)); ?>" autocomplete="off">
                                        <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="row mb-4">
                                    <label for="emailLabel"
                                           class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get("Email"); ?></label>
                                    <div class="col-sm-9">
                                        <input type="email" class="form-control" name="email" id="emailLabel"
                                               placeholder="<?php echo app('translator')->get("Email"); ?>" aria-label="<?php echo app('translator')->get("Email"); ?>"
                                               value="<?php echo e(old("email", $admin->email)); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="row mb-4">
                                    <label for="phoneLabel"
                                           class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get("Phone"); ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="phone" id="phoneLabel"
                                               placeholder="<?php echo app('translator')->get("Phone"); ?>" aria-label="<?php echo app('translator')->get("Phone"); ?>"
                                               value="<?php echo e(old("phone", $admin->phone)); ?>" autocomplete="off">
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="row mb-4">
                                    <label for="addressLineLabel"
                                           class="col-sm-3 col-form-label form-label"><?php echo app('translator')->get("Address line"); ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="addressLine"
                                               id="addressLineLabel" placeholder="<?php echo app('translator')->get("Your address"); ?>"
                                               aria-label="<?php echo app('translator')->get("Your address"); ?>"
                                               value="<?php echo e(old("addressLine", $admin->address)); ?>" autocomplete="off">
                                        <?php $__errorArgs = ['addressLine'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("Save changes"); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                    <div id="passwordSection" class="card">
                        <div class="card-header">
                            <h4 class="card-title"><?php echo app('translator')->get("Change your password"); ?></h4>
                        </div>
                        <div class="card-body">
                            <form id="changePasswordForm" action="<?php echo e(route("admin.password.update")); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('put'); ?>
                                <div class="row mb-4">
                                    <label for="currentPasswordLabel" class="col-sm-3 col-form-label form-label">
                                        <?php echo app('translator')->get("Current password"); ?></label>
                                    <div class="col-sm-9">
                                        <input type="password" class="form-control" name="current_password"
                                               id="currentPasswordLabel" placeholder="<?php echo app('translator')->get("Enter current password"); ?>"
                                               aria-label="<?php echo app('translator')->get("Enter current password"); ?>">
                                        <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <label for="newPassword" class="col-sm-3 col-form-label form-label">
                                        <?php echo app('translator')->get("New password"); ?></label>
                                    <div class="col-sm-9">
                                        <input type="password" class="form-control" name="password"
                                               id="newPassword" placeholder="<?php echo app('translator')->get("Enter new password"); ?>"
                                               aria-label="<?php echo app('translator')->get("Enter new password"); ?>">
                                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row mb-4">
                                    <label for="confirmNewPassword" class="col-sm-3 col-form-label form-label">
                                        <?php echo app('translator')->get("Confirm new password"); ?></label>

                                    <div class="col-sm-9">
                                        <div class="mb-3">
                                            <input type="password" class="form-control" name="password_confirmation"
                                                   id="confirmNewPassword"
                                                   placeholder="<?php echo app('translator')->get("Confirm your new password"); ?>"
                                                   aria-label="<?php echo app('translator')->get("Confirm your new password"); ?>">
                                        </div>

                                        <?php if($basicControl->strong_password): ?>
                                            <h5><?php echo app('translator')->get("Password requirements:"); ?></h5>

                                            <p class="fs-6 mb-2"><?php echo app('translator')->get("Ensure that these requirements are met:"); ?></p>

                                            <ul class="fs-6">
                                                <li><?php echo app('translator')->get("Minimum 8 characters long - the more, the better"); ?></li>
                                                <li><?php echo app('translator')->get("At least one lowercase character"); ?></li>
                                                <li><?php echo app('translator')->get("At least one uppercase character"); ?></li>
                                                <li><?php echo app('translator')->get("At least one number, symbol, or whitespace character"); ?></li>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("Save Changes"); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>


                    <!-- Card -->
                    <div id="notificationsSection" class="card">
                        <div class="card-header">
                            <h4 class="card-title"><?php echo app('translator')->get("Notifications"); ?></h4>
                        </div>

                        <div class="card-body-height">
                            <form action="<?php echo e(route("admin.notification.permission")); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="alert alert-soft-dark card-alert text-center" role="alert">
                                    <?php echo app('translator')->get("We need permission from your browser to show notifications."); ?>
                                    <a class="alert-link" href="javascript:void(0)"><?php echo app('translator')->get("Request permission"); ?></a>
                                </div>
                                <div class="table-responsive datatable-custom">
                                    <table
                                        class="table table-thead-bordered table-nowrap table-align-middle table-first-col-px-0">
                                        <thead class="thead-light">
                                        <tr>
                                            <th><?php echo app('translator')->get("Type"); ?></th>
                                            <th class="text-center">
                                                <div class="mb-1">
                                                    <img class="avatar avatar-xs"
                                                         src="<?php echo e(asset("assets/admin/img/oc-email-at.svg")); ?>"
                                                         alt="Image Description" data-hs-theme-appearance="default">
                                                    <img class="avatar avatar-xs"
                                                         src="<?php echo e(asset("assets/admin/img/oc-email-at-light.svg")); ?>"
                                                         alt="Image Description" data-hs-theme-appearance="dark">
                                                </div>
                                                <?php echo app('translator')->get("Email"); ?>
                                            </th>

                                            <th class="text-center">
                                                <div class="mb-1">
                                                    <img class="avatar avatar-xs"
                                                         src="<?php echo e(asset("assets/admin/img/oc-message.svg")); ?>"
                                                         alt="Image Description" data-hs-theme-appearance="default">
                                                    <img class="avatar avatar-xs"
                                                         src="<?php echo e(asset("assets/admin/img/oc-message.svg")); ?>"
                                                         alt="Image Description" data-hs-theme-appearance="dark">
                                                </div>
                                                <?php echo app('translator')->get("SMS"); ?>
                                            </th>

                                            <th class="text-center">
                                                <div class="mb-1">
                                                    <img class="avatar avatar-xs"
                                                         src="<?php echo e(asset("assets/admin/img/oc-phone.svg")); ?>"
                                                         alt="Image Description" data-hs-theme-appearance="default">
                                                    <img class="avatar avatar-xs"
                                                         src="<?php echo e(asset("assets/admin/img/oc-phone-light.svg")); ?>"
                                                         alt="Image Description" data-hs-theme-appearance="dark">
                                                </div>
                                                <?php echo app('translator')->get("In-App"); ?>
                                            </th>

                                            <th class="text-center">
                                                <div class="mb-1">
                                                    <img class="avatar avatar-xs"
                                                         src="<?php echo e(asset("assets/admin/img/oc-globe.svg")); ?>"
                                                         alt="Image Description" data-hs-theme-appearance="default">
                                                    <img class="avatar avatar-xs"
                                                         src="<?php echo e(asset("assets/admin/img/oc-globe-light.svg")); ?>"
                                                         alt="Image Description" data-hs-theme-appearance="dark">
                                                </div>
                                                <?php echo app('translator')->get("Push"); ?>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo app('translator')->get($template->name); ?></td>
                                                <td class="text-center">
                                                    <div class="form-check form-check-inline">
                                                        <input type="hidden" name="templates[<?php echo e($template->id); ?>][mail]"
                                                               value="0">
                                                        <input class="form-check-input" type="checkbox"
                                                               name="templates[<?php echo e($template->id); ?>][mail]"
                                                               value="1"
                                                               id="emailAlertCheckbox<?php echo e($template->id); ?>" <?php echo e($template->status['mail'] ? 'checked' : ''); ?>>
                                                        <label class="form-check-label"
                                                               for="emailAlertCheckbox<?php echo e($template->id); ?>"></label>
                                                    </div>
                                                </td>

                                                <td class="text-center">
                                                    <div class="form-check form-check-inline">
                                                        <input type="hidden" name="templates[<?php echo e($template->id); ?>][sms]"
                                                               value="0">
                                                        <input class="form-check-input" type="checkbox"
                                                               name="templates[<?php echo e($template->id); ?>][sms]" value="1"
                                                               id="smsAlertCheckbox<?php echo e($template->id); ?>" <?php echo e($template->status['sms'] ? 'checked' : ''); ?>>
                                                        <label class="form-check-label"
                                                               for="smsAlertCheckbox<?php echo e($template->id); ?>"></label>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div class="form-check form-check-inline">
                                                        <input type="hidden" name="templates[<?php echo e($template->id); ?>][in_app]"
                                                               value="0">
                                                        <input class="form-check-input" type="checkbox"
                                                               name="templates[<?php echo e($template->id); ?>][in_app]"
                                                               value="1"
                                                               id="inAppAlertCheckbox<?php echo e($template->id); ?>" <?php echo e($template->status['in_app'] ? 'checked' : ''); ?>>
                                                        <label class="form-check-label"
                                                               for="inAppAlertCheckbox<?php echo e($template->id); ?>"></label>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <div class="form-check form-check-inline">
                                                        <input type="hidden" name="templates[<?php echo e($template->id); ?>][push]"
                                                               value="0">
                                                        <input class="form-check-input" type="checkbox"
                                                               name="templates[<?php echo e($template->id); ?>][push]"
                                                               value="1"
                                                               id="pushAlertCheckbox<?php echo e($template->id); ?>" <?php echo e($template->status['push'] ? 'checked' : ''); ?>>
                                                        <label class="form-check-label"
                                                               for="pushAlertCheckbox<?php echo e($template->id); ?>"></label>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <div class="text-center p-4">
                                                <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image Description" data-hs-theme-appearance="default">
                                                <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image Description" data-hs-theme-appearance="dark">
                                                <p class="mb-0"><?php echo app('translator')->get("No data to show"); ?></p>
                                            </div>
                                        </tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer">
                                    <div class="d-flex justify-content-end">
                                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("Save changes"); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>


                    </div>



                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset("assets/admin/js/hs-file-attach.min.js")); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush("script"); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            new HSFileAttach('.js-file-attach')
        })
    </script>
<?php $__env->stopPush(); ?>












<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/profile.blade.php ENDPATH**/ ?>