
<?php $__env->startSection('page_title', __('Email Configuration')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-no-gutter">
                            <li class="breadcrumb-item"><a class="breadcrumb-link"
                                                           href="<?php echo e(route('admin.dashboard')); ?>"><?php echo app('translator')->get("Dashboard"); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get("Settings"); ?></li>
                            <li class="breadcrumb-item active"
                                aria-current="page"><?php echo app('translator')->get("Email Configuration"); ?></li>
                        </ol>
                    </nav>
                    <h1 class="page-header-title"><?php echo app('translator')->get(ucfirst($method) . " Configuration"); ?></h1>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-3">
                <?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.email'), 'suffix' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-lg-9 seo-setting">
                <div class="d-grid gap-3 gap-lg-5">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <h2 class="card-title h4"><?php echo app('translator')->get(ucfirst($method) . " Configuration"); ?></h2>
                            <a class="btn btn-primary" href="javascript:void(0)"
                               data-bs-toggle="modal"
                               data-bs-target="#testEmailModal">
                                <i class="fa-light fa-envelope"></i> <?php echo app('translator')->get('Test Mail'); ?>
                            </a>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('admin.email.config.update', $method)); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row mb-4">
                                    <div class="col-sm-6">
                                        <label for="mailFromLabel" class="form-label"><?php echo app('translator')->get('Sender Email'); ?></label>
                                        <input type="email"
                                               class="form-control  <?php $__errorArgs = ['sender_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="sender_email" id="mailFromLabel" autocomplete="off"
                                               placeholder="Sender Email" aria-label="Sender Email"
                                               value="<?php echo e(old('sender_email', env('MAIL_FROM_ADDRESS'))); ?>">
                                        <?php $__errorArgs = ['sender_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="mailFromLabel" class="form-label"><?php echo app('translator')->get('Email Method'); ?></label>
                                        <input type="text"
                                               class="form-control  <?php $__errorArgs = ['email_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                               name="email_method" id="mailFromLabel" autocomplete="off"
                                               placeholder="Email Method" aria-label="Email Method"
                                               value="<?php echo e(old('email_method', $method)); ?>" readonly>
                                        <?php $__errorArgs = ['email_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="row">
                                    <?php $__currentLoopData = $mailParameters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $parameter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-sm-6 mb-3">
                                            <label for="<?php echo app('translator')->get($key); ?>"
                                                   class="form-label"><?php echo e(__(snake2Title($key))); ?></label>
                                            <div class="input-group input-group-merge"
                                                 data-hs-validation-validate-class>
                                                <input type="<?php echo e($parameter['is_protected'] ? 'password' : 'text'); ?>"
                                                       id="<?php echo e($key); ?>"
                                                       class="js-toggle-password form-control <?php $__errorArgs = [$key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="<?php echo e($key); ?>" placeholder="<?php echo app('translator')->get(snake2Title($key)); ?>" value="<?php echo e(old($key ,$parameter['value'])); ?>"/>
                                                <?php if($parameter['is_protected']): ?>
                                                    <button type="button" id="<?php echo e($key); ?>" class="input-group-append input-group-text clickShowPassword">
                                                        <i class="bi-eye-slash"></i>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                            <?php $__errorArgs = [$key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback d-block"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="row mb-2">
                                    <div class="col-sm-12">
                                        <div class="list-group list-group-lg list-group-flush list-group-no-gutters">
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span
                                                                    class="d-block text-dark"><?php echo app('translator')->get("Email Notification"); ?></span>
                                                                <p class="fs-5 text-body mb-0"><?php echo app('translator')->get("If you want to request the user to enable email notifications through a direct message."); ?></p>
                                                            </div>
                                                            <div class="col-auto">
                                                                <div class="form-check form-switch">
                                                                    <input type='hidden' value='0'
                                                                           name='email_notification'>
                                                                    <input
                                                                        class="form-check-input <?php $__errorArgs = ['email_notification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                        type="checkbox"
                                                                        name="email_notification"
                                                                        id="emailNotificationLabel"
                                                                        value="1" <?php echo e($basicControl->email_notification == 1 ? 'checked' : ""); ?>>
                                                                    <label class="form-check-label"
                                                                           for="emailNotificationLabel"></label>
                                                                    <?php $__errorArgs = ['email_notification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- List Item -->
                                            <div class="list-group-item">
                                                <div class="d-flex">
                                                    <div class="flex-grow-1">
                                                        <div class="row align-items-center">
                                                            <div class="col">
                                                                <span
                                                                    class="d-block text-dark"><?php echo app('translator')->get("Email Verification"); ?></span>
                                                                <p class="fs-5 text-body mb-0"><?php echo app('translator')->get("If you're referring to sending an email for email verification during user registration or account setup."); ?></p>
                                                            </div>
                                                            <div class="col-auto">
                                                                <div class="form-check form-switch">
                                                                    <input type='hidden' value='0'
                                                                           name='email_verification'>
                                                                    <input
                                                                        class="form-check-input <?php $__errorArgs = ['email_verification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                        type="checkbox"
                                                                        name="email_verification"
                                                                        id="emailVerificationLabel"
                                                                        value="1" <?php echo e($basicControl->email_verification == 1 ? 'checked' : ""); ?>>
                                                                    <label class="form-check-label"
                                                                           for="emailVerificationLabel"></label>
                                                                    <label class="form-check-label"
                                                                           for="email_verification"></label>
                                                                    <?php $__errorArgs = ['email_verification'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-start">
                                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save changes'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Test Mail Modal -->
    <div class="modal fade" id="testEmailModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="exampleModalLabel"><?php echo app('translator')->get('Test Mail'); ?></h3>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="post" action="<?php echo e(route('admin.test.email')); ?>" class="" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="email" class="form-control form-control" name="email" id="email"
                               placeholder="<?php echo app('translator')->get('Enter Your Email'); ?>" autocomplete="off">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-white" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Send'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Modal -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(document).on('click', '.clickShowPassword', function () {
            let passInput = $(this).closest('.input-group-merge').find('input');
            if (passInput.attr('type') === 'password') {
                $(this).children().removeClass('bi-eye-slash');
                $(this).children().addClass('bi-eye');
                passInput.attr('type', 'text');
            } else {
                $(this).children().removeClass('bi-eye');
                $(this).children().addClass('bi-eye-slash');
                passInput.attr('type', 'password');
            }
        })
    </script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/email_controls/email_config.blade.php ENDPATH**/ ?>