
<!-- pricing -->
<section class="pricing">
    <div class="container">
        <div class="common-title text-center">
            <h6><?php echo e($pricing_section['single']['title']??''); ?></h6>
            <h3> <?php echo styleSentence2($pricing_section['single']['sub_title']??'',1); ?> </h3>
        </div>
        <div class="row g-4">
            <?php $__currentLoopData = $pricing_section['investmentPlans']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="pricing-single">
                        <h4> <?php echo app('translator')->get($plan->plan_name); ?> </h4>
                        <p><?php echo app('translator')->get($plan->short_description); ?></p>
                        <h3><?php echo e($plan->investAmount()); ?> /<sub>( <?php echo e($plan->getPlanPeriod()); ?> )</sub></h3>
                        <a href=""
                           onclick="event.preventDefault()"
                           data-id="<?php echo e($plan->id); ?>"
                           data-plan="<?php echo e($plan->plan_name); ?>"
                           data-invest="<?php echo e($plan->investAmount()); ?>"
                           data-profit="<?php echo e($plan->getProfit()); ?>"
                           data-period="<?php echo e($plan->getReturnPeriod()); ?>"
                           data-return_number="<?php echo e($plan->number_of_profit_return??'Lifetime Earning'); ?>"
                           class="btn-1 myBtn"> <?php echo app('translator')->get('Get Started'); ?> <i class="fa-regular fa-arrow-right"></i></a>
                        <div class="pricing-list">
                            <ul>
                                <?php echo $plan->getDescription(); ?>

                            </ul>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- The Modal -->
    <div id="myModal" class="modal">
        <!-- Modal content -->
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5><?php echo app('translator')->get('Invest Now'); ?></h5>
                    <span class="close">&times;</span>
                </div>
                <div class="modal-body plan-modal">
                    <h4 id="PlanName" class="text-center"></h4>
                    <p class="price-range text-center mb-1"></p>
                    <p class="profit-details text-center mb-1"></p>
                    <p class="profit-validity text-center mb-2"></p>
                    <p class="number_of_return text-center mb-2"></p>
                    <form action="<?php echo e(route('user.investPlan')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row g-3 mt-2">
                            <div class="col-12">
                                <select class="nice-select" aria-label="Default select example" name="balance_type">
                                    <?php if(auth()->guard()->check()): ?>
                                        <option
                                            value="balance"><?php echo app('translator')->get('Wallet Balance -'); ?> <?php echo e(currencyPosition(auth()->guard('web')->user()->balance)); ?></option>
                                        <option
                                            value="profit"><?php echo app('translator')->get('Profit Balance -'); ?> <?php echo e(currencyPosition(auth()->guard('web')->user()->profit_balance)); ?></option>
                                    <?php endif; ?>
                                    <option value="checkout"><?php echo app('translator')->get('Checkout'); ?></option>
                                </select>
                            </div>
                            <div class="col-12">
                                <div class="input-group">
                                    <input type="text" class="form-control invest-amount" name="amount" id="amount"
                                           value="<?php echo e(old('amount')); ?>"
                                           onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" autocomplete="off"
                                           placeholder="<?php echo app('translator')->get('Enter amount'); ?>"/>
                                    <span class="input-group-text show-currency bg-white"><?php echo e(basicControl()->currency_symbol); ?></span>
                                </div>
                            </div>
                            <input type="hidden" name="plan_id" class="plan-id">
                            <button type="submit" class="btn-1 d-flex justify-content-center align-items-center text-center planPurchaseSubmitButton"><?php echo app('translator')->get('Make Payment'); ?> <span></span></button>
                        </div>
                    </form>

                </div>
            </div>
        </div>

    </div>
</section>
<!-- pricing -->


<?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/sections/pricing_section.blade.php ENDPATH**/ ?>