<link href="<?php echo e(asset(template(true).'css/module-css/payment.css')); ?>?v=<?php echo e(time()); ?>" rel="stylesheet">

<?php $__env->startSection('title',trans('Payment')); ?>

<?php $__env->startPush('style'); ?>

<style>
    #header, #sidebar, .header-mining {
        display: none !important;
    }

    #main {
        margin-top: 0px;
    }

    #main, #footer,
    #main.collapsed-main, #footer.collapsed-footer {
        margin-left: 0px !important;
    }

    .payment {

        background: var(--bg-13) !important;

    }

    .payment-list {

        height: unset !important;

    }

    .payment-list .form-check-label {

        background-color: #0f3246 !important;
        border-radius: 12px;

    }

    .primary-button {

        width: 100%;
        border-radius: 8px;
        text-align: center;
        justify-content: center;
        background: linear-gradient(90deg, #03228F 0%, #0E73E4 100%);
        border: none;
        padding: 9px 20px;
        font-size: 14px;
        text-transform: capitalize;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        color: #ffffff;
        position: relative;
        overflow: hidden;
        z-index: 1;
        transition: .5s;

    }

    .payment-list .item {

        width: 100% !important;
        margin: 0 10px;

    }

    .payment-list .form-check-input {

        visibility: hidden;

    }

    .plan-details {

        background: #0f3246;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        border-radius: 12px;
        border: 1px solid #195273;

    }

    .modal .modal-content {
        
        background: #0f3246;

    }

    .paymentModal {
        display: block !important;
    }
</style>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<section class="payment">

    <div class="container">

        <form action="<?php echo e(route('user.plan.purchase.request')); ?>" method="post">

            <?php echo csrf_field(); ?>

            <h3 class="payment-title text-center">Select payment</h3>

            <p class="text-center mb-5">We accept these form of payments</p>

            <div class="d-flex justify-content-center">

                <div class="plan-details col-12 col-lg-5 mb-5 p-4">

                    <img class="mb-2" style="width: 50px;height: 50px;" src="<?php echo e(asset(template(true).'images/custom/thunder-icon.svg')); ?>" alt="thunder Icon" />

                    <h4 class="mb-2 text-center"><?php echo e($plan_detail->plan_name); ?></h4>

                    <h5 class="mb-2"><strong><?php echo e(number_format($plan_detail->plan_price, 2)); ?></strong> x <?php echo e($quantity); ?> unit(s)</h5>

                    <span>For <?php echo e($plan_detail->plan_period); ?> <?php echo e($plan_detail->plan_period_type); ?>(s)</span>

                </div>

            </div>

            <div class="row d-flex justify-content-center">

                <div class="col-12 col-lg-10">

                    <div class="payment-box">

                        <ul class="payment-list d-flex flex-column flex-md-row justify-content-md-between align-items-center">

                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <li class="item <?php echo e($method->name == 'CoinPayments' ? '' : ''); ?>">

                                <label class="form-check-label w-100" for="<?php echo e($method->name); ?>">

                                    <input class="form-check-input selectPayment"

                                        value="<?php echo e($method->id); ?>" type="radio"

                                        name="gateway_id"

                                        id="<?php echo e($method->name); ?>"

                                        <?php echo e($method->name == 'CoinPayments' ? 'checked' : ''); ?>>

                                    <div class="d-flex flex-column" style="width: 100%;">

                                        <span class="payment-list-content d-flex justify-content-center">

                                            <!-- <span class="payment-list-image">

                                                <img src="<?php echo e(getFile($method->driver,$method->image )); ?>" alt="image">

                                            </span> -->

                                            <span class="payment-list-info">

                                                <span class="payment-list-title"><?php echo e($method->name == 'CoinPayments' ? 'Pay with USDT' : 'Pay with Credit Card or E-Payment'); ?></span>

                                                <!-- <p class="my-2"><?php echo e($method->name); ?></p> -->

                                                <!-- <span class="payment-list-text"><?php echo e($method->description); ?></span> -->

                                            </span>

                                        </span>

                                        <span class="payment-list-content">

                                            <button type="button" class="pay-now primary-button">Pay Now</button>

                                        </span>

                                    </div>

                                </label>

                            </li>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>

                    </div>

                </div>



                <div class="col-md-12 col-lg-5 d-none">

                    <div class="payment-side-bar">

                        <div class="payment-side-box border border-white" id="GatewayForm">

                            <label class="text-white"><?php echo app('translator')->get('Select Currency'); ?></label>

                            <select class="selectpicker nice-select" name="supported_currency" id="supported_currency">



                            </select>



                            <span class="d-block text-danger errorMessage"></span>

                        </div>

                        <div class="payment-side-box border border-white payment-summary">

                            <h5><?php echo app('translator')->get('Payment Summary'); ?></h5>

                            <div class="payment-summary-list">

                                <ul class="showCharge">



                                </ul>

                            </div>

                        </div>

                        <button type="submit" class="primary-button"><?php echo app('translator')->get('Make Payment'); ?> <span></span></button>

                    </div>

                </div>

            </div>



            <div class="paymentModal">

                <!-- Modal section start -->

                <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false"

                    tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">

                    <div class="modal-dialog modal-dialog-centered">

                        <div class="modal-content">

                            <div class="modal-header border-0">

                                <h4 class="modal-title" id="staticBackdropLabel"><?php echo app('translator')->get('Payment'); ?></h4>

                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                            </div>

                            <div class="modal-body" id="paymentModalBody">





                            </div>

                        </div>

                    </div>

                </div>

                <!-- Modal section end -->

            </div>



        </form>

    </div>

    <!-- <ul>
        <li>

            <?php echo e(__('Amount In')); ?> ${response.currency}

            <span> ${response.amount} ${response.currency}</span>

            </li>



            <li >

            <?php echo e(__('Charge')); ?>


            <span>  ${response.charge} ${response.currency}</span>

            </li>





            <li >

            <?php echo e(__('Payable Amount')); ?>


            <span> ${response.payable_amount} ${response.currency}</span>

            </li>



            <li >

            <span><?php echo e(__('Payable Amount')); ?> <sub>(In Base Currency)</sub></span>

            <span> ${response.amount_in_base_currency} ${currency}</span>

            </li>
    </ul> -->

</section>

<!-- payment -->



<?php $__env->stopSection(); ?>



<?php $__env->startPush('style'); ?>

<style>
    .main-footer-padding {

        padding-top: 60px;

    }
</style>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>

<script>
    var gateway_id = null;

    $(document).on('click', '.selectPayment', function() {


        $('#paymentModalBody').html('');



        let updatedWidth = window.innerWidth;

        window.addEventListener('resize', () => {

            updatedWidth = window.innerWidth;

        });



        let html = `<div class="payment-side-box border border-white" id="GatewayForm">

                        <label class="text-white"><?php echo app('translator')->get('Select Currency'); ?></label>

                        <select class="selectpicker nice-select" name="supported_currency" id="supported_currency">



                        </select>



                        <span class="d-block text-danger errorMessage"></span>

                    </div>

                    <div class="payment-side-box border border-white payment-summary">

                        <h5><?php echo app('translator')->get('Payment Summary'); ?></h5>

                        <div class="payment-summary-list">

                            <ul class="showCharge">



                            </ul>

                        </div>

                    </div>

                    <button type="submit" class="primary-button"><?php echo app('translator')->get('Make Payment'); ?> <span></span></button>`;



        if (updatedWidth <= 991) {

            $('.payment-side-bar').html('');

            $('#paymentModalBody').html(html);

            let paymentModal = new bootstrap.Modal(document.getElementById('staticBackdrop'));

            paymentModal.show()

        } else {

            $('.payment-side-bar').html(html)

        }

        let id = $(this).val();

        gateway_id = id;

        supportCurrency(id)

    })



    $(document).on('click', '.pay-now', function () {

        // Find the closest label (which wraps the input)
        const $label = $(this).closest('label');

        // Find the radio input inside that label and select it
        $label.find('input[type="radio"]').prop('checked', true).trigger('change');

        $('#paymentModalBody').html('');



        let updatedWidth = window.innerWidth;

        window.addEventListener('resize', () => {

            updatedWidth = window.innerWidth;

        });



        let html = `<div class="payment-side-box border border-white" id="GatewayForm">

                        <label class="text-white"><?php echo app('translator')->get('Select Currency'); ?></label>

                        <select class="selectpicker nice-select" name="supported_currency" id="supported_currency">



                        </select>



                        <span class="d-block text-danger errorMessage"></span>

                    </div>

                    <div class="payment-side-box border border-white payment-summary">

                        <h5><?php echo app('translator')->get('Payment Summary'); ?></h5>

                        <div class="payment-summary-list">

                            <ul class="showCharge">



                            </ul>

                        </div>

                    </div>

                    <button type="submit" class="primary-button"><?php echo app('translator')->get('Make Payment'); ?> <span></span></button>`;



        // if (updatedWidth <= 991) {

        //     $('.payment-side-bar').html('');

        //     $('#paymentModalBody').html(html);

        //     let paymentModal = new bootstrap.Modal(document.getElementById('staticBackdrop'));

        //     paymentModal.show()

        // } else {

        //     $('.payment-side-bar').html(html)

        // }

        $('.payment-side-bar').html('');

        $('#paymentModalBody').html(html);

        let paymentModal = new bootstrap.Modal(document.getElementById('staticBackdrop'));

        paymentModal.show();

        let id = $label.find('input[type="radio"]').val();

        gateway_id = id;

        supportCurrency(id);

    });



    function supportCurrency(selectedGateway) {

        if (!selectedGateway) {

            console.error('Selected Gateway is undefined or null.');

            return;

        }

        $.ajax({

            url: "<?php echo e(route('supported.currency')); ?>",

            data: {
                gateway: selectedGateway
            },

            type: "GET",

            success: function(response) {

                $('#supported_currency').empty();

                if (response.data === "") {

                    $('#supported_currency').attr('name', 'supported_currency');

                    let markup = `<option value="USD">USD</option>`;

                    $('#supported_currency').append(markup);

                }

                if (response.currencyType == 1) {

                    $('#supported_currency').attr('name', 'supported_currency');

                    // let markup = '<option value="">Selected Currency</option>';

                    // $('#supported_currency').append(markup);

                    $(response.data).each(function(index, value) {

                        let markup = `<option value="${value}">${value}</option>`;

                        $('#supported_currency').append(markup);

                    });

                    if (response.data.length > 0) {

                        $('#supported_currency').val(response.data[0]).trigger('change');

                    }

                }

                if (response.currencyType == 0) {

                    $('#supported_currency').attr('name', 'supported_crypto_currency');

                    let markup2 = '<option value="">Select Crypto Currency</option>';

                    $('#supported_currency').append(markup2);

                    $(response.data).each(function(index, value) {

                        let markupOption = `<option value="${value}">${value}</option>`;

                        $('#supported_currency').append(markupOption);

                    });

                }

                $('.nice-select').niceSelect('update');



            },

            error: function(error) {

                console.error('AJAX Error:', error);

            }

        })

    }



    $(document).on('change', '#supported_currency', function() {

        if ($(this).attr('name') == 'supported_currency') {

            checkAmount($(this).val(), null);

        } else {

            checkAmount(null, $(this).val());

        }

    })



    function checkAmount(currency, cryptoCurrency) {

        let amount = '<?php echo e($amount); ?>';

        $.ajax({

            method: 'GET',

            url: "<?php echo e(route('payment.checkAmount')); ?>",

            dataType: "json",

            data: {

                'amount': amount,

                'selected_currency': currency,

                'select_gateway': gateway_id,

                'selectedCryptoCurrency': cryptoCurrency,

            },

            success: function(response) {

                console.log(response);

                $('.errorMessage').text('')

                if (response.status) {

                    let base_currency = "<?php echo e(basicControl()->base_currency); ?>"

                    showCharge(response, base_currency);

                } else {

                    $('.errorMessage').text(response.message)

                    // console.log(response);

                }

            }

        })

    }



function showCharge(response, currency) {
    let txnDetails = `
        <li>
            <?php echo e(__('Payable Amount')); ?>

            <span> ${Number(response.amount).toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                })} ${response.currency}
            </span>
        </li>
        <li>
            <?php echo e(__('Merchant Fee')); ?>

            <span> ${Number(response.charge).toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                })} ${response.currency}
            </span>
        </li>
        <li>
            <?php echo e(__('Total Payable Amount')); ?>

            <span> ${Number(response.payable_amount).toLocaleString(undefined, {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                })} ${response.currency}
            </span>
        </li>
    `;

    $('.showCharge').html(txnDetails);
}

</script>

<?php $__env->stopPush(); ?>





<?php $__env->startPush('style'); ?>

<style>
    .modal-backdrop {

        opacity: 0 !important;

        z-index: 0 !important;

    }

    .paymentModal {

        display: block !important;

    }

    .paymentModal .payment-side-box {

        display: flex !important;

        flex-direction: column !important;

    }

    .paymentModal .payment-side-box label {

        margin-bottom: 4px !important;

    }

    @media only screen and (max-width: 991px) {

        .payment-side-bar {

            display: none;

        }

    }



    @media screen and (max-width: 420px) {

        .payment-list-text {

            opacity: .7;

            font-size: 15px;

            font-weight: 500;

            line-height: normal;

            margin-top: 7px;

            margin-bottom: 25px;

            display: -webkit-box;

            -webkit-line-clamp: 2;

            -webkit-box-orient: vertical;

            overflow: hidden;

        }

    }
</style>

<?php $__env->stopPush(); ?>
<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/pages/payment.blade.php ENDPATH**/ ?>