<!DOCTYPE html>

<html lang="en">



<head>

    <meta charset="utf-8">

    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


    <meta name="theme-color" content="<?php echo e(basicControl()->primary_color); ?>">
    <meta name="description" content="PetaRigs offers cutting-edge cryptocurrency mining services including machine leasing, hash rate rental, NFT mining representation, and hosting. Efficient, scalable, and built for long-term returns.">
    <meta name="keywords" content="crypto mining, hash rate rental, mining hosting, NFT mining, PetaRigs">
    <meta name="author" content="PetaRigs">

    <title>PetaRigs Crypto Mining Solutions</title>

    <meta property="og:type" content="website">

    <meta property="og:site_name" content="Petarigs">

    <meta property="og:title" content="PetaRigs Crypto Mining Solutions">

    <meta property="og:description" content="PetaRigs offers cutting-edge cryptocurrency mining services including machine leasing, hash rate rental, NFT mining representation, and hosting. Efficient, scalable, and built for long-term returns.">

    <meta property="og:image" content="https://app.petarigs.com/project/assets/upload/logo/petarigs-logo.png">



    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="PetaRigs Crypto Mining Solutions">
    <meta name="twitter:description" content="PetaRigs offers cutting-edge cryptocurrency mining services including machine leasing, hash rate rental, NFT mining representation, and hosting. Efficient, scalable, and built for long-term returns.">
    <meta name="twitter:image" content="https://app.petarigs.com/project/assets/upload/logo/petarigs-logo.png">
    <meta name="twitter:site" content="@petarigs"> 
    <meta name="twitter:creator" content="@petarigs"> 


    <!-- Favicons -->

    <link href="<?php echo e(getFile(basicControl()->favicon_driver, basicControl()->favicon)); ?>" rel="icon">

    <title>Petarigs</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">

    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@200..800&display=swap" rel="stylesheet">

    <!-- Stylesheets -->

    <link href="<?php echo e(asset(template(true).'css/style.css')); ?>?v=<?php echo e(time()); ?>" rel="stylesheet">

    <!-- Custom CSS -->

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/user-style.css')); ?>?v=<?php echo e(time()); ?>" />

    <link
    rel="stylesheet"
    href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"
    />

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" integrity="sha384-tViUnnbYAV00FLIhhi3v/dWt3Jxw4gZQcNoSCxCIFNJVCx7/D55/wXsrNIRANwdD" crossorigin="anonymous">

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
 
    <?php echo $__env->yieldPushContent('style'); ?>

    <?php echo $__env->yieldPushContent('css-lib'); ?>

    

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap');

        h1, h2, h3, h4, h5 {
            font-family: "Montserrat", sans-serif;
        }

        .main-header .header-lower {

            position: relative;

            background-color: white;

            box-shadow: 1px 1px 8px rgba(0, 0, 0, 0.1);

        }

        .fixed-header .sticky-header {

            background-color: white;

        }

        .mobile-menu .menu-box {
            background: white;
        }

        .mobile-menu .navigation li {
            padding: 0.4rem 1.2rem;
            font-weight: 700;
        }

        .loader-wrap {

            display: flex;

            justify-content: center;

            align-items: center;

            height: 100vh;

            background-color: #fff;

        }

        .preloader {

            display: flex;

            justify-content: center;

            align-items: center;

        }

        .loader {

            width: 3px;

            height: 40px;

            background: #000;

            animation: loading 1s infinite ease-in-out;

        }

        
        @media (min-width: 1200px) and (max-width: 1300px) {
            /* .headed-center-column,
            .header-right-column {
                width: 92.5% !important;
            } */

            .headed-center-column, .header-right-column {
                width: 93% !important;
            }

            /* .logo-box {
                margin-top: 15px !important;
            } */

            .logo-img {
                margin-top: -4px !important;
            }

            .main-menu .navigation { 
                justify-content: space-between;
            }
        }

        @media (min-width: 1300px) {
            .logo-img {
                width: auto;
                height: 80px !important; 
            }

            .logo {
                max-width: unset;
            }

            .logo-box {
                margin-top: 0px !important;
            }

            .main-menu .navigation { 
                justify-content: end;
            }
        }

        /* .logo-box {
            margin: 5px 0;
        } */

        @keyframes loading {

            0%,
            100% {

                transform: scaleY(1);

            }

            50% {

                transform: scaleY(2);

            }

        }
    </style>

</head>



<body>

    <div class="page-wrapper">

        <!-- preloader -->

        <div class="loader-wrap">

            <div class="preloader">

                <div class="preloader-close">x</div>

                <div id="handle-preloader" class="handle-preloader">

                    <div class="animation-preloader">

                        <div class="loader"></div>

                    </div>

                </div>

            </div>

        </div>

        <!-- preloader end -->



        <?php echo $__env->make(template().'partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



        <?php echo $__env->make(template().'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->yieldContent('content'); ?>



        <footer id="footer" class="main-footer footer-two ms-0 p-0">
            <div class="footer-container d-flex flex-column flex-lg-row gap-4 justify-content-start mb-5">
                <div class="container">
                    <div class="row">
                        <!-- Company Info -->
                        <div class="company-info col-lg-4 pe-0 mb-5 mb-md-0">
                            <img src="<?php echo e(asset('assets/themes/light/images/icons/petarigs-logo.svg')); ?>" />
                            <p class="text-white mt-4 me-lg-3">
                                PetaRigs is a cutting-edge cryptocurrency mining company dedicated to harnessing 
                                the power of advanced technology to provide efficient, scalable and sustainable 
                                mining solutions for a wide range of digital currencies.
                            </p>
                        </div>

                        <!-- Quick Links -->
                        <div class="quick-links mb-2 mb-md-0 col-lg-4 mb-5 mb-md-0">
                            <h5 class="mb-3 mb-md-4">Quick Links</h5>
                            <ul class="list-unstyled d-flex flex-wrap">
                                <li><a href="https://petarigs.com/" class="text-white text-decoration-none">Home</a></li>
                                <li><a href="https://petarigs.com/about-us/" class="text-white text-decoration-none">About Us</a></li>
                                <li><a href="https://petarigs.com/services/" class="text-white text-decoration-none">What We Do</a></li>
                                <li><a href="https://app.petarigs.com/project/index.php" class="text-white text-decoration-none">Products</a></li>
                                <li><a href="https://petarigs.com/faq/" class="text-white text-decoration-none">FAQ</a></li>
                                <li><a href="https://petarigs.com/contact-us/" class="text-white text-decoration-none">Contact Us</a></li>
                            </ul>
                        </div>

                        <!-- Get In Touch -->
                        <div class="get-in-touch mb-5 mb-md-0 col-lg-4">
                            <h5 class="mb-3 mb-md-4">Get In Touch</h5>
                            <div class="d-flex align-items-start mb-3">
                                <!-- <img width="20" class="mt-1" src="<?php echo e(asset('assets/themes/light/images/icons/MapIcon.svg')); ?>" /> -->
                                <div class="pt-1">
                                    <i class="fas fa-map skew-icon fa-lg"></i>
                                </div>
                                <p class="m-0 text-white ms-3">
                                    L-18-07, PJX-HM Shah Tower,<br>
                                    No. 16A Persiaran Barat,<br>
                                    46050 Petaling Jaya                                                                                                       
                                </p>
                            </div>
                            <!-- <div class="d-flex align-items-center">
                                <img width="20" src="<?php echo e(asset('assets/themes/light/images/icons/TelephoneIcon.svg')); ?>" />
                                <p class="text-white mb-1 ms-3"><a href="tel:(+880)155 69569 365">(+880)155 69569 365</a></p>
                            </div> -->
                            <div class="d-flex align-items-center">
                                <!-- <img width="20" src="<?php echo e(asset('assets/themes/light/images/icons/EmailIcon.svg')); ?>" /> -->
                                <i class="fas fa-envelope skew-icon fa-lg"></i>
                                <p class="text-white mb-1 ms-3"><a href="mail:support@petarigs.com">support@petarigs.com</a></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="footer-bottom">
                <div class="container-fluid">
                    <div class="row">  
                        <div class="col-md-12 col-sm-12">
                            <div class="copyright text-center" style="padding: 0px">
                                <p>© 2025 PetaRigs. All Rights Reserved.</p>
                            </div>
                        </div> 
                    </div>
                </div>
            </div>      
        </footer>

    </div>



    <?php echo $__env->make(template().'partials.cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <!--Scroll to top-->

    <div class="scroll-to-top">

        <div>

            <div class="scroll-top-inner">

                <div class="scroll-bar">

                    <div class="bar-inner"></div>

                </div>

                <div class="scroll-bar-text"><?php echo app('translator')->get('Go To Top'); ?></div>

            </div>

        </div>

    </div>

    <!-- Scroll to top end -->



    <script src="<?php echo e(asset('assets/global/js/jquery.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/bootstrap.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/select2.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/jquery.nice-select.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/appear.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/wow.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/owl.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/TweenMax.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/odometer.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/swiper.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/parallax-scroll.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/jarallax.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/jquery.paroller.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/jquery.magnific-popup.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/isotope.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/flatpickr-min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/socialSharing.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/nouislider.min.js')); ?>"></script>

    <script src="<?php echo e(asset(template(true).'js/script.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/global/js/axios.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/global/js/notiflix-aio-3.2.6.min.js')); ?>"></script>

    <?php echo $__env->make(template().'partials.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="<?php echo e(asset(template(true).'js/order.js')); ?>"></script>



    <?php echo $__env->yieldPushContent('js-lib'); ?>



    <?php echo $__env->yieldPushContent('script'); ?>

    

    <?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>





    <script>
        $(document).ready(function() {

            // Get the modal

            var $modal = $("#myModal");



            // When the user clicks the button, open the modal

            $(document).on('click', '.myBtn', function() {

                $modal.show();

            });



            // When the user clicks on <span> (x), close the modal

            $(document).on('click', '.close', function() {

                $modal.hide();

            }); 



            // When the user clicks the close button in the footer, close the modal

            $(document).on('click', '.close-modal', function() {

                $modal.hide();

            });



            // When the user clicks anywhere outside of the modal, close it

            $(window).on('click', function(event) {

                if ($(event.target).is($modal)) {

                    $modal.hide();

                }

            });

        });



        $(document).on('click', '.planPurchaseSubmitButton', function() {

            $(this).attr('disabled', true);

            $('#myModal').hide();

            setTimeout(() => {

                $(this).closest('form').submit();

            }, 200);

        })



        $(document).on('click', '.myBtn', function() {

            let plan = $(this).data('plan');

            let invest = $(this).data('invest');

            let profit = $(this).data('profit');

            let period = $(this).data('period');

            $('#PlanName').text(plan);

            $('.price-range').text('Invest : ' + invest);

            $('.profit-details').text('Profit : ' + profit);

            $('.profit-validity').text('Return Period : ' + period)

            $('.plan-id').val($(this).data('id'));

            $('.number_of_return').text('Number of Return : ' + $(this).data('return_number'));



        })
    </script>





    <script>
        "use strict";

        var root = document.querySelector(':root');

        root.style.setProperty('--primary', '<?php echo e(basicControl()->primary_color); ?>');

        root.style.setProperty('--secondary', '<?php echo e(basicControl()->secondary_color); ?>');
    </script>





    <?php if(session()->has('success')): ?>

    <script>
        Notiflix.Notify.success("<?php echo app('translator')->get(session('success')); ?>");
    </script>

    <?php endif; ?>



    <?php if(session()->has('error')): ?>

    <script>
        Notiflix.Notify.failure("<?php echo app('translator')->get(session('error')); ?>");
    </script>

    <?php endif; ?>



    <?php if(session()->has('warning')): ?>

    <script>
        Notiflix.Notify.warning("<?php echo app('translator')->get(session('warning')); ?>");
    </script>

    <?php endif; ?>







</body>
<script async src="https://www.googletagmanager.com/gtag/js?id=G-BC9H8SYXHZ"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-BC9H8SYXHZ');
</script>


</html><?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/layouts/app.blade.php ENDPATH**/ ?>