<!-- CART OFFCANVAS -->
<div id="cart-offcanvas" class="cart-offcanvas">
    <div class="popup-inner">
        <div class="overlay-layer"></div>
        <div class="search-container">
            <div class="cart-offcanvas-header">
                <div class="cart-offcanvas-header-title">
                    <h5><?php echo app('translator')->get('Your Bag'); ?><span>(<span class="totalCartItems"><?php echo e(count(session('cart')??[])); ?></span>)</span></h5>
                </div>
                <div class="close-search theme-btn"><?php echo app('translator')->get('Close'); ?></div>
            </div>
            <div class="cart-offcanvas-body">
                <ul id="cartItems">
                    <?php $__empty_1 = true; $__currentLoopData = session('cart')??[]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="search-bag-items" id="cartItem<?php echo e($item['id']); ?>">
                            <div class="search-bag-content">
                                <div class="search-bag-image">
                                    <img src="<?php echo e($item['image']); ?>" alt="product">
                                </div>
                                <div class="search-bag-title">
                                    <h6><?php echo e($item['name']); ?> </h6>
                                    <div class="search-bag-count">
                                        <p><?php echo e(currencyPosition($item['price'])); ?>/<?php echo e($item['product_quantity']+0); ?> <?php echo app('translator')->get('gm'); ?></p>
                                        <div class="incriment-dicriment">
                                            <div class="count-single">
                                                <button type="button"  class="decrement" data-id="<?php echo e($item['id']); ?>"><i class="fa-light fa-minus"></i></button>
                                                <span class="number" id="no<?php echo e($item['id']); ?>"><?php echo e($item['quantity']); ?></span>
                                                <button type="button" class="increment" data-id="<?php echo e($item['id']); ?>"><i class="fa-light fa-plus"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="serch-bag-amount">
                                <h6><?php echo e(currencyPosition($item['quantity'] * $item['price'])); ?></h6>
                            </div>
                            <div class="serch-bag-close">
                                <div class="close-btn removeCartItem" data-id="<?php echo e($item['id']); ?>">
                                    <i class="fa-regular fa-xmark"></i>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="search-popup-empty">
                            <div class="empty-image">
                                <img src="<?php echo e(asset($themeTrue.'images/empty.png')); ?>" alt="">
                                <h5><?php echo app('translator')->get('No Item Added the cart'); ?></h5>
                            </div>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="cart-offcanvas-footer">
                <h6><i class="fa-light fa-circle-check"></i> <?php echo app('translator')->get('Have any Special code'); ?>?</h6>
                <form id="couponForm">
                    <?php echo csrf_field(); ?>
                <div class="cart-offcanvas-form">
                    <input type="text" name="code" id="coupon" placeholder="<?php echo app('translator')->get('Discount Code'); ?>">
                    <button class="cart-offcanvas-form-btn" type="submit"><?php echo app('translator')->get('Go'); ?></button>
                </div>
                    <span class="invalid-feedback d-block offcanvas-coupon" id="coupon-error" role="alert"> </span>
                </form>
                <h5><?php echo app('translator')->get('Sub Total'); ?>  <span class="cart-offcanvas-footer-total totalPrice"><?php echo e(session('discountPrice')?currencyPosition(session('discountPrice')):currencyPosition(cartTotal(session('cart')??[]))); ?></span></h5>
                <a href="<?php echo e(route('cart')); ?>" class="btn-1"><?php echo app('translator')->get('View Cart'); ?> <span></span></a>
            </div>
        </div>
    </div>
</div>
<!-- CART OFFCANVAS -->
<?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/partials/cart.blade.php ENDPATH**/ ?>