<?php if(hasEcommerce()): ?>
    <!-- calculation -->
    <section class="calculation">
        <div class="flower">
            <img src="<?php echo e(asset(template(true).'images/shape/flower.png')); ?>" alt="shape">
        </div>
        <div class="abs">
            <img src="<?php echo e(asset(template(true).'images/shape/abs-2.png')); ?>" alt="shape">
        </div>
        <div class="container">
            <div class="common-title-container">
                <div class="common-title">
                    <h6><?php echo e($calculation_section['single']['title']??''); ?></h6>
                    <h3> <?php echo styleSentence2($calculation_section['single']['sub_title'],3,true); ?> </h3>
                </div>
                <div class="common-title-description">
                    <p> <?php echo e($calculation_section['single']['short_description']??''); ?> </p>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-5">
                    <div class="calculation-left-container">
                        <div class="bg-layer" style="background: url(<?php echo e(isset($calculation_section['single']['media']->banner_image)?getFile($calculation_section['single']['media']->banner_image->driver,$calculation_section['single']['media']->banner_image->path):''); ?>);"></div>
                        <div class="calculation-left-content">
                            <h4><?php echo e($calculation_section['single']['banner_title']??''); ?></h4>
                            <p> <?php echo e($calculation_section['single']['banner_description']??''); ?> </p>
                            <a href="<?php echo e($calculation_section['single']['media']->banner_button_link??''); ?>" class="btn-1"> <?php echo e($calculation_section['single']['banner_button_name']??''); ?> <i class="fa-regular fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-7">
                    <div class="calculation-right-container">
                        <h5><?php echo e($calculation_section['single']['calculator_title']??''); ?></h5>
                        <p><?php echo e($calculation_section['single']['calculator_short_description']??''); ?></p>
                        <div class="calcilation-table">
                            <div class="calcilation-table-left">
                                <table>
                                    <tr>
                                        <th><?php echo app('translator')->get('Karat'); ?></th>
                                        <th><?php echo app('translator')->get('Weight'); ?></th>
                                        <th><?php echo app('translator')->get('Price(per gram)'); ?></th>
                                        <th><?php echo app('translator')->get('Value'); ?></th>
                                    </tr>
                                    <?php $__currentLoopData = $calculation_section['karats']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $karat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($karat->karat+0); ?><?php echo app('translator')->get('ct Gold'); ?></td>
                                            <td class="table-input">
                                                <input type="number" data-id="<?php echo e($karat->id); ?>" data-price="<?php echo e($karat->price); ?>" class="karat_weight" value="0" min="0" >
                                                <span><?php echo app('translator')->get('g'); ?></span>
                                            </td>
                                            <td><?php echo e(currencyPosition($karat->price+0)); ?></td>
                                            <td class="subTotalValue_<?php echo e($karat->id); ?>"><?php echo e(currencyPosition(0)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>

                            <div class="total-payment">
                                <div class="total-payment-inner">
                                    <div class="total-payment-header">
                                        <h6><?php echo app('translator')->get('Total payment'); ?></h6>
                                    </div>
                                    <div class="total-payment-body">
                                        <h3 class="totalValue"><span><?php echo e(basicControl()->currency_symbol); ?></span>0</h3>
                                        <div class="total-payment-list">
                                            <ul>
                                                <?php $__currentLoopData = collect($calculation_section['multiple'])->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><i class="fa-sharp fa-light fa-circle-check"></i> <?php echo e($item['feature']??''); ?> </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- calculation -->
<?php endif; ?>
<?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/sections/calculation_section.blade.php ENDPATH**/ ?>