
<?php $__env->startSection('page_title', __('Plan Invest History')); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid bg-light">
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item"><a class="breadcrumb-link" href="javascript:void(0);"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo app('translator')->get('Plan Invest History'); ?></li>
                    </ol>
                </nav>
                <h1 class="page-header-title"><?php echo app('translator')->get('Plan Invest History'); ?></h1>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header card-header-content-md-between">
            <div class="row w-100 g-2">
                <div class="col-md-4">
                    <div class="input-group input-group-merge navbar-input-group">
                        <div class="input-group-prepend input-group-text">
                            <i class="bi-search"></i>
                        </div>
                        <input type="search" id="datatableSearch" class="search form-control form-control-sm"
                               placeholder="<?php echo app('translator')->get('Search history'); ?>" aria-label="<?php echo app('translator')->get('Search history'); ?>" autocomplete="off">
                        <a class="input-group-append input-group-text display-none" href="javascript:void(0)">
                            <i id="clearSearchResultsIcon" class="bi-x"></i>
                        </a>
                    </div>
                </div>
                <div class="col-md-4">
                    <input type="text" id="dateFilter" class="form-control js-flatpickr" placeholder="<?php echo app('translator')->get('Select Date Range'); ?>"
                           data-date-format="Y-m-d" data-mode="range" autocomplete="off">
                </div>
            </div>
        </div>

        <div class="table-responsive datatable-custom invest-plan-history">
            <table id="datatable"
                   class="js-datatable table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                   data-hs-datatables-options='{
                       "columnDefs": [{"targets": [0, 4],"orderable": false}],
                       "order": [],
                       "info": {"totalQty": "#datatableWithPaginationInfoTotalQty"},
                       "search": "#datatableSearch",
                       "entries": "#datatableEntries",
                       "pageLength": 15,
                       "isResponsive": false,
                       "isShowPaging": false,
                       "pagination": "datatablePagination"
                   }'>
                <thead class="thead-light">
                <tr>
                    <th><?php echo app('translator')->get('Transaction Id'); ?></th>
                    <th><?php echo app('translator')->get('Name'); ?></th>
                    <th><?php echo app('translator')->get('Plan'); ?></th>
                    <th><?php echo app('translator')->get('Created At'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>

        <div class="card-footer">
            <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <div class="d-flex justify-content-center justify-content-sm-start align-items-center">
                        <span class="me-2"><?php echo app('translator')->get('Showing:'); ?></span>
                        <div class="tom-select-custom">
                            <select id="datatableEntries"
                                    class="js-select form-select form-select-borderless w-auto" autocomplete="off"
                                    data-hs-tom-select-options='{"searchInDropdown": false, "hideSearch": true}'>
                                <option value="10">10</option>
                                <option value="20" selected>20</option>
                                <option value="30">30</option>
                                <option value="40">40</option>
                            </select>
                        </div>
                        <span class="text-secondary me-2"><?php echo app('translator')->get('of'); ?></span>
                        <span id="datatableWithPaginationInfoTotalQty"></span>
                    </div>
                </div>
                <div class="col-sm-auto">
                    <div class="d-flex justify-content-center justify-content-sm-end">
                        <nav id="datatablePagination" aria-label="Activity pagination"></nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="InvestTerminateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="exampleModalLabel"><?php echo app('translator')->get('Confirmation'); ?>?</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="terminateRoute" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you sure you want to terminate this investment'); ?>?</p>
                    <p><?php echo app('translator')->get('Terminate Charge is'); ?> <?php echo e(basicControl()->terminate_charge); ?>%. 
                    <?php echo app('translator')->get('If you want to change terminate charge then'); ?> 
                    <a href="<?php echo e(route('admin.basic.control')); ?>"><?php echo app('translator')->get('click here'); ?></a></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-white" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-lib'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/tom-select.bootstrap5.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/flatpickr.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js-lib'); ?>
<script src="<?php echo e(asset('assets/admin/js/tom-select.complete.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/flatpickr.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
$(document).on('click', '.terminate_btn', function () {
    $('#terminateRoute').attr('action', $(this).data('route'))
});

$(document).ready(function () {
    // Init flatpickr manually with custom rangeSeparator
    flatpickr("#dateFilter", {
        mode: "range",
        dateFormat: "Y-m-d",
        locale: {
            rangeSeparator: " to "
        }
    });

    HSCore.components.HSTomSelect.init('.js-select', { maxOptions: 250 });

    let table = HSCore.components.HSDatatables.init($('#datatable'), {
        processing: true,
        serverSide: true,
        ordering: false,
        ajax: {
            url: "<?php echo e(route('admin.invest.history.list')); ?>",
            data: function (d) {
                d.date = $('#dateFilter').val(); // Send the flatpickr date range string
            }
        },
        columns: [
            { data: 'trx_id', name: 'trx_id' },
            { data: 'name', name: 'name' },
            { data: 'plan', name: 'plan' },
            { data: 'created_at', name: 'created_at' },
            { data: 'action', name: 'action' },
        ],
        language: {
            zeroRecords: `<div class="text-center p-4">
                            <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error.svg')); ?>" alt="Image" data-hs-theme-appearance="default">
                            <img class="dataTables-image mb-3" src="<?php echo e(asset('assets/admin/img/oc-error-light.svg')); ?>" alt="Image" data-hs-theme-appearance="dark">
                            <p class="mb-0">No data to show</p>
                          </div>`,
            processing: `<div><div></div><div></div><div></div><div></div></div>`
        }
    });

    // Reload table on date range change
    $('#dateFilter').on('change', function () {
        $('#datatable').DataTable().ajax.reload();
    });

    $.fn.dataTable.ext.errMode = 'throw';
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/plan_invest_history/index.blade.php ENDPATH**/ ?>