<?php
use Illuminate\Support\Str;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <link href="<?php echo e(getFile(basicControl()->favicon_driver, basicControl()->favicon)); ?>" rel="icon">


    <title><?php echo e(trans('Dashboard')); ?> | <?php echo app('translator')->get(basicControl()->site_title); ?> </title>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/all.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/flatpickr-min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/bootstrap.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/select2.min.css')); ?>"/>
    <link href="<?php echo e(asset(template(true).'css/swiper.min.css')); ?>" rel="stylesheet">
    <!-- custom css -->
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue . 'css/user-style.css')); ?>?v=<?php echo e(time()); ?>"/>

    <!-- owl carousel -->
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/owl.carousel.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/owl.theme.default.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/apexcharts.css')); ?>"/>
    <link href="<?php echo e(asset($themeTrue.'css/fancy-box-carusol.css')); ?>" rel="stylesheet">
    <?php echo $__env->yieldPushContent('css-lib'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>
</head>

<body onload="preloaderFunction()" >


    <div id="preloader">
        <div class="load">
            <hr/>
            <hr/>
            <hr/>
            <hr/>
        </div>
    </div>

<!-- Header section start -->
<header id="header" class="header fixed-top d-flex align-items-center">
    <div class="d-flex align-items-center justify-content-between">
        <div class="logo-container">
            <a href="<?php echo e(route('page')); ?>" class="logo d-flex align-items-center">
                <img src="<?php echo e(logo(true)); ?>" alt="...">
            </a>
        </div>

    </div>
    <!-- End Logo -->

    <nav class="header-nav ms-auto">
        <ul class="nav-icons">
            <li class="nav-item dropdown">

                <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
                   <span class="d-none d-lg-block dropdown-toggle ps-2">
                    <?php echo e(Str::title(auth()->user()->firstname.' '.auth()->user()->lastname)); ?>

                </span>

            </a>

            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
                <li>
                    <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('user.profile')); ?>">
                        <i class="fa-light fa-user"></i>
                        <span><?php echo app('translator')->get('Account Settings'); ?></span>
                    </a>
                </li>
                <li>
                    <a class="dropdown-item d-flex align-items-center" href="<?php echo e(route('logout')); ?>"
                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="fa-regular fa-right-from-bracket"></i>
                    <span><?php echo app('translator')->get('Sign Out'); ?></span>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </a>
            </li>

        </ul>
    </li>

</ul>
</nav>

</header>
<?php if($planInvestment = \App\Models\InvestHistory::with('plan')->where('user_id', Auth::id())->first()): ?>
<?php echo $__env->make($theme.'partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<main id="main" class="main">
    <?php echo $__env->yieldContent('content'); ?>
</main>
<footer id="footer" class="footer">
    <div class="copyright">
        &copy; <?php echo app('translator')->get('Copyright'); ?> <strong><span><?php echo e(basicControl()->site_title); ?></span></strong>. <?php echo app('translator')->get('All Rights Reserved'); ?>    </div>
    </footer>
    <?php else: ?>
    <main id="main" class="main" style="margin-left: 0!important">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <footer id="footer" class="footer" style="margin-left: 0!important">
        <div class="copyright">
            &copy; <?php echo app('translator')->get('Copyright'); ?> <strong><span><?php echo e(basicControl()->site_title); ?></span></strong>. <?php echo app('translator')->get('All Rights Reserved'); ?>    </div>
        </footer>
        <?php endif; ?>
<!-- Footer section end -->

<!-- bootstrap -->
<script src="<?php echo e(asset($themeTrue.'js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/flatpickr-min.js')); ?>"></script>
<!-- jquery cdn -->
<script src="<?php echo e(asset('assets/global/js/jquery.min.js')); ?>"></script>

<script src="<?php echo e(asset($themeTrue.'js/apexcharts.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/Chart.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue . 'js/select2.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/waypoints.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/notiflix-aio-3.2.6.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/pusher.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/vue.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/axios.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery.uploadPreview.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/swiper.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/custom_share.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/user-script.js')); ?>"></script>
<?php echo $__env->yieldPushContent('js-lib'); ?>
<?php echo $__env->yieldPushContent('script'); ?>
<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script>
    function currencyPosition(amount) {
        var currencyPosition = <?php echo json_encode(basicControl()->is_currency_position, 15, 512) ?>;
        var has_space_between_currency_and_amount = <?php echo json_encode(basicControl()->has_space_between_currency_and_amount, 15, 512) ?>;
        var currency_symbol = <?php echo json_encode(basicControl()->currency_symbol, 15, 512) ?>;
        var base_currency = <?php echo json_encode(basicControl()->base_currency, 15, 512) ?>;
        amount = parseFloat(amount).toFixed(2);
        if (currencyPosition === 'left' && has_space_between_currency_and_amount) {
            return currency_symbol + '  ' + amount;
        } else if (currencyPosition === 'left' && !has_space_between_currency_and_amount) {
            return currency_symbol + ' ' + amount;
        } else if (currencyPosition === 'right' && has_space_between_currency_and_amount) {
            return amount + '  ' + base_currency;
        } else {
            return amount + '  ' + base_currency;
        }
    }
</script>
<script>
    'use strict';
    $(document).on('input', '.global-search', function() {
        var search = $(this).val().toLowerCase();

        if (search.length == 0) {
            $('.search-result').find('.content').html('');
            $(this).siblings('.search-backdrop').addClass('d-none');
            $(this).siblings('.search-result').addClass('d-none');
            return false;
        }

        $('.search-result').find('.content').html('');
        $(this).siblings('.search-backdrop').removeClass('d-none');
        $(this).siblings('.search-result').removeClass('d-none');

        var match = $('.sidebar-nav li').filter(function(idx, element) {
            if (!$(element).find('a').hasClass('has-dropdown') && !$(element).hasClass('menu-header'))
                return $(element).text().trim().toLowerCase().indexOf(search) >= 0 ? element : null;
        }).sort();

        if (match.length == 0) {
            $('.search-result').find('.content').append(
        `<div class="search-item"><a href="javascript:void(0)">No result found</a></div>`);
            return false;
        }

        match.each(function(index, element) {
            var item_text = $(element).text().replace(/(\d+)/g, '').trim();
            var item_url = $(element).find('a').attr('href');
            if (item_url != '#') {
                $('.search-result').find('.content').append(
            `<div class="search-item"><a href="${item_url}">${item_text}</a></div>`);
            }
        });
    });
</script>

<script>
    "use strict";
    var root = document.querySelector(':root');
    root.style.setProperty('--primary-color', '<?php echo e(basicControl()->primary_color); ?>');
    root.style.setProperty('--secondary-color', '<?php echo e(basicControl()->secondary_color); ?>');
</script>

<?php if(session()->has('success')): ?>
<script>
    Notiflix.Notify.success("<?php echo app('translator')->get(session('success')); ?>");
</script>
<?php endif; ?>



<?php if(session()->has('error')): ?>
<script>
    Notiflix.Notify.failure("<?php echo app('translator')->get(session('error')); ?>");
</script>
<?php endif; ?>

<?php if(session()->has('warning')): ?>
<script>
    Notiflix.Notify.warning("<?php echo app('translator')->get(session('warning')); ?>");
</script>
<?php endif; ?>

</body>
</html>





<?php /**PATH /home/petarig/public_html/project/resources/views/themes/light/layouts/custom.blade.php ENDPATH**/ ?>