
<?php $__env->startSection('page_title', __('Create Configuration')); ?>
<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-end">
            <div class="col-sm mb-2 mb-sm-0">
                <h1 class="page-header-title"><?php echo app('translator')->get('Create Monthly Plan'); ?></h1>
            </div>
            <div class="col-sm-auto">
                <a href="<?php echo e(route('admin.monthly.plan.index')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Back to List'); ?></a>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <form action="<?php echo e(route('admin.monthly.plan.store')); ?>" method="post">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-header-title"><?php echo app('translator')->get('Monthly Plan Configuration'); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Period Start -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="period_start" class="form-label"><?php echo app('translator')->get('Period Start'); ?></label>
                                    <input type="date" 
                                    class="form-control <?php $__errorArgs = ['period_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="period_start" 
                                    id="period_start" 
                                    value="<?php echo e(old('period_start')); ?>"
                                    required>
                                    <?php $__errorArgs = ['period_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- Period End -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="period_end" class="form-label"><?php echo app('translator')->get('Period End'); ?></label>
                                    <input type="date" 
                                    class="form-control <?php $__errorArgs = ['period_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="period_end" 
                                    id="period_end" 
                                    value="<?php echo e(old('period_end')); ?>"
                                    required>
                                    <?php $__errorArgs = ['period_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>


                            <!-- Reward -->
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="reward" class="form-label"><?php echo app('translator')->get('Total Reward'); ?></label>
                                    <input type="number" 
                                    class="form-control <?php $__errorArgs = ['reward'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="reward" 
                                    id="reward" 
                                    value="<?php echo e(old('reward')); ?>"
                                    step="0.0001"
                                    min="0"
                                    required>
                                    <?php $__errorArgs = ['reward'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>     

                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="cost" class="form-label"><?php echo app('translator')->get('Operations Cost'); ?></label>
                                    <input type="number" 
                                    class="form-control <?php $__errorArgs = ['cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="cost" 
                                    id="cost" 
                                    value="<?php echo e(old('cost')); ?>"
                                    step="0.0001"
                                    min="0"
                                    required>
                                    <?php $__errorArgs = ['cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="operation_percentage" class="form-label">Operation Percentage</label>
                                    <input type="number" 
                                    class="form-control <?php $__errorArgs = ['operation_percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="operation_percentage" 
                                    id="operation_percentage" 
                                    value="<?php echo e(old('operation_percentage')); ?>"
                                    step="1"
                                    min="0"
                                    required>
                                    <?php $__errorArgs = ['operation_percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <label for="total_machine" class="form-label">Total Machine</label>
                                    <input type="number" 
                                    class="form-control <?php $__errorArgs = ['total_machine'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="total_machine" 
                                    id="total_machine" 
                                    value="<?php echo e(old('total_machine')); ?>"
                                    step="1"
                                    min="0"
                                    required>
                                    <?php $__errorArgs = ['total_machine'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-header-title"><?php echo app('translator')->get('Actions'); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-3">
                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save'); ?></button>
                            <button type="reset" class="btn btn-secondary"><?php echo app('translator')->get('Reset'); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function() {
        // Date validation to ensure period_end is after period_start
        $('#period_start, #period_end').change(function() {
            const startDate = new Date($('#period_start').val());
            const endDate = new Date($('#period_end').val());
            
            if (startDate && endDate && endDate <= startDate) {
                alert('Period End must be after Period Start');
                $('#period_end').val('');
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/petarig/public_html/project/resources/views/admin/monthly_config/create.blade.php ENDPATH**/ ?>