@extends($theme.'layouts.user')

@section('title',trans('Investment Plan'))

@section('content')

<style type="text/css">
    .pricing-header {

        height: 150px;

        padding: 0 !important;

    }

    .pricing-container {

        height: 370px;

    }

    .button-container {

        height: 100px;

    }

    .pricing-card {

        padding: 25px;

    }

    .modal .modal-content {

        background: #071720 !important;

    }

    /* 07/04/2025 */
    .outer-color {
        border: 1px solid rgb(44, 97, 118);
        border-radius: 24px;
    }

    .disclaimer {
        border-radius: 8px;
        text-align: center;
        background: linear-gradient(0deg, #195273 0%, #0F324680 100%);
        font-size: 13px;
        line-height: 1.6;
    }

    hr.faded-line {
        border: none;
        height: 2px;
        background: linear-gradient(to right, transparent, #184e6d, transparent);
        margin: 1.5rem 0;
    }

    .select-wrapper {
        position: relative;
    }

    .select-wrapper select {
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        padding-right: 2rem; 
        background-color: white;
        background-image: none; 
    }

    .chevron-icon {
        position: absolute;
        right: 1rem;
        top: 50%;
        transform: translateY(-50%);
        pointer-events: none;
        color: #000000;
        font-size: 0.8rem;
    }

    .card-color {

        background: #0F3246;

        border-radius: 20px;

        border: 1px solid rgb(44, 97, 118);

        height: 100%;

    }

    li {

        font-size: 15px;

    }


    .list-icon {

        width: 30px;

        height: 30px;

        margin-right: 10px;

    }

    .investNow,
    .primary-button {
        width: 100%;
        border-radius: 8px;
        text-align: center;
        justify-content: center;
        background: linear-gradient(90deg, #03228F 0%, #0E73E4 100%);
    }

    .primary-button:disabled,
    .primary-button.disabled {
        opacity: 0.6;
        cursor: not-allowed;
        pointer-events: none;
        background: linear-gradient(90deg, #6c757d 0%, #adb5bd 100%);
    }

    .primary-button:not(:disabled):hover {
        filter: brightness(1.1);
    }

    .pricing-single .btn-1 {

        border-radius: 500px !important;

    }

    @media (min-width: 992px) {
        .pricing-header .title h4 {
            font-size: 30px !important;
        }

        .pricing-header strong {
            font-size: 36px;
        }

        .pricing-header {

            height: 160px;

        }

        .pricing-container {
            height: 390px;
        }
    }

    @media (min-width: 1200px) {
        .pricing-header .title h4 {
            font-size: 32px !important;
        }
    }
</style>

<div class="pagetitle" style="text-align: center;">

    <h3 class="mb-1" style="font-weight: 600;">Select Your Package</h3>

    <!-- <span class="mb-2">Choose your mining machine first</span> -->

</div>


<div class="container">
    <div class="row gap-4 d-flex flex-row justify-content-evenly justify-content-lg-center">

        @foreach($plans as $key => $plan)

        <div class="col-md-5 col-xl-4 col-11 p-2 outer-color">

            <div class="card-color">

                <div class="pricing-card">

                    <div class="pricing-header d-flex flex-column">

                        <div class="title w-100" style="display: flex;flex-direction: row;justify-content: space-between;margin-bottom: 10px;">

                            @php
                            $words = explode(' ', __($plan->plan_name));
                            @endphp

                            <h4 class="font-bold">
                                {{ implode(' ', array_slice($words, 0, 2)) }}<br>
                                {{ implode(' ', array_slice($words, 2)) }}
                            </h4>

                            <img style="width: 50px;height: 50px;" src="{{ asset(template(true).'images/custom/thunder.png') }}" alt="thunder Icon" />

                        </div>

                        <!-- <h2><strong>{{$plan->investAmount()}} /<sub>unit</sub></strong></h2> -->
                        <div class="d-flex justify-content-start align-items-end mt-auto">
                            <h2 class="mb-0"><strong>{{$plan->investAmount()}}</strong></h2>
                            <!-- <span class="ps-1 pb-2">/unit</span> -->
                        </div>

                    </div>

                    <hr class="faded-line">



                    <div class="pricing-body">

                        <div class="pricing-container">

                            <ul class="pricing-list">

                                <li class="my-3"> <img class="list-icon" src="{{ asset(template(true).'images/custom/Gauge.svg') }}" alt="Gauge Icon" />{{$plan->text1}}</li>

                                <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/FileText.svg') }}" alt="filetext Icon" />{{$plan->text2}}</li>

                                <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/MoneyWavy.svg') }}" alt="moneywavy Icon" />{{$plan->text3}}</li>

                                <!-- <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/HandWithdraw.svg') }}" alt="HandWithdraw Icon" />{{$plan->text4}}</li> -->

                                <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/ChartBar.svg') }}" alt="ChartBar Icon" />{{$plan->text5}}</li>

                                <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/CurrencyCircleDollar.svg') }}" alt="CurrencyCircleDollar Icon" />{{$plan->text6}}</li>

                            </ul>

                        </div>



                        <hr class="faded-line">



                        <div class="disclaimer mb-4">
                          
                            @php
                            $shortDesc = str_replace('&nbsp;', ' ', $plan->short_description);

                            // Split by first period + space to separate two sentences.
                            $sentences = preg_split('/(\. )/', $shortDesc, 2, PREG_SPLIT_DELIM_CAPTURE);

                            $formattedDesc = '';
                            if (count($sentences) >= 2) {
                                $formattedDesc = $sentences[0] . $sentences[1] . '<br>' . ($sentences[2] ?? '');
                            } else {
                                $formattedDesc = $shortDesc;
                            } 
                            @endphp


                            <div class="px-2 py-3">
                                <p class="m-0 mb-1 w-100" style="font-style: italic;text-align: left;">Notes:</p>
                                <p class="m-0 w-100" style="font-style: italic;text-align: left;">{{ $sentences[0] . $sentences[1] }}</p>
                                <p class="m-0 w-100" style="font-style: italic;text-align: left;">{{ $sentences[2] }}</p>
                            </div>

                        </div>

                        @php
                        $maxQuantity = min(19, $available); 
                        @endphp
                        <div class="button-container">

                            <div class="select-wrapper position-relative mb-2">
                                <select name="quantity" id="quantity" class="form-control" {{ $soldOut ? 'disabled' : '' }}>
                                    @if ($soldOut)
                                    <option value="0">{{ __('Sold Out') }}</option>
                                    @else
                                    @for ($i = 1; $i <= $maxQuantity; $i++)
                                    <option value="{{ $i }}">{{ __('Quantity') }} {{ $i }}</option>
                                    @endfor
                                    @endif
                                </select>
                                <i class="fa-solid fa-chevron-down chevron-icon"></i>
                            </div>

                            @if ($soldOut)
                            <a style="width: 100%; border-radius:8px;
                            text-align: center;
                            justify-content: center;
                            background: linear-gradient(90deg, #b0b0b0 0%, #d3d3d3 100%);
                            pointer-events: none; opacity: 0.6;"
                            class="btn-1 disabled">
                            {{ __('Sold Out') }}
                        </a>
                        @else
                        <a style="width: 100%;border-radius:8px ;

                        text-align: center;

                        justify-content: center;background: linear-gradient(90deg, #03228F 0%, #0E73E4 100%);" href="javascript:void(0)"

                        data-id="{{$plan->id}}"
                        data-price="{{$plan->plan_price}}"
                        data-bs-toggle="modal"

                        data-return="{{$plan->number_of_profit_return?$plan->number_of_profit_return.' '.trans('Times'):trans('Lifetime Earning')}}"

                        data-maturity="{{$plan->maturity}}"

                        data-capital="{!! $plan->getUserCapitalBack() !!}"

                        data-bs-target="#InvestModal"

                        class="btn-1 investNow">Buy Now</i>

                    </a>
                    @endif

                </div>

            </div>

        </div>

    </div>

</div>

@endforeach

<div class="col-md-5 col-xl-4 col-11 p-2 outer-color">

    <div class="card-color">

        <div class="pricing-card">

            <div class="pricing-header d-flex flex-column justify-content-between align-items-start">

                <div class="title w-100" style="display: flex;flex-direction: row;justify-content: space-between;margin-bottom: 10px;">

                    <h4>Petarigs <br>Entreprise Plan</h4>

                    <img style="width: 50px;height: 50px;" src="{{ asset(template(true).'images/custom/hall.png') }}" alt="Hall Icon" />

                </div>

                <h2 class="mb-0"><strong>Contact Us</strong></h2>

            </div>

            <hr class="faded-line">



            <div class="pricing-body">

                <div class="pricing-container">

                    <div class="mb-3">

                        <a href="#"

                        class="btn-1 investNow font-bold" style="width: 100%;

                        text-align: center;

                        justify-content: center;background: #38B6FF33;border-radius:8px ;"><i class="fa-solid fa-bolt"></i> 20 Machines

                    </a>

                </div>

                <ul class="pricing-list">

                    <li class="my-3"> <img class="list-icon" src="{{ asset(template(true).'images/custom/Gauge.svg') }}" alt="Gauge Icon" />Elphapex DG1+ 14000M, 3920W, 0.28J/M</li>

                    <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/FileText.svg') }}" alt="filetext Icon" />Subscription 5 years</li>

                    <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/MoneyWavy.svg') }}" alt="moneywavy Icon" />Profit withdrawal: Anytime, full access</li>

                    <!-- <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/HandWithdraw.svg') }}" alt="HandWithdraw Icon" />Liquidity : Internal platform to match buyers/sellers</li> -->

                    <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/ChartBar.svg') }}" alt="ChartBar Icon" />Expected yield: monthly 4.9%, annualize 59% *</li>

                    <li class="my-3"><img class="list-icon" src="{{ asset(template(true).'images/custom/CurrencyCircleDollar.svg') }}" alt="CurrencyCircleDollar Icon" />5 years expected ROI: 100% *</li>

                </ul>

            </div>



            <hr class="faded-line">



            <div class="disclaimer mb-4">

                <div class="px-2 py-3">
                    <p class="m-0 mb-1 w-100" style="font-style: italic;text-align: left;">Notes:</p>
                    <p class="m-0 w-100" style="font-style: italic;text-align: left;">* Expected Yield and ROI are not guaranteed and fluctuates in line with coin prices.</p>
                    <p class="m-0 w-100" style="font-style: italic;text-align: left;">Product prices are subjected to change.</p>
                </div>

            </div>

            <div class="button-container d-flex">
                <a href="#"

                class="btn-1 investNow mt-auto" style="width: 100%;border-radius:8px ;

                text-align: center;

                justify-content: center;background: linear-gradient(90deg, #03228F 0%, #0E73E4 100%);">Contact Us

            </a>
        </div>

    </div>

</div>
</div>
</div>

</div>

</div>

</div>



<div id="InvestModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-fullscreen" role="document"> <!-- Added 'modal-fullscreen' -->

        <div class="modal-content">

            <div class="modal-header text-white border-0">

                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>

            </div>

            <div class="d-flex justify-content-center align-items-center">

                <form action="{{route('user.investPlan')}}" method="post" class="col-md-8 col-12">

                    @csrf

                    <div class="modal-body">

                        <h3 class="modal-title text-center mb-2" id="contractModalLabel">{{ $content->subject }}</h3>

                        <p class="text-center mb-3">Please read and accept the terms of the contract before proceeding.</p>

                        <div id="terms" class="p-3 bg-light rounded" style="color:white; overflow:scroll; max-height:55vh;">
                            {!! $content->content !!}
                        </div>


                        <div class="form-group d-none">

                            <label class="modal-label" for="balance_type">@lang('Select Wallet')</label>

                            <select class="form-control" name="balance_type">

                                <option value="checkout">@lang('Checkout')</option>

                            </select>

                        </div>

                        <label class="modal-label d-none" for="balance_type">@lang('Enter Amount')</label>

                        <div class="input-group d-none">

                            <input type="text" class="form-control invest-amount" name="amount" id="amount"

                            value="{{$plan->plan_price}}"

                            onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" autocomplete="off"

                            placeholder="@lang('e.g: 100')" />

                            <span class="input-group-text show-currency bg-white">{{basicControl()->currency_symbol}}</span>

                        </div>

                        <input type="hidden" name="plan_id" class="plan-id"> 
                        
                    </div>

                    <div class="modal-footer border-0">

                        <button type="submit" class="btn-2 primary-button planPurchaseSubmitButton" style="width: 100vw !important;" disabled>Accept the Contract<span></span></button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>



@endsection



@push('script')

<script>
    $(document).ready(function() {
        $('#terms').on('scroll', function() {
            var $this = $(this);
            var isAtBottom = $this.scrollTop() + $this.innerHeight() >= this.scrollHeight;

            if (isAtBottom) {
                $('.planPurchaseSubmitButton').prop('disabled', false).removeClass('disabled');
            }
        });
    });

    $(document).on('click', '.planPurchaseSubmitButton', function(e) {
        e.preventDefault();

        $(this).attr('disabled', true);

        $('#InvestModal').modal('hide');

        $('html').css('overflow', 'auto');

        setTimeout(() => {

            $(this).closest('form').submit();

        }, 200);

    });


    $(document).on('click', '.btn-close', function() {
        $('html').css('overflow', 'auto');
    });


    $(document).on('click', '.investNow', function() {
        $('html').css('overflow', 'hidden');
        $('.plan-id').val($(this).data('id'));

        // Store the plan price in a variable
        let planPrice = parseFloat($(this).data('price'));

        // Update the hidden amount field
        let quantity = parseInt(
            $(this).closest('.button-container') // optional: if you have one
            .find('select[name="quantity"]').val()
            );
        $('#amount').val(quantity * planPrice);

        let maturity = $(this).data('maturity');
        let numberOfReturn = $(this).data('return');
        let capitalBack = $(this).data('capital');

        $('.maturity').text(`${maturity} ` + '{{trans('Days')}}');
        $('.numberOfReturn').text(`${numberOfReturn}`);
        $('.capitalBack').html(capitalBack);
    });

    // Update amount when quantity changes
    $('#quantity').on('change', function() {
        let quantity = parseInt($(this).val());
        let planPrice = parseFloat($('.investNow[data-bs-target="#InvestModal"]').data('price'));
        $('#amount').val(quantity * planPrice);
    });
</script>


@endpush