@extends($theme.'layouts.user')

@section('title',trans('Dashboard'))

@push('style')
<style>
    .text-primary {
        color: #0e73e4 !important;
    }

    .text-success {
        color: #5ad57b !important
    }

    .my-grid {
        display: grid;
        gap: 0.5rem;
        grid-template-columns: 1fr;
        grid-auto-rows: min-content;
    }

    .item-5 {
        grid-row: 1;
    }

    .legend {
        width: 20px;
        height: 20px;
        border-radius: 5px;
    }

    .wallet-item,
    .common-item .agent {
        background-color: #4A2C08;
        border-left: 8px solid #F7931A;
        border-radius: 12px;
        padding: 1.3rem 0.8rem 1.2rem 0.8rem;
    }

    .wallet-item img,
    .earnings-item .earning .currency-icon {
        background-color: rgba(247, 147, 26, 0.2);
        border-radius: 100%;
        margin-bottom: 0.7rem;
        padding: 0.35rem;
    }

    .wallet-item p {
        margin-bottom: 0.4rem;
    }

    .wallet-item a,
    .common-item a {
        color: #F7931A;
        font-size: 14px;
        font-weight: bold;
    }

    .wallet-item p,
    .wallet-item a {
        margin-left: 0.15rem;
    }

    .earnings-item {
        background-color: #0a202d;
        border-radius: 12px;
        padding: 1.5rem;
        overflow-x: hidden;
    }

    .earnings-item .earning,
    .common-item .copy-link {
        background-color: #0f3246;
        border: 1px solid #195273;
        border-radius: 5px;
        padding: 1rem;
    }

    .earnings-item .earning.first {
        background: rgb(3, 37, 146);
        background: linear-gradient(90deg, rgba(3, 37, 146, 1) 0%, rgba(14, 115, 228, 1) 50%);
    }

    .earnings-item .earning .currency-icon {
        background-color: rgba(14, 115, 228, 0.2);
    }

    .earnings-item .earning .currency-coin {
        width: 18px;
        height: 18px;
        margin-left: 0.15rem;
    }

    .earnings-item .earning .currency {
        font-size: 20px;
    }

    .earnings-item .earning span {
        font-size: 12px;
        margin-left: 0.15rem;
    }

    .common-item {
        background-color: #0a202d;
        border: 1px solid #195273;
        border-radius: 12px;
        padding: 1.2rem;
    }

    .common-item h6 {
        border-left: 4px solid #0e73e4;
    }

    .common-item .common-button {
        background-color: #0f3246;
        border-radius: 10px;
        width: 100%;
        display: block;
        padding: 0.8rem 0;
    }

    .common-item .copy-link {
        border-radius: 8px;
        padding: 0.8rem 1rem;
        color: white;
        gap: 0.5rem;
    }

    .common-item .copy-link input {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        width: 100%;
        pointer-events: none;
        font-weight: 600;
    }

    .common-item .copy-btn {
        display: flex;
        justify-content: center;
        align-items: center;
        background-color: #0e73e4;
        border-radius: 8px;
        padding: 0.5rem;
        color: white;
        font-size: 12px;
        width: max-content;
        pointer-events: auto;
        cursor: pointer;
        white-space: nowrap;
        flex-shrink: 0;
    }

    .common-item .referral-first-copy {
        margin: 0.7rem 0 !important;
        font-size: 12px;
        text-align: center;
    }

    .common-item .referral-second-copy {
        margin-left: 0.1rem !important;
        font-size: 14px;
    }

    .common-item .badge {
        border-radius: 30px;
        font-size: 14px;
        padding: 0.6rem 0.9rem 0.6rem 0.9rem !important;
    }

    .common-item .pending-badge {
        background-color: #4A2C08;
        color: #F7931A !important;
    }

    .common-item .pending-badge .fa-circle {
        color: #F7931A !important;
    }

    .common-item .qualified-badge {
        background-color: #1B4025;
        color: #5AD57B !important;
    }

    .common-item .qualified-badge .fa-circle {
        color: #5AD57B !important;
    }

    .common-item .agent {
        background-color: #1B4025;
        border-left: 8px solid #5AD57B;
        border-right: 8px solid #5AD57B;
        font-size: 12px;
    }

    .common-item .check-icon {
        background-color: rgba(90, 213, 123, 0.2);
        border-radius: 100%;
        padding: 0.2rem;
        margin-left: -0.1rem;
    }

    .common-item.transactions .title {
        font-size: 12px;
    }

    .common-item.transactions .subtitle,
    .earnings-item .earning .subtitle {
        font-size: 14px;
    }

    .common-item.transactions .content {
        padding: 0.8rem 0;
    }

    .common-item.transactions .border-bottom {
        border-bottom: 1px solid rgba(25, 82, 115, 0.4) !important;
    }

    .common-item.recent-transactions span {
        font-size: 12px;
    }

    .referral-table>* {
        color: white;
    }

    .referral-table tbody tr:not(:last-child) td {
        padding-bottom: 0.4rem;
    }

    .referral-table .first-col {
        padding-right: 10px;
    }

    .referral-table .border-right {
        border-right: 1px solid #ccc;
        padding-right: 10px;
        font-size: 12px;
        text-align: right;
    }

    .referral-table .currency {
        text-align: center;
        font-size: 12px;
        padding-top: 0.2rem;
    }

    .referral-table .currency img {
        width: 12px;
        margin-right: 0.3rem;
    }

    .referral-table .referral-badge {
        background-color: rgba(27, 64, 37, 0.7);
        border-radius: 15px;
        padding: 0.2rem 0.55rem;
        color: #5ad57b !important;
        font-size: 14px;
        font-weight: 800;
    }

    /* Tablet view (>=768px) */
    @media (min-width: 768px) {
        .my-grid {
            grid-template-columns: repeat(2, 1fr);
        }

        .item-1 {
            grid-column: span 2;
        }

        .item-2,
        .item-3 {
            grid-column: span 2;
            grid-row: span 2;
        }

        .item-4,
        .item-6,
        .item-7 {
            grid-column: span 1;
        }

        .item-4 .common-item {
            height: 100%;
        }

        .item-5 {
            grid-column: 1 / span 2;
            grid-row: 1;
        }

        .item-7 {
            grid-column: 2;
            grid-row: 6;
        }
    }


    /* Desktop (>= 1024px) */
    @media (min-width: 1024px) {
        .my-grid {
            gap: 1.2rem;
            grid-template-columns: repeat(3, 1fr);
        }

        .grid-left {
            grid-column: 1 / span 2;
            display: flex;
            flex-direction: column;
            gap: 1.2rem;
        }

        .grid-right {
            grid-column: 3;
            display: flex;
            flex-direction: column;
            gap: 1.2rem;
        }

        .item-1,
        .item-4,
        .item-5,
        .item-6,
        .item-7 {
            grid-column: 3;
        }
    }

    .grid-container {
        display: grid;
        gap: 1.2rem;
        grid-template-columns: repeat(2, 1fr);
    }

    .grid-container-second-row {
        display: grid;
        gap: 1.2rem;
        grid-template-columns: repeat(3, 1fr);
    }

    .earning {
        background: #f9f9f9;
        padding: 1rem;
        border-radius: 8px;
    }

    #exampleGraph, #exampleGraph2 {
        width: 100%;
    }

    @media (min-width: 768px) {

        .grid-container {
            grid-template-columns: repeat(2, 1fr);
        }

        .grid-container-second-row {
            grid-template-columns: repeat(1, 1fr);
        }
    }

    @media (min-width: 1024px) {

        /* On desktop, use 4 columns for the first row, 3 columns for the second row */
        .grid-container {
            grid-template-columns: repeat(4, 1fr);
        }

        .grid-container-second-row {
            grid-template-columns: repeat(2, 1fr);
        }

        .element-1 {
            grid-column: span 2;
        }

        .element-2 {
            grid-column: span 2;
        }

        .element-3,
        .element-4 {
            grid-column: span 1;
        }

        .element-5 {
            grid-column: span 2;
        }
    }

    @media (min-width: 1200px) {
        .grid-container-second-row {
            grid-template-columns: repeat(3, 1fr);
        }

        .element-1 {
            grid-column: span 2;
        }

        .element-2 {
            grid-column: span 2;
        }

        .element-3,
        .element-4,
        .element-5 {
            grid-column: span 1;
        }
    }

    @media (max-width: 767px) {

        .grid-container,
        .grid-container-second-row {
            grid-template-columns: 1fr;
        }

        .grid-element {
            grid-column: span 1;
        }
    }

    .popover {
        border: 1.5px solid #195273;
        background-color: #0f3246;
        border-radius: 8px;
        margin-bottom: 0.25rem !important;
    }

    .popover-body {
        color: white !important;
        font-weight: 600;
    }

    .bs-popover-auto[data-popper-placement^=top]>.popover-arrow::before, .bs-popover-top>.popover-arrow::before,
    .bs-popover-auto[data-popper-placement^=top]>.popover-arrow::after, .bs-popover-top>.popover-arrow::after {
        border-top-color: #0f3246;
    }
</style>
@endpush

@section('content')

<div class="pagetitle">

    <h3 class="mt-2 mb-5 ms-1 font-bold">@lang('Dashboard')</h3>


    </div>



    <div class="section dashboard">

        <div class="my-grid d-lg-none">

            @if(!$insert_wallet)
            <div class="item item-1">

                <div class="wallet-item">
                    <img src="{{ asset('assets/themes/light/images/icons/Info.svg') }}" alt="Info icon" />
                    <p>Purchase Subscription to start receiving rewards</p>
                    <a href="{{ route('user.plans') }}">Add Subscription<i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                </div>

            </div>
            @endif

            <div class="item item-2">

                <div class="earnings-item" style="filter:blur(2px)">
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3">
                        <h5 class="text-white font-bold">Earnings</h5>

                        <div class="d-flex">
                            <div class="d-flex align-items-center">
                                <div class="legend" style="background-color: #0e73e4;"></div>
                                <p class="m-0 ms-2">Mining</p>
                            </div>
                            <div class="d-flex align-items-center ms-3">
                                <div class="legend" style="background-color: #d7f0ff;"></div>
                                <p class="m-0 ms-2">Commissions</p>
                            </div>
                        </div>
                    </div>

                    <div class="container p-0">
                        <!-- First row: two items -->
                        <div class="grid-container mb-3">
                            <div class="earning element-1 first">
                                <div class="d-flex align-items-center mb-1">
                                    <img class="currency-icon m-0" src="{{ asset('assets/themes/light/images/icons/CurrencyCircleDollar.svg') }}" />
                                    <p class="m-0 ms-2 subtitle">Earnings (cummulative)</p>
                                </div>
                                <div class="d-flex align-items-center">
                                    <img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                    <p class="m-0 ms-2 font-bold currency">{{$earning_cummulative}}</p>
                                </div>
                            </div>
                            <div class="earning element-2">
                                <div class="d-flex align-items-center mb-1">
                                    <img class="currency-icon m-0" src="{{ asset('assets/themes/light/images/icons/CurrencyCircleDollar.svg') }}" />
                                    <p class="m-0 ms-1 subtitle">Earnings (last month)</p>
                                </div>
                                <div class="d-flex align-items-center">
                                    <img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                    <p class="m-0 ms-1 font-bold currency">0.000</p>
                                </div>
                            </div>
                        </div> 

                        <!-- Second row: three items -->
                        <div class="grid-container-second-row">
                            <div class="earning element-3">
                                <div class="d-flex align-items-center mb-1">
                                    <img src="{{ asset('assets/themes/light/images/icons/Referral-Icon.svg') }}" />
                                    <p class="m-0 ms-1 subtitle">Referral Commission</p>
                                </div>
                                <div class="d-flex align-items-center">
                                    <img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                    <p class="m-0 ms-1 font-bold currency">{{$referral_commision}}</p>
                                </div>
                            </div>
                            <div class="earning element-4">
                                <div class="d-flex align-items-center mb-1">
                                    <img src="{{ asset('assets/themes/light/images/icons/Coin-Icon.svg') }}" />
                                    <p class="m-0 ms-1 subtitle">Daily Coins Generated</p>
                                </div>
                                <div class="d-flex align-items-center">
                                    <img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                    <p class="m-0 ms-1 font-bold currency">{{$daily_coin_generated}}</p>
                                </div>
                                <span>{{ now()->subDay()->format('d/m/y') }}
                                </span>
                            </div>
                            <div class="earning element-5">
                                <div class="d-flex align-items-center mb-1">
                                    <img src="{{ asset('assets/themes/light/images/icons/Graph-Icon.svg') }}" />
                                    <p class="m-0 ms-1 subtitle">Avg. Hashrate Daily</p>
                                </div>
                                <p class="m-0 ms-1 font-bold">{{$average_hashrate}}</p>
                                <span>{{ now()->subDay()->format('d/m/y') }}
                                </span>
                            </div>
                        </div>
                    </div>

                    <hr class="separator">

                    <!--Graph-->
                    <div>
                        <div id="exampleGraph2"></div>
                    </div>
                </div>

            </div>

            <div class="item item-3">

                <div class="common-item recent-transactions" style="filter: blur(2px);"> 
                    <h6 class="mb-4 ps-2 text-white font-bold">Recent Transactions</h6>

                    <div class="mb-4 pb-2">
                        @foreach($recent_transaction as $trx):
                        <div class="d-flex align-items-center mb-3">
                            <div>
                                <img src="{{ asset('assets/themes/light/images/icons/ThunderCoinIcon.svg') }}" />
                            </div>
                            <div class="d-flex flex-column ms-3" style="flex-grow:1;margin-left:0.8rem;">
                                <p style="margin-bottom: 0.2rem;" class="font-bold">{{ $trx->plan->plan_name }} x{{$trx->quantity}}</p>
                                <span class="me-2">
                                    <strong>Purchased at:</strong> {{ \Carbon\Carbon::parse($trx->created_at)->format('d-m-Y') }}
                                </span>
                                <span class="me-2">
                                    <strong>Start:</strong> {{ \Carbon\Carbon::parse($trx->created_at)->addDay()->format('d-m-Y') }}
                                </span>
                                <span>
                                    <strong>Expiry:</strong> {{ \Carbon\Carbon::parse($trx->plan_expiry_date)->format('d-m-Y') }}
                                </span>

                            </div>
                            <div class="d-flex flex-column align-items-end">
                                <p class="m-0 ms-1" style="font-weight: 800;">USD {{ number_format($trx->invest_amount, 2) }}</p>
                                <!-- <span>via <span class="text-primary">Petarigs</span><span> -->
                                </div>
                            </div>
                            @endforeach
                        </div>

                        <a href="{{route('user.transaction.transaction-history')}}" class="common-button text-white text-center">See All Transactions <i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                    </div>

                </div>

                <div class="item item-4">

                    <div class="common-item">
                        <h6 class="mb-4 ps-2 text-white font-bold">Referral Code</h6>

                        <div class="copyLinkContainer d-flex justify-content-between align-items-center copy-link mb-2" data-bs-toggle="popover" data-bs-trigger="manual" data-bs-placement="top" data-bs-content="Copied to clipboard">
                            <input type="text" class="border-0 bg-transparent text-white" value="https://petarig.fireworksmedia.com/project/register?ref={{$referral_code}}" readonly />
                            <div class="copyLinkBtn copy-btn">
                                <i class="fa-regular fa-clone fa-rotate-180 fa-sm ps-2"></i>
                                Copy Link
                            </div>
                        </div>

                        <p class="m-0 my-2 referral-first-copy">or you can copy the code below</p>

                        <div class="copyCodeContainer d-flex justify-content-between align-items-center copy-link mb-3" data-bs-toggle="popover" data-bs-trigger="manual" data-bs-placement="top" data-bs-content="Copied to clipboard">
                            <input type="text" class="border-0 bg-transparent text-white" value="{{$referral_code}}" readonly />
                            <div class="copyCodeBtn copy-btn">
                                <i class="fa-regular fa-clone fa-rotate-180 fa-sm ps-2"></i>
                                Copy
                            </div>
                        </div>

                        <p class="mb-0 referral-second-copy">Refer your friends and earn commission</p>
                    </div>

                </div>

                <div class="item item-5">

                    <div class="common-item" style="filter: blur(2px);">
                        <div class="d-flex justify-content-between align-items-center">
                            <h6 class="ps-2 text-white font-bold">Agent Status</h6>
                            @if($agent_verify) 
                            <span class="badge qualified-badge"><i class="fa-solid fa-circle fa-sm me-1"></i> Qualified</span>
                            @else
                            <span class="badge pending-badge"><i class="fa-solid fa-circle fa-sm me-1"></i> Pending</span>
                            @endif
                        </div>

                        <!-- <div class="d-flex justify-content-between align-items-center agent mb-4 py-2 text-white">
                            All tasks are completed and now you're qualified
                        </div> -->

                        <!-- If user is 'Approved', hide this whole section -->
                        @if(!$agent_verify)
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="d-flex align-items-center">
                                <p class="m-0">Book Training</p>
                            </div>

                            <a href="">Start <i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                        </div>
                        @endif
                    </div>

                </div>

                <div class="item item-6">

                    <div class="common-item">
                        <h6 class="mb-4 ps-2 text-white font-bold">Affiliate Program</h6>

                        <table class="referral-table w-100 mb-3">
                            <tbody>
                                <tr>
                                    <td colspan="2" class="first-col">
                                        Level 1
                                        <span class="referral-badge ms-1">{{$lvl1percentage}}%</span>
                                    </td>
                                    <td>
                                        <div class="border-right">
                                           {{$lvl1}} referrals
                                           <div>
                                           </td>
                                           <td class="font-bold d-flex justify-content-center align-items-center currency">
                                            <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                            <span>{{$lvl1_total}}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" class="first-col">
                                            Level 2
                                            <span class="referral-badge ms-1">{{$lvl2percentage}}%</span>
                                        </td>
                                        <td>
                                            <div class="border-right">
                                               {{$lvl2}} referrals
                                               <div>
                                               </td>
                                               <td class="font-bold d-flex justify-content-center align-items-center currency">
                                                <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                <span>{{$lvl2_total}}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" class="first-col">
                                                Level 3
                                                <span class="referral-badge ms-1">{{$lvl3percentage}}%</span>
                                            </td>
                                            <td>
                                                <div class="border-right">
                                                    {{$lvl3}} referrals
                                                    <div>
                                                    </td>
                                                    <td class="font-bold d-flex justify-content-center align-items-center currency">
                                                        <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                        <span>{{$lvl3_total}}</span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>

                                        <a href="{{ route('user.affiliate.program') }}" class="text-white">See All Referrals <i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                                    </div>

                                </div>

                                <div class="item item-7" style="filter: blur(2px);">
                                    <div class="common-item transactions">
                                        <h6 class="mb-4 ps-2 text-white font-bold">Rewards Transactions</h6>
                                        <?php if(!$transaction_allocation){?>
                                            <span class="ms-2">No records available at the moment</span>
                                        <?php } ?>
                                        <?php foreach($transaction_allocation as $trs){ ?>
                                            <div class="border-bottom mb-3">
                                                <p class="mb-0 title">{{ $trs['month_allocation'] }}</p>
                                                <div class="content d-flex justify-content-between align-items-center">
                                                    <div class="d-flex align-items-center">
                                                        <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                        <span class="ms-2">Dogecoin</span>
                                                    </div>
                                                    <span class="subtitle">{{ $trs['amount'] }}</span>
                                                </div>
                                                <div class="content d-flex justify-content-between align-items-center">
                                                    <a href="https://blockexplorer.one/doge/testnet/tx/{{$trs['txid']}}" target="_blank">Check Transaction</a>
                                                </div>
                                            </div>
                                        <?php } ?>

                                    </div>
                                </div>

                            </div>

                            <div class="my-grid d-none d-lg-grid">

                                <div class="grid-left">

                                    <div class="item item-2">

                                        <div class="earnings-item" style="filter: blur(2px);">
                                            <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3">
                                                <h5 class="text-white font-bold">Earnings</h5>

                                                <div class="d-flex">
                                                    <div class="d-flex align-items-center">
                                                        <div class="legend" style="background-color: #0e73e4;"></div>
                                                        <p class="m-0 ms-2">Mining</p>
                                                    </div>
                                                    <div class="d-flex align-items-center ms-3">
                                                        <div class="legend" style="background-color: #d7f0ff;"></div>
                                                        <p class="m-0 ms-2">Commissions</p>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="container">
                                                <!-- First row: two items -->
                                                <div class="grid-container mb-3">
                                                    <div class="earning element-1 first">
                                                        <div class="d-flex align-items-center mb-1">
                                                            <img class="currency-icon m-0" src="{{ asset('assets/themes/light/images/icons/CurrencyCircleDollar.svg') }}" />
                                                            <p class="m-0 ms-2 subtitle">Earnings (cummulative)</p>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                            <p class="m-0 ms-2 font-bold currency">{{$earning_cummulative}}</p>
                                                        </div>
                                                    </div>
                                                    <div class="earning element-2">
                                                        <div class="d-flex align-items-center mb-1">
                                                            <img class="currency-icon m-0" src="{{ asset('assets/themes/light/images/icons/CurrencyCircleDollar.svg') }}" />
                                                            <p class="m-0 ms-1 subtitle">Earnings (last month)</p>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                            <p class="m-0 ms-1 font-bold currency">{{$earning_last_month}}</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Second row: three items -->
                                                <div class="grid-container-second-row">
                                                    <div class="earning element-3">
                                                        <div class="d-flex align-items-center mb-1">
                                                            <img src="{{ asset('assets/themes/light/images/icons/Referral-Icon.svg') }}" />
                                                            <p class="m-0 ms-1 subtitle">Referral Commission</p>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                            <p class="m-0 ms-1 font-bold currency">{{$referral_commision}}</p>
                                                        </div>
                                                    </div>
                                                    <div class="earning element-4">
                                                        <div class="d-flex align-items-center mb-1">
                                                            <img src="{{ asset('assets/themes/light/images/icons/Coin-Icon.svg') }}" />
                                                            <p class="m-0 ms-1 subtitle">Daily Coins Generated</p>
                                                        </div>
                                                        <div class="d-flex align-items-center">
                                                            <img class="currency-coin" src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                            <p class="m-0 ms-1 font-bold currency">{{$daily_coin_generated}}</p>
                                                        </div>
                                                        <span>{{ now()->subDay()->format('d/m/y') }}
                                                        </span>
                                                    </div>
                                                    <div class="earning element-5">
                                                        <div class="d-flex align-items-center mb-1">
                                                            <img src="{{ asset('assets/themes/light/images/icons/Graph-Icon.svg') }}" />
                                                            <p class="m-0 ms-1 subtitle">Avg. Hashrate Daily</p>
                                                        </div>
                                                        <p class="m-0 ms-1 font-bold">{{$average_hashrate}}</p>
                                                        <span>{{ now()->subDay()->format('d/m/y') }}
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <hr class="separator">

                                            <!--Graph-->
                                            <div>
                                                <div id="exampleGraph"></div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="item item-3">

                                        <div class="common-item recent-transactions" style="filter: blur(2px);">
                                            <h6 class="mb-4 ps-2 text-white font-bold">Recent Transactions</h6>

                                            <div class="mb-4 pb-2">
                                              @foreach($recent_transaction as $transaction)
                                              <div class="d-flex align-items-center mb-3">
                                                <div>
                                                    <img src="{{ asset('assets/themes/light/images/icons/ThunderCoinIcon.svg') }}" />
                                                </div>
                                                <div class="d-flex flex-column ms-3" style="flex-grow:1;margin-left:0.8rem;">
                                                    <p style="margin-bottom: 0.2rem;" class="font-bold">{{$transaction->plan->plan_name}} x {{$transaction->quantity}}</p>
                                                    <span class="me-2">
                                                        <strong>Purchased at:</strong> {{ \Carbon\Carbon::parse($trx->created_at)->format('d-m-Y') }}
                                                    </span>
                                                    <span class="me-2">
                                                        <strong>Start:</strong> {{ \Carbon\Carbon::parse($trx->created_at)->addDay()->format('d-m-Y') }}
                                                    </span>
                                                    <span>
                                                        <strong>Expiry:</strong> {{ \Carbon\Carbon::parse($trx->plan_expiry_date)->format('d-m-Y') }}
                                                    </span>
                                                </div>
                                                <div class="d-flex flex-column align-items-end">
                                                    <p class="m-0 ms-1" style="font-weight: 800;">USD {{ number_format($transaction->invest_amount, 2) }}</p>
                                                    <!-- <span>via <span class="text-primary">Petarigs</span><span> -->
                                                    </div>
                                                </div>
                                                @endforeach
                                                
                                            </div>

                                            <a href="{{route('user.transaction.transaction-history')}}" class="common-button text-white text-center">See All Transactions <i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                                        </div>

                                    </div>

                                </div>

                                <div class="grid-right">
                                    @if(!$insert_wallet)
                                    <div class="item item-1">
                                        <div class="wallet-item">
                                            <img src="{{ asset('assets/themes/light/images/icons/Info.svg') }}" alt="Info icon" />
                                            <p>Purchase Subscription to start receiving rewards</p>
                                            <a href="{{ route('user.plans') }}">Add Subscription <i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                                        </div>
                                    </div>
                                    @endif

                                    <div class="item item-4">

                                        <div class="common-item">
                                            <h6 class="mb-4 ps-2 text-white font-bold">Referral Code</h6>

                                            <div class="copyLinkContainer d-flex justify-content-between align-items-center copy-link mb-2" data-bs-toggle="popover" data-bs-trigger="manual" data-bs-placement="top" data-bs-content="Copied to clipboard">
                                                <input type="text" class="border-0 bg-transparent text-white" value="https://petarig.fireworksmedia.com/project/register?ref={{$referral_code}}" readonly />
                                                <div class="copyLinkBtn copy-btn">
                                                    <i class="fa-regular fa-clone fa-rotate-180 fa-sm ps-2"></i>
                                                    Copy Link
                                                </div>
                                            </div>

                                            <p class="m-0 my-2 referral-first-copy">or you can copy the code below</p>

                                            <div class="copyCodeContainer d-flex justify-content-between align-items-center copy-link mb-3" data-bs-toggle="popover" data-bs-trigger="manual" data-bs-placement="top" data-bs-content="Copied to clipboard">
                                                <input type="text" class="border-0 bg-transparent text-white" value="{{$referral_code}}" readonly />
                                                <div class="copyCodeBtn copy-btn">
                                                    <i class="fa-regular fa-clone fa-rotate-180 fa-sm ps-2"></i>
                                                    Copy
                                                </div>
                                            </div>

                                            <p class="mb-0 referral-second-copy">Refer your friends and earn commission</p>
                                        </div>

                                    </div>

                                    <div class="item item-5">

                                        <div class="common-item" style="filter: blur(2px);">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h6 class="ps-2 text-white font-bold">Agent Status</h6>
                                                @if($agent_verify) 
                                                <span class="badge qualified-badge"><i class="fa-solid fa-circle fa-sm me-1"></i> Qualified</span>
                                                @else
                                                <span class="badge pending-badge"><i class="fa-solid fa-circle fa-sm me-1"></i> Pending</span>
                                                @endif
                                            </div>

                                            <!-- <div class="d-flex justify-content-between align-items-center agent mb-4 py-2 text-white">
                                                All tasks are completed and now you're qualified
                                            </div> -->

                                            <!-- If user is 'Approved', hide this whole section -->
                                            @if(!$agent_verify)
                                            <div class="d-flex justify-content-between align-items-center mt-3">
                                                <div class="d-flex align-items-center">
                                                    <p class="m-0">Book Training</p>
                                                </div>

                                                <a href="">Start <i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                                            </div>
                                            @endif
                                        </div>

                                    </div>

                                    <div class="item item-6">

                                        <div class="common-item">
                                            <h6 class="mb-4 ps-2 text-white font-bold">Affiliate Program</h6>

                                            <table class="referral-table w-100 mb-3">
                                                <tbody>
                                                    <tr>
                                                        <td colspan="2" class="first-col">
                                                            Level 1
                                                            <span class="referral-badge ms-1">{{$lvl1percentage}}%</span>
                                                        </td>
                                                        <td>
                                                            <div class="border-right">
                                                                {{$lvl1}} referrals
                                                                <div>
                                                                </td>
                                                                <td class="font-bold d-flex justify-content-center align-items-center currency">
                                                                    <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                                    <span>{{$lvl1_total}}</span>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" class="first-col">
                                                                    Level 2
                                                                    <span class="referral-badge ms-1">{{$lvl2percentage}}%</span>
                                                                </td>
                                                                <td>
                                                                    <div class="border-right">
                                                                       {{$lvl2}} referrals
                                                                       <div>
                                                                       </td>
                                                                       <td class="font-bold d-flex justify-content-center align-items-center currency">
                                                                        <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                                        <span>{{$lvl2_total}}</span>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td colspan="2" class="first-col">
                                                                        Level 3
                                                                        <span class="referral-badge ms-1">{{$lvl3percentage}}%</span>
                                                                    </td>
                                                                    <td>
                                                                        <div class="border-right">
                                                                          {{$lvl3}} referrals
                                                                          <div>
                                                                          </td>
                                                                          <td class="font-bold d-flex justify-content-center align-items-center currency">
                                                                            <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                                            <span>{{$lvl3_total}}</span>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>

                                                            <a href="{{ route('user.affiliate.program') }}" class="text-white">See All Referrals <i class="fa-solid fa-arrow-right-long fa-sm ms-1"></i></a>
                                                        </div>

                                                    </div>

                                                    <div class="item item-7">
                                                        <div class="common-item transactions" style="filter: blur(2px);">
                                                            <h6 class="mb-4 ps-2 text-white font-bold">Rewards Transactions</h6>
                                        <?php if(!$transaction_allocation){?>
                                            <span class="ms-2">No records available at the moment</span>
                                        <?php } ?>
                                                            <?php foreach($transaction_allocation as $trs){ ?>
                                                                <div class="border-bottom mb-3">
                                                                    <p class="mb-0 title">{{ $trs['month_allocation'] }}</p>
                                                                    <div class="content d-flex justify-content-between align-items-center">
                                                                        <div class="d-flex align-items-center">
                                                                            <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" />
                                                                            <span class="ms-2">Dogecoin</span>
                                                                        </div>
                                                                        <span class="subtitle">{{ $trs['amount'] }}</span>
                                                                    </div>
                                                                    <div class="content d-flex justify-content-between align-items-center">
                                                                        <a href="https://blockexplorer.one/doge/testnet/tx/{{$trs['txid']}}" target="_blank">Check Transaction</a>
                                                                    </div>
                                                                </div>
                                                            <?php } ?>
                                                        </div>
                                                    </div>

                                                </div>

                                            </div>


</div>

@endsection



@push('js-lib')

<script src="{{ asset('assets/admin/js/moment.min.js') }}"></script>

<script src="{{ asset('assets/global/js/daterangepicker.min.js') }}"></script>

<script src="{{ asset('assets/admin/js/tom-select.complete.min.js') }}"></script>

@endpush



@push('css-lib')

<link rel="stylesheet" href="{{ asset('assets/admin/css/tom-select.bootstrap5.css') }}">

<link rel="stylesheet" href="{{ asset('assets/global/css/daterangepicker.css') }}">

@endpush



@push('script')

<script>
    $(document).ready(function() {

        function cb(start, end) {

            $('.js-daterangepicker-predefined-preview').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));

        }


        function cb2(start, end) {

            $('.js-daterangepicker-deposit-payout-predefined-preview').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));



        }

        function cb3(start, end) {

            $('.js-daterangepicker-transaction-predefined-preview').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));



        }



        $('.js-daterangepicker-predefined').daterangepicker({

            startDate: moment().startOf('month'),

            endDate: moment().endOf('month'),

            ranges: {

                'Today': [moment(), moment()],

                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],

                'Last 7 Days': [moment().subtract(6, 'days'), moment()],

                'Last 30 Days': [moment().subtract(29, 'days'), moment()],

                'This Month': [moment().startOf('month'), moment().endOf('month')],

                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]

            }

        }, cb);



        $('.js-daterangepicker-deposit-payout-predefined').daterangepicker({

            startDate: moment().startOf('month'),

            endDate: moment().endOf('month'),

            ranges: {

                'Today': [moment(), moment()],

                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],

                'Last 7 Days': [moment().subtract(6, 'days'), moment()],

                'Last 30 Days': [moment().subtract(29, 'days'), moment()],

                'This Month': [moment().startOf('month'), moment().endOf('month')],

                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]

            }

        }, cb2);



        $('.js-daterangepicker-transaction-predefined').daterangepicker({

            startDate: moment().startOf('month'),

            endDate: moment().endOf('month'),

            ranges: {

                'Today': [moment(), moment()],

                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],

                'Last 7 Days': [moment().subtract(6, 'days'), moment()],

                'Last 30 Days': [moment().subtract(29, 'days'), moment()],

                'This Month': [moment().startOf('month'), moment().endOf('month')],

                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]

            }

        }, cb3);

        cb(moment().startOf('month'), moment().endOf('month'));

        cb2(moment().startOf('month'), moment().endOf('month'));

        cb3(moment().startOf('month'), moment().endOf('month'));


        async function InvestHistory() {

            let dateRange = $('.js-daterangepicker-predefined').data('daterangepicker');

            let startDate = dateRange.startDate.format('YYYY-MM-DD');

            let endDate = dateRange.endDate.format('YYYY-MM-DD');



            try {
                const response = {
                    data: {
                        labels: ['2025-04-01', '2025-04-02', '2025-04-03', '2025-04-04', '2025-04-05'],
                        datasets: [{
                            name: 'Investment Value',
                            data: [1000, 1200, 1100, 1500, 1300]
                        }]
                    }
                };

                // Update chart with dummy data
                if (response.data && response.data.labels && response.data.datasets) {
                    chart.updateOptions({
                        xaxis: {
                            categories: response.data.labels
                        }
                    });

                    chart.updateSeries(response.data.datasets);
                }

                Notiflix.Block.remove('#investHistoryCard');
            } catch (error) {
                console.error("Error fetching investment history:", error);
                Notiflix.Block.remove('#investHistoryCard');
            }

        }



        $('.js-daterangepicker-predefined').on('apply.daterangepicker', InvestHistory);

        async function depositPayoutHistory() {

            let dateRange = $('.js-daterangepicker-deposit-payout-predefined').data('daterangepicker');

            let startDate = dateRange.startDate.format('YYYY-MM-DD');

            let endDate = dateRange.endDate.format('YYYY-MM-DD');



            await axios.get('', {

                params: {

                    start_date: startDate,

                    end_date: endDate

                }

            })

            .then(function(response) {

                depositPayoutChart.updateOptions({

                    xaxis: {

                        categories: response.data.labels

                    }

                });



                let newSeries = [{

                    name: 'Deposit',

                    data: response.data.deposits

                }, {

                    name: 'Payout',

                    data: response.data.payouts

                }];

                depositPayoutChart.updateSeries(newSeries)

                Notiflix.Block.remove('#depositPayoutHistoryCard');

            })

            .catch(function(error) {



            })

        }



        $('.js-daterangepicker-deposit-payout-predefined').on('apply.daterangepicker', depositPayoutHistory);



        async function transactionHistory() {

            let dateRange = $('.js-daterangepicker-transaction-predefined').data('daterangepicker');

            let startDate = dateRange.startDate.format('YYYY-MM-DD');

            let endDate = dateRange.endDate.format('YYYY-MM-DD');

            await axios.get('', {

                params: {

                    start_date: startDate,

                    end_date: endDate

                }

            })

            .then(function(response) {



                TransactionChart.updateOptions({

                    xaxis: {

                        categories: response.data.labels

                    }

                });





                let newSeries = [{

                    name: 'Transaction',

                    data: response.data.transactions

                }];

                TransactionChart.updateSeries(newSeries)

                Notiflix.Block.remove('#TransactionHistoryCard');

            })

            .catch(function(err) {

                console.error(err)

            })

        }



        $('.js-daterangepicker-transaction-predefined').on('apply.daterangepicker', transactionHistory);



        var options = {
            chart: {
                type: 'bar',
                width: '100%',
                height: 350,
                stacked: true,
                toolbar: {
                    show: false
                },
                animations: {
                    enabled: true
                },
                events: {
                    mounted: (chartContext) => {
                        chartContext.windowResizeHandler();
                    }
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: '50%',
                    borderRadius: 8,
                    borderRadiusApplication: 'end',
                    rangeBarOverlap: true
                }
            },
            dataLabels: {
                enabled: false
            },
            series: [
                {
                    name: 'Mining',
                    data: {!! $miningData !!}
                },
                {
                    name: 'Commission',
                    data: {!! $commissionData !!}
                }
            ],
            xaxis: {
                categories: {!! $months !!},
                labels: {
                    style: {
                        colors: '#fff',
                        fontWeight: 700
                    }
                }
            },
            yaxis: {
                title: {
                    style: {
                        color: '#fff',
                        fontWeight: 700
                    }
                },
                labels: {
                    formatter: function (value) {
                        return value;
                    },
                    style: {
                        cssClass: 'y-axis-icon',
                        colors: '#fff',
                        fontWeight: 700
                    }
                }
            },
            grid: {
                strokeDashArray: 4
            },
            colors: [
                "rgba(14, 115, 228, 1)", 
                "#ccc"
            ],
            legend: {
                show: false
            },
            tooltip: {
                style: {
                    fontSize: '14px',
                    fontFamily: 'inherit',
                    color: '#fff'
                },
                theme: 'dark',
            }
        };


        const isCollapsed = document.getElementById("sidebar").classList.contains("collapsed-sidebar");
        const expectedWidth = isCollapsed ? 60 : 300; // Adjust 250 if your expanded sidebar width is different

        waitForSidebarReady(expectedWidth, () => {
            const chart = new ApexCharts(document.querySelector("#exampleGraph"), options);
            const chart2 = new ApexCharts(document.querySelector("#exampleGraph2"), options);
            chart.render();
            chart2.render();
        });

    });

function waitForSidebarReady(targetWidth, callback) {
    const sidebar = document.getElementById("sidebar");

    let retries = 0;
    const maxRetries = 20;

    function checkWidth() {
        const currentWidth = sidebar.offsetWidth;

        if (currentWidth === targetWidth || retries >= maxRetries) {
                callback(); // Sidebar ready or max attempts
            } else {
                retries++;
                requestAnimationFrame(checkWidth);
            }
        }

        checkWidth();
    }

    $(document).ready(function() {

        $('[data-bs-toggle="tooltip"]').tooltip();



        $('.item').hover(function() {

            $(this).tooltip('show');

        }, function() {

            $(this).tooltip('hide');

        });

    });


    // Initialize Bootstrap popovers
    $('.copyLinkContainer').each(function () {
        var $container = $(this);
        var $input = $container.find('input');
        var $btn = $container.find('.copyLinkBtn');
        var popover = new bootstrap.Popover($container[0], { trigger: 'manual' });

        $btn.on('click', function () {
            navigator.clipboard.writeText($input.val()).then(function () {
                popover.show();
                setTimeout(() => popover.hide(), 1000);
            });
        });
    });

    $('.copyCodeContainer').each(function () {
        var $container = $(this);
        var $input = $container.find('input');
        var $btn = $container.find('.copyCodeBtn');
        var popover = new bootstrap.Popover($container[0], { trigger: 'manual' });

        $btn.on('click', function () {
            navigator.clipboard.writeText($input.val()).then(function () {
                popover.show();
                setTimeout(() => popover.hide(), 1000);
            });
        });
    });
</script>

@endpush





@push('style')

<style>
    .btn.dropdown-toggle {

        display: -ms-inline-flexbox;

        display: inline-flex;

        -ms-flex-align: center;

        align-items: center;

    }



    .dropdown-toggle {

        position: relative;

        display: -ms-flexbox;

        display: flex;

        -ms-flex-align: center;

        align-items: center;

        overflow: hidden;

    }



    .btn-white {

        background-color: #fff !important;

        border: .0625rem solid rgba(231, 234, 243, .7) !important;

    }



    .dropdown-toggle {

        white-space: nowrap;

    }



    .btn-group-sm>.btn,
    .btn-sm {

        --bs-btn-padding-y: 0.5rem;

        --bs-btn-padding-x: 1rem;

        --bs-btn-font-size: 0.8125rem;

        --bs-btn-border-radius: 0.3125rem;

    }



    .btn {

        --bs-btn-padding-x: 1rem;

        --bs-btn-padding-y: 0.6125rem;

        --bs-btn-font-size: 0.875rem;

        --bs-btn-font-weight: 400;

        --bs-btn-line-height: 1.5;

        --bs-btn-color: #677788;

        --bs-btn-bg: transparent;

        --bs-btn-border-width: 0.0625rem;

        --bs-btn-border-color: transparent;

        --bs-btn-border-radius: 0.3125rem;

        --bs-btn-hover-border-color: transparent;

        --bs-btn-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.15), 0 1px 1px rgba(0, 0, 0, 0.075);

        --bs-btn-disabled-opacity: 0.65;

        --bs-btn-focus-box-shadow: 0 0 0 0 rgba(var(--bs-btn-focus-shadow-rgb), .5);

        display: inline-block;

        padding: var(--bs-btn-padding-y) var(--bs-btn-padding-x);

        font-family: var(--bs-btn-font-family);

        font-size: var(--bs-btn-font-size);

        font-weight: var(--bs-btn-font-weight);

        line-height: var(--bs-btn-line-height);

        color: var(--bs-btn-color);

        text-align: center;

        vertical-align: middle;

        cursor: pointer;

        -webkit-user-select: none;

        -moz-user-select: none;

        -ms-user-select: none;

        user-select: none;

        border: var(--bs-btn-border-width) solid var(--bs-btn-border-color);

        border-radius: var(--bs-btn-border-radius);

        background-color: var(--bs-btn-bg);

        transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;

    }



    .ms-1 {

        margin-left: .25rem !important;

    }



    .report-item:not(:last-child) {

        margin-bottom: 3px;

    }



    .report-item {

        display: flex;

        align-items: center;

        justify-content: space-between;

    }



    .box-custom {

        padding: 20px;

        background-color: var(--bg-color2);

        border-radius: 25px;

        align-items: center;

        gap: 20px;

    }



    .report-item span {

        font-size: 14px;

        display: inline-block;

    }



    .report-item strong {

        font-size: 14px;

        font-weight: bolder;

    }



    .report-item i {

        font-size: 1.125rem;

        color: rgb(var(--primary-color));

        margin-right: 5px;

    }



    .custom-card {

        height: 400px;

        overflow-y: auto;

        padding: 0 20px !important;

        margin: 20px 0;

    }



    .no-data {

        height: 450px;

    }
</style>

@endpush