@php
use Illuminate\Support\Str;
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <link href="{{ getFile(basicControl()->favicon_driver, basicControl()->favicon) }}" rel="icon">


    <title>{{trans('Dashboard')}} | @lang(basicControl()->site_title) </title>

    <meta name="csrf-token" content="{{csrf_token()}}">

    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/all.min.css') }}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/flatpickr-min.css') }}"/>
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/bootstrap.min.css') }}"/>
    <link rel="stylesheet" href="{{ asset('assets/admin/css/fontawesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/select2.min.css') }}"/>
    <link href="{{asset(template(true).'css/swiper.min.css')}}" rel="stylesheet">
    <!-- custom css -->
    <link rel="stylesheet" href="{{ asset($themeTrue . 'css/user-style.css') }}?v={{ time() }}"/>

    <!-- owl carousel -->
    <link rel="stylesheet" href="{{asset($themeTrue.'css/owl.carousel.min.css')}}"/>
    <link rel="stylesheet" href="{{asset($themeTrue.'css/owl.theme.default.min.css')}}"/>
    <link rel="stylesheet" href="{{asset($themeTrue.'css/apexcharts.css')}}"/>
    <link href="{{asset($themeTrue.'css/fancy-box-carusol.css')}}" rel="stylesheet">
    @stack('css-lib')
    @stack('style')
</head>

<body onload="preloaderFunction()" >


    <div id="preloader">
        <div class="load">
            <hr/>
            <hr/>
            <hr/>
            <hr/>
        </div>
    </div>

<!-- Header section start -->
<header id="header" class="header fixed-top d-flex align-items-center">
    <div class="d-flex align-items-center justify-content-between">
        <div class="logo-container">
            <a href="{{route('page')}}" class="logo d-flex align-items-center">
                <img src="{{logo(true)}}" alt="...">
            </a>
        </div>

    </div>
    <!-- End Logo -->

    <nav class="header-nav ms-auto">
        <ul class="nav-icons">
            <li class="nav-item dropdown">

                <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
                   <span class="d-none d-lg-block dropdown-toggle ps-2">
                    {{ Str::title(auth()->user()->firstname.' '.auth()->user()->lastname) }}
                </span>

            </a>

            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
                <li>
                    <a class="dropdown-item d-flex align-items-center" href="{{ route('user.profile') }}">
                        <i class="fa-light fa-user"></i>
                        <span>@lang('Account Settings')</span>
                    </a>
                </li>
                <li>
                    <a class="dropdown-item d-flex align-items-center" href="{{ route('logout') }}"
                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="fa-regular fa-right-from-bracket"></i>
                    <span>@lang('Sign Out')</span>
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </a>
            </li>

        </ul>
    </li>

</ul>
</nav>

</header>
@if($planInvestment = \App\Models\InvestHistory::with('plan')->where('user_id', Auth::id())->first())
@include($theme.'partials.sidebar')
<main id="main" class="main">
    @yield('content')
</main>
<footer id="footer" class="footer">
    <div class="copyright">
        &copy; @lang('Copyright') <strong><span>{{basicControl()->site_title}}</span></strong>. @lang('All Rights Reserved')    </div>
    </footer>
    @else
    <main id="main" class="main" style="margin-left: 0!important">
        @yield('content')
    </main>
    <footer id="footer" class="footer" style="margin-left: 0!important">
        <div class="copyright">
            &copy; @lang('Copyright') <strong><span>{{basicControl()->site_title}}</span></strong>. @lang('All Rights Reserved')    </div>
        </footer>
        @endif
<!-- Footer section end -->

<!-- bootstrap -->
<script src="{{asset($themeTrue.'js/bootstrap.bundle.min.js')}}"></script>
<script src="{{asset($themeTrue.'js/flatpickr-min.js')}}"></script>
<!-- jquery cdn -->
<script src="{{ asset('assets/global/js/jquery.min.js') }}"></script>

<script src="{{asset($themeTrue.'js/apexcharts.min.js')}}"></script>
<script src="{{ asset('assets/global/js/Chart.min.js') }}"></script>
<script src="{{ asset($themeTrue . 'js/select2.min.js') }}"></script>
<script src="{{asset($themeTrue.'js/owl.carousel.min.js')}}"></script>
<script src="{{asset($themeTrue.'js/waypoints.min.js')}}"></script>
<script src="{{ asset('assets/global/js/notiflix-aio-3.2.6.min.js') }}"></script>
<script src="{{ asset('assets/global/js/pusher.min.js') }}"></script>
<script src="{{ asset('assets/global/js/vue.min.js') }}"></script>
<script src="{{ asset('assets/global/js/axios.min.js') }}"></script>
<script src="{{ asset('assets/admin/js/jquery.uploadPreview.min.js') }}"></script>
<script src="{{asset(template(true).'js/swiper.min.js')}}"></script>
<script src="{{asset($themeTrue.'js/custom_share.js')}}"></script>
<script src="{{asset($themeTrue.'js/user-script.js')}}"></script>
@stack('js-lib')
@stack('script')
@include('plugins')


<script>
    function currencyPosition(amount) {
        var currencyPosition = @json(basicControl()->is_currency_position);
        var has_space_between_currency_and_amount = @json(basicControl()->has_space_between_currency_and_amount);
        var currency_symbol = @json(basicControl()->currency_symbol);
        var base_currency = @json(basicControl()->base_currency);
        amount = parseFloat(amount).toFixed(2);
        if (currencyPosition === 'left' && has_space_between_currency_and_amount) {
            return currency_symbol + '  ' + amount;
        } else if (currencyPosition === 'left' && !has_space_between_currency_and_amount) {
            return currency_symbol + ' ' + amount;
        } else if (currencyPosition === 'right' && has_space_between_currency_and_amount) {
            return amount + '  ' + base_currency;
        } else {
            return amount + '  ' + base_currency;
        }
    }
</script>
<script>
    'use strict';
    $(document).on('input', '.global-search', function() {
        var search = $(this).val().toLowerCase();

        if (search.length == 0) {
            $('.search-result').find('.content').html('');
            $(this).siblings('.search-backdrop').addClass('d-none');
            $(this).siblings('.search-result').addClass('d-none');
            return false;
        }

        $('.search-result').find('.content').html('');
        $(this).siblings('.search-backdrop').removeClass('d-none');
        $(this).siblings('.search-result').removeClass('d-none');

        var match = $('.sidebar-nav li').filter(function(idx, element) {
            if (!$(element).find('a').hasClass('has-dropdown') && !$(element).hasClass('menu-header'))
                return $(element).text().trim().toLowerCase().indexOf(search) >= 0 ? element : null;
        }).sort();

        if (match.length == 0) {
            $('.search-result').find('.content').append(
        `<div class="search-item"><a href="javascript:void(0)">No result found</a></div>`);
            return false;
        }

        match.each(function(index, element) {
            var item_text = $(element).text().replace(/(\d+)/g, '').trim();
            var item_url = $(element).find('a').attr('href');
            if (item_url != '#') {
                $('.search-result').find('.content').append(
            `<div class="search-item"><a href="${item_url}">${item_text}</a></div>`);
            }
        });
    });
</script>

<script>
    "use strict";
    var root = document.querySelector(':root');
    root.style.setProperty('--primary-color', '{{basicControl()->primary_color}}');
    root.style.setProperty('--secondary-color', '{{basicControl()->secondary_color}}');
</script>

@if (session()->has('success'))
<script>
    Notiflix.Notify.success("@lang(session('success'))");
</script>
@endif



@if (session()->has('error'))
<script>
    Notiflix.Notify.failure("@lang(session('error'))");
</script>
@endif

@if (session()->has('warning'))
<script>
    Notiflix.Notify.warning("@lang(session('warning'))");
</script>
@endif

</body>
</html>





