@extends($theme.'layouts.login')

@section('title',$page_title)



@section('content')

<style type="text/css">

    .sign-in-input::placeholder {

        color: #D3D3D3;

        font-size: 16px;

        font-weight: 700;

        line-height: 28px;

    }

</style>

<header class="header">

    <div class="logo">

        <img src="{{ asset(template(true).'images/custom/logo.png') }}"  alt="logo">    

    </div>

</header>

<section class="sign-in">

    <div class="container">

        <div class="row d-flex justify-content-center">

            <div class="col-lg-6 col-md-8 col-sm-12">

                <div class="sign-in-container">





                    <div class="sign-in-container-inner">

                        <div class="sign-in-title">

                            <div class="container" style="display: flex;flex-direction: column;align-items: center;margin-top: 50px;margin-bottom: 30px;">

                                <div class="icon">

                                    <img src="{{ asset(template(true).'images/custom/Icon.png') }}"  alt="logo">                  

                                </div>

                                <h4 style="margin:30px;margin-bottom:15px;font-weight: 600;">Two-Factor Authentication</h4>

                                <p>Enter the 6-digit code sent to your email</p>

                                <p><strong>{!! maskEmail(auth()->user()->email) !!}</strong></p>

                            </div>

                        </div>

                        <div class="sign-in-form">

                            <form action="{{ route('user.mail.verify') }}" method="post">

                                @csrf

                                <div class="sign-in-form-group" style="margin-bottom: 35px;margin-top: 35px;">

                                    <input type="text" name="code" value="{{old('code')}}" class="sign-in-input"

                                    placeholder="@lang('Enter Code')" autocomplete="off" required style="text-align: center;">

                                    @error('code')

                                    <span class="invalid-feedback d-block"

                                    role="alert">{{ $message }}<strong></strong>

                                </span>

                                @enderror

                            </div>

                            <div class="signup-account" style="margin:15px">

                                <p style="font-size: 14px;">@lang("Didn't get Code? Click to") <a

                                    href="{{route('user.resend.code')}}?type=email">@lang('Resend code')</a></p>

                                    @error('resend')

                                    <p class="text-danger  mt-1">{{ $message }}</p>

                                    @enderror

                                </div>

                                <div class="sign-in-btn">

                                    <button type="submit" class="btn-1">@lang('Verify')</button>

                                </div>

                            </form>

                            <div class="media-login text-center mt-3 mb-4">

                                <p>
                                    <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                        <i class="fa-solid fa-arrow-left-long"></i> @lang('Back to Login')

                                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">

                                            @csrf

                                        </form>
                                    </a>
                                </p>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</section>

@endsection

