@extends($theme.'layouts.login')

@section('title',trans('Register'))

@section('content')

<style>

    body {

        background-color: #071720 !important;

    }



    .modal .modal-content {



        background: #071720 !important;



    }



    .primary-button {

        width: 100%;

        border-radius: 8px;

        text-align: center;

        justify-content: center;

        background: linear-gradient(90deg, #03228F 0%, #0E73E4 100%);

        padding: 0.7rem 0;

    }



    .primary-button:disabled,

    .primary-button.disabled {

        opacity: 0.6;

        cursor: not-allowed;

        pointer-events: none;

        background: linear-gradient(90deg, #6c757d 0%, #adb5bd 100%);

    }



    .primary-button:not(:disabled):hover {

        filter: brightness(1.1);

    }

</style>

<!-- sign-up -->

<section class="sign-in h-100">

    <div class="container h-100">

        <div class="row my-auto g-4 d-flex justify-content-center h-100">

            <!-- <div class="col-lg-6">

                <div class="sign-in-image-cotainer">

                    <div class="sign-in-logo">

                        <a href="{{route('page')}}"><img src="{{logo(true)}}" alt="image"></a>

                    </div>

                    <div class="sign-in-left-btn">

                        <a href="{{$register_section['single']['media']->button_url??''}}"

                            class="btn-1">{{$register_section['single']['button_name']??''}} <i

                                class="fa-regular fa-arrow-right"></i></a>

                    </div>

                    <div class="sign-in-image">

                        <img src="{{ asset(template(true).'images/custom/Left.png') }}"

                            alt="image">

                    </div>

                </div>

            </div> -->

            <div class="col-lg-6">

                <div class="sign-in-container">

                    <div class="sign-in-container-inner">

                        <div class="sign-in-title">

                            <h3>Register new account</h3>

                            <div class="signup-account">

                                <p>Fill in all fields to create new account</p>

                            </div>

                        </div>

                        <div class="sign-in-form">

                            <form action="{{ route('register') }}" method="post">

                                @csrf

                                <div class="sign-in-form-name">

                                    <div class="sign-in-form-group">

                                        <label>@lang('First Name')</label>

                                        <input type="text" name="first_name" class="sign-in-input" value="{{old('first_name')}}" placeholder="@lang('First Name')" required>

                                        @error('first_name')

                                        <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>

                                        @enderror

                                    </div>

                                    <div class="sign-in-form-group">

                                        <label>@lang('Last Name')</label>

                                        <input type="text" name="last_name" class="sign-in-input" value="{{old('last_name')}}" placeholder="@lang('Last Name')" required>

                                        @error('last_name')

                                        <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>

                                        @enderror

                                    </div>

                                </div>

                                <div class="sign-in-form-group">

                                    <label>@lang('Email')</label>

                                    <input type="email" name="email" class="sign-in-input" value="{{old('email')}}" placeholder="@lang('Enter your email')" required>

                                    @error('email')

                                    <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>

                                    @enderror

                                </div>

                                <div class="sign-in-form-group">

                                    <label>@lang('Password')</label>

                                    <div class="password-box">

                                        <input type="password" name="password" class="sign-in-input password" placeholder="@lang('Password')" autocomplete="off" required>

                                        <i class="password-icon fa-regular fa-eye"></i>

                                    </div>

                                    @error('password')

                                    <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>

                                    @enderror

                                </div>

                                <div class="sign-in-form-group">

                                    <label>@lang('Confirm Password')</label>

                                    <div class="confirm_password_box password-box">

                                        <input type="password" name="password_confirmation" class="sign-in-input password confirm_password" placeholder="@lang('Confirm Password')" autocomplete="off" required>

                                        <i class="password-icon confirm_password_icon  fa-regular fa-eye"></i>

                                    </div>

                                </div>

                                <div class="sign-in-form-group">

                                    <label>@lang('Referral Code') (optional)</label>

                                    <input type="text" name="referral_code" class="sign-in-input" value="{{$referral_code}}" placeholder="@lang('Enter Referral Code')">

                                    @error('referral_code')

                                    <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>

                                    @enderror

                                </div>

                                @if($basicControl->manual_recaptcha === 1 && $basicControl->manual_recaptcha_user_registration === 1)



                                <div class="sign-in-form-group">

                                    <label for="captcha">@lang('Captcha')</label>

                                    <input type="text" name="captcha" id="captcha" class="sign-in-input" placeholder="@lang('Enter captcha')">

                                    @error('captcha')

                                    <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>

                                    @enderror

                                </div>





                                <div class="mt-4">

                                    <div class="input-group captcha-group input-group-merge manualRecaptchaImage" data-hs-validation-validate-class>

                                        <img src="{{route('captcha').'?rand='. rand()}}" id='captcha_image'>

                                        <a class="input-group-append input-group-text manualRecaptchaIcon"

                                            href='javascript: refreshCaptcha();'>

                                            <i class="fa-solid fa-rotate-right"></i>

                                        </a>

                                    </div>

                                </div>

                                @endif



                                @if(basicControl()->google_recaptcha_user_registration && basicControl()->google_recaptcha)

                                <div class="row mt-4">

                                    <div class="g-recaptcha @error('g-recaptcha-response') is-invalid @enderror"

                                        data-sitekey="{{ $siteKey }}"></div>

                                    @error('g-recaptcha-response')

                                    <span class="invalid-feedback d-block text-danger" role="alert">

                                        {{ $message }}

                                    </span>

                                    @enderror

                                </div>

                                @endif

                                <div class="form-check sign-in-form-group d-flex align-items-center">

                                    <input class="form-check-input mt-0" type="checkbox" name="remember" id="remember" required>

                                    <label for="remember" class="mb-0 ms-2">Agree to our Terms of Service</label>

                                </div>



                                <div class="sign-in-btn">

                                    <button type="submit" class="btn-1">@lang('Register New Account') <span></span></button>

                                </div>

                            </form>

                            <div class="media-login" style="text-align: center;">

                                <p><a style="color: black;font-weight: 600" href="{{ route('login') }}">@lang('Have account? Login now')</a></p>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</section>



<div id="InvestModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered modal-fullscreen" role="document">



        <div class="modal-content">



            <div class="modal-header text-white border-0">



                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>



            </div>



            <div class="d-flex justify-content-center align-items-center">



                <form action="{{route('user.investPlan')}}" method="post" class="col-md-8 col-12">



                    @csrf



                    <div class="modal-body">



                        <h3 class="modal-title text-center mb-2" id="contractModalLabel">{{ $contract_content->subject }}</h3>



                        <p class="text-center mb-3">Please read and accept the terms of the contract before proceeding.</p>

                        <div id="terms" class="p-3 bg-light rounded" style="color:white;overflow:scroll;max-height:55vh;">

                            {!! $contract_content->content !!}

                        </div>





                        <div class="form-group d-none">



                            <label class="modal-label" for="balance_type">@lang('Select Wallet')</label>



                            <select class="form-control" name="balance_type">



                                <option value="checkout">@lang('Checkout')</option>



                            </select>



                        </div>



                        <label class="modal-label d-none" for="balance_type">@lang('Enter Amount')</label>



                        <div class="input-group d-none">



                            <input type="text" class="form-control invest-amount" name="amount" id="amount"



                                value=""



                                onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" autocomplete="off"



                                placeholder="@lang('e.g: 100')" />



                            <span class="input-group-text show-currency bg-white">{{basicControl()->currency_symbol}}</span>



                        </div>



                        <input type="hidden" name="plan_id" class="plan-id">



                    </div>



                    <div class="modal-footer border-0">



                        <button type="submit" class="btn-2 primary-button planPurchaseSubmitButton" style="width: 100vw !important;" disabled>Accept the Contract<span></span></button>



                    </div>



                </form>



            </div>



        </div>



    </div>



</div>

<!-- sign-up -->



@endsection



@push('css-lib')

<!-- <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@25.2.0/build/css/intlTelInput.css"> -->

@endpush



@push('js-lib')

<!-- <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@25.2.0/build/js/intlTelInput.min.js"></script>

-->

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

@endpush



@push('script')

<script>

    'use strict';



    function refreshCaptcha() {

        let img = document.images['captcha_image'];

        img.src = img.src.substring(

            0, img.src.lastIndexOf("?")

        ) + "?rand=" + Math.random() * 1000;

    }



    $(document).ready(function() {

        $('#InvestModal').modal({

            backdrop: false

        });

        

        $('#terms').on('scroll', function() {

            var $this = $(this);

            var isAtBottom = $this.scrollTop() + $this.innerHeight() >= this.scrollHeight;



            if (isAtBottom) {

                $('.planPurchaseSubmitButton').prop('disabled', false).removeClass('disabled');

            }

        });



        $('#remember').change(function() {

            if ($(this).is(':checked')) {

                // Trigger modal if checkbox is checked

                $('#InvestModal').modal('show');

            } else {

                // Optionally, you can close the modal or trigger any other action

                $('#InvestModal').modal('hide');

            }

        });

    });



    $(document).on('click', '.planPurchaseSubmitButton', function(e) {

        e.preventDefault();



        $(this).attr('disabled', true);



        $('#InvestModal').modal('hide');



        $('html').css('overflow', 'auto');



    });



    /*    $(document).ready(function (){



                // International Telephone Input start

            const input = document.querySelector("#telephone");

            const iti = window.intlTelInput(input, {

                initialCountry: "bd",

                separateDialCode: true,

            });

            input.addEventListener("countrychange", updateCountryInfo);

            updateCountryInfo();

            function updateCountryInfo() {

                const selectedCountryData = iti.getSelectedCountryData();

                const phoneCode = '+' + selectedCountryData.dialCode;

                const countryCode = selectedCountryData.iso2;

                const countryName = selectedCountryData.name;

                $('#phoneCode').val(phoneCode);

                $('#countryCode').val(countryCode);

                $('#countryName').val(countryName);

            }



            const initialPhone = "{{$user->phone??null}}";

            const initialPhoneCode = "{{$user->phone_code??null}}";

            const initialCountryCode = "{{$user->country_code??null}}";

            const initialCountry = "{{$user->country??null}}";

            if (initialPhoneCode) {

                iti.setNumber(initialPhoneCode);

            }

            if (initialCountryCode) {

                iti.setNumber(initialCountryCode);

            }

            if (initialCountry) {

                iti.setNumber(initialCountry);

            }

            if (initialPhone) {

                iti.setNumber(initialPhone);

            }

        })*/

</script>

@endpush



@push('style')

<style>

    @media(max-width: 991px) {

        .footer-copyright {

            margin-bottom: 0 !important;

        }

    }

</style>

@endpush