@extends('admin.layouts.app')
@section('page_title',__('View Profile'))
@section('content')

<!-- Content -->
<div class="content container-fluid">
    <div class="row justify-content-lg-center">
        <div class="col-lg-10">

            @include('admin.user_management.components.header_user_profile')

            <div class="row">
                <div class="col-lg-4">
                    <div class="card mb-3 mb-lg-5">
                        <div class="card-header card-header-content-between">
                            <h4 class="card-header-title">@lang('Profile')</h4>
                        </div>

                        <div class="card-body">
                            <ul class="list-unstyled list-py-2 text-dark mb-0">
                                <li class="pb-0"><span class="card-subtitle">@lang('About')</span></li>
                                <li>
                                    <i class="bi-person dropdown-item-icon"></i> @lang($user->firstname . ' ' . $user->lastname)
                                </li>
                                <li>
                                    <i class="bi-at dropdown-item-icon"></i> {{ $user->email }}
                                    <i
                                    class="bi-patch-check-fill text-{{ $user->email_verification == 1 ? 'success' : 'danger' }}"
                                    data-bs-toggle="tooltip"
                                    data-bs-placement="top"
                                    aria-label="{{ $user->email_verification == 1 ? 'Email Verified' : 'Email Unverified' }}"
                                    data-bs-original-title="{{ $user->email_verification == 1 ? 'Email Verified' : 'Email Unverified' }}">
                                </i>
                            </li>
                        </ul>
                    </div>
                </div>

            </div>

            <div class="col-lg-8">
                <div class="card card-centered mb-3 mb-lg-5">
                    <div class="card-header card-header-content-between">
                        <h4 class="card-header-title">@lang('Transaction')</h4>
                    </div>


                    @if(count($transactions) == 0)
                    <div class="card-body card-body-height">
                        <img class="avatar avatar-xxl mb-3"
                        src="{{ asset('assets/admin/img/oc-error.svg') }}"
                        alt="Image Description" data-hs-theme-appearance="default"/>
                        <img class="avatar avatar-xxl mb-3"
                        src="{{ asset('assets/admin/img/oc-error-light.svg') }}"
                        alt="Image Description" data-hs-theme-appearance="dark"/>
                        <p class="card-text">@lang('No data to show')</p>
                    </div>
                    @endif

                    @if(0 < count($transactions))
                    <div class="table-responsive">
                        <table
                        class="table table-thead-bordered table-nowrap table-align-middle card-table">
                        <thead class="thead-light">
                            <tr>
                                <th>@lang('No.')</th>
                                <th>@lang('TRX')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Remarks')</th>
                                <th>@lang('Date-Time')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($transactions as $key =>  $transaction)
                            <tr>
                                <td>
                                    {{ $loop->index + 1 }}
                                </td>
                                <td>
                                    {{ $transaction->trx_id }}
                                </td>
                                <td>
                                    <h6 class="mb-0 {{ $transaction->trx_type == '+' ? 'text-success' : 'text-danger' }}">{{ $transaction->trx_type . currencyPosition($transaction->amount) }}</h6>
                                </td>
                                <td> @lang($transaction->remarks)</td>
                                <td>{{ dateTime($transaction->created_at, 'd M Y h:i A') }}</td>
                            </tr>
                            @empty

                            @endforelse
                        </tbody>
                    </table>
                </div>
                @endif
            </div>

            <div class="card card-centered mb-3 mb-lg-5">
                <div class="card-header card-header-content-between">
                    <h4 class="card-header-title">@lang('Referral List')</h4>
                </div>

                <div class="table-responsive">
                    <table class="table table-thead-bordered table-nowrap table-align-middle card-table">
                        <thead class="thead-light">
                            <tr>
                                <th>@lang('Level')</th>
                                <th>@lang('Referrals')</th>
                                <th class="text-end">@lang('Total Earnings')</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    @lang('Level 1') 
                                    <span class="badge bg-soft-primary text-primary ms-2">{{$lvl1percentage}}%</span>
                                </td>
                                <td>
                                    {{ $lvl1 }} @lang('referrals')
                                </td>
                                <td class="text-end">
                                    <span class="d-inline-flex align-items-center">
                                        <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" alt="icon" class="me-1" width="20">
                                        <strong>{{ $lvl1_total }}</strong>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    @lang('Level 2')
                                    <span class="badge bg-soft-secondary text-secondary ms-2">{{$lvl2percentage}}%</span>
                                </td>
                                <td>
                                    {{ $lvl2 }} @lang('referrals')
                                </td>
                                <td class="text-end">
                                    <span class="d-inline-flex align-items-center">
                                        <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" alt="icon" class="me-1" width="20">
                                        <strong>{{ $lvl2_total }}</strong>
                                    </span>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    @lang('Level 3')
                                    <span class="badge bg-soft-info text-info ms-2">{{$lvl3percentage}}%</span>
                                </td>
                                <td>
                                    {{ $lvl3 }} @lang('referrals')
                                </td>
                                <td class="text-end">
                                    <span class="d-inline-flex align-items-center">
                                        <img src="{{ asset('assets/themes/light/images/icons/doge-svgrepo-com 1.svg') }}" alt="icon" class="me-1" width="20">
                                        <strong>{{ $lvl3_total }}</strong>
                                    </span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card card-centered mb-3 mb-lg-5">
                <div class="card-header card-header-content-between">
                    <h4 class="card-header-title">@lang('Referral Listing')</h4>
                </div>

                <div class="table-responsive">
                    <table class="table table-thead-bordered table-nowrap table-align-middle card-table referral-listing mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>@lang('Username')</th>
                                <th>@lang('Email')</th>
                                <th>@lang('Level')</th>
                                <th>@lang('Date Purchased')</th>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach($referral_structure as $index => $level1)
                            @php $hasLevel2 = !empty($level1['level2']); @endphp
                            <tr class="level-1-row">
                                <td class="fw-bold">
                                    @if($hasLevel2)
                                    <button class="btn btn-sm btn-outline-primary toggle-btn" data-target="level1-{{ $index }}">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                    @endif
                                    {{ $level1['username'] }}
                                </td>
                                <td>{{ $level1['email'] }}</td>
                                <td><span class="badge bg-success">Level 1</span></td>
                                <td>{{ $level1['date'] ?: 'N/A' }}</td>
                            </tr>

                            @if($hasLevel2)
                            <tbody class="d-none level1-{{ $index }}">
                                @foreach($level1['level2'] as $l2index => $level2)
                                @php $hasLevel3 = !empty($level2['level3']); @endphp
                                <tr class="level-2-row">
                                    <td class="ps-4">
                                        @if($hasLevel3)
                                        <button class="btn btn-sm btn-outline-secondary toggle-btn" data-target="level2-{{ $index }}-{{ $l2index }}">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                        @endif
                                        {{ $level2['username'] }}
                                    </td>
                                    <td>{{ $level2['email'] }}</td>
                                    <td><span class="badge bg-warning">Level 2</span></td>
                                    <td>{{ $level2['date'] ?: 'N/A' }}</td>
                                </tr>

                                @if($hasLevel3)
                                <tbody class="d-none level2-{{ $index }}-{{ $l2index }}">
                                    @foreach($level2['level3'] as $level3)
                                    <tr class="level-3-row">
                                        <td class="ps-5">{{ $level3['username'] }}</td>
                                        <td>{{ $level3['email'] }}</td>
                                        <td><span class="badge bg-danger">Level 3</span></td>
                                        <td>{{ $level3['date'] ?: 'N/A' }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                @endif
                                @endforeach
                            </tbody>
                            @endif
                            @endforeach
                        </tbody>

                    </table>
                </div>
            </div>




        </div>

    </div>

</div>
</div>
</div>
</div>


@include('admin.user_management.components.login_as_user')
@include('admin.user_management.components.update_balance_modal')
@include('admin.user_management.components.block_profile_modal')

@endsection


@push('script')
<script>
    document.querySelectorAll('.toggle-btn').forEach(button => {
        button.addEventListener('click', function () {
            const targetClass = this.dataset.target;
            const targetElement = document.querySelector(`.${targetClass}`);

            if (!targetElement) return;

            const isExpanding = targetElement.classList.contains('d-none');
            targetElement.classList.toggle('d-none');

            const icon = this.querySelector('i');
            if (icon) {
                icon.classList.remove('fa-plus', 'fa-minus');
                icon.classList.add(isExpanding ? 'fa-minus' : 'fa-plus');
            }

            if (this.classList.contains('btn-outline-primary') || this.classList.contains('btn-primary')) {
                this.classList.toggle('btn-outline-primary', !isExpanding);
                this.classList.toggle('btn-primary', isExpanding);
            }

            if (this.classList.contains('btn-outline-secondary') || this.classList.contains('btn-secondary')) {
                this.classList.toggle('btn-outline-secondary', !isExpanding);
                this.classList.toggle('btn-secondary', isExpanding);
            }
        });
    });
</script>

<script>
    'use strict';
    $(document).on('click', '.loginAccount', function () {
        let route = $(this).data('route');
        $('.loginAccountAction').attr('action', route)
    });

    $(document).on('click', '.blockProfile', function () {
        let route = $(this).data('route');
        $('.blockProfileAction').attr('action', route)
    });

</script>
@endpush







