@extends($theme.'layouts.login')
@section('title',trans('Register'))
@section('content')
<style>
    body {
        background-color: #071720 !important;
    }

    .modal .modal-content {

        background: #071720 !important;

    }

    .primary-button {
        width: 100%;
        border-radius: 8px;
        text-align: center;
        justify-content: center;
        background: linear-gradient(90deg, #03228F 0%, #0E73E4 100%);
        padding: 0.7rem 0;
    }

    .primary-button:disabled,
    .primary-button.disabled {
        opacity: 0.6;
        cursor: not-allowed;
        pointer-events: none;
        background: linear-gradient(90deg, #6c757d 0%, #adb5bd 100%);
    }

    .primary-button:not(:disabled):hover {
        filter: brightness(1.1);
    }
</style>
<section class="sign-in h-100">
    <div class="container h-100">
        <div class="row my-auto g-4 d-flex justify-content-center h-100">

            <div class="col-lg-6">
                <div class="sign-in-container">
                    <div class="sign-in-container-inner">
                        <div class="sign-in-title">
                            <h3>Register new account</h3>
                            <div class="signup-account">
                                <p>Fill in all fields to create new account</p>
                            </div>
                        </div>
                        <div class="sign-in-form">
                            <form action="{{ route('admin.user.register2') }}" method="post">
                                @csrf
                                <div class="sign-in-form-name">
                                    <div class="sign-in-form-group">
                                        <label>@lang('First Name')</label>
                                        <input type="text" name="first_name" class="sign-in-input" value="{{old('first_name')}}" placeholder="@lang('First Name')" required>
                                        @error('first_name')
                                        <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>
                                        @enderror
                                    </div>
                                    <div class="sign-in-form-group">
                                        <label>@lang('Last Name')</label>
                                        <input type="text" name="last_name" class="sign-in-input" value="{{old('last_name')}}" placeholder="@lang('Last Name')" required>
                                        @error('last_name')
                                        <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="sign-in-form-group">
                                    <label>@lang('Email')</label>
                                    <input type="email" name="email" class="sign-in-input" value="{{old('email')}}" placeholder="@lang('Enter your email')" required>
                                    @error('email')
                                    <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>
                                    @enderror
                                </div>
                                <div class="sign-in-form-group">
                                    <label>@lang('Password')</label>
                                    <div class="password-box">
                                        <input type="password" name="password" class="sign-in-input password" placeholder="@lang('Password')" autocomplete="off" required>
                                        <i class="password-icon fa-regular fa-eye"></i>
                                    </div>
                                    @error('password')
                                    <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>
                                    @enderror
                                </div>
                                <div class="sign-in-form-group">
                                    <label>@lang('Confirm Password')</label>
                                    <div class="confirm_password_box password-box">
                                        <input type="password" name="password_confirmation" class="sign-in-input  confirm_password" placeholder="@lang('Confirm Password')" autocomplete="off" required>
                                        <i class="password-icon confirm_password_icon  fa-regular fa-eye"></i>
                                    </div>
                                </div>
                                <div class="sign-in-form-group">
                                    <label>@lang('Referral Code') (optional)</label>
                                    <input type="text" name="referral_code" class="sign-in-input" value="{{$referral_code}}" placeholder="@lang('Enter Referral Code')">
                                    @error('referral_code')
                                    <span class="invalid-feedback d-block" role="alert"> {{ $message }} </span>
                                    @enderror
                                </div>

                                <div class="sign-in-btn">
                                    <button type="submit" class="btn-1">@lang('Register New Account') <span></span></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



@endsection

@push('css-lib')
@endpush

@push('js-lib')
@endpush

@push('script')
<script>
    'use strict';

    function refreshCaptcha() {
        let img = document.images['captcha_image'];
        img.src = img.src.substring(
            0, img.src.lastIndexOf("?")
        ) + "?rand=" + Math.random() * 1000;
    }


</script>
@endpush

@push('style')
<style>
    @media(max-width: 991px) {
        .footer-copyright {
            margin-bottom: 0 !important;
        }
    }
</style>
@endpush